/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.XMLAccessor;
import org.jagatoo.loaders.models.collada.stax.XMLAsset;
import org.jagatoo.loaders.models.collada.stax.XMLBoolArray;
import org.jagatoo.loaders.models.collada.stax.XMLFloatArray;
import org.jagatoo.loaders.models.collada.stax.XMLIDREFArray;
import org.jagatoo.loaders.models.collada.stax.XMLIntArray;
import org.jagatoo.loaders.models.collada.stax.XMLNameArray;
import org.jagatoo.logging.JAGTLog;

public class XMLSource {
    public XMLAsset asset = null;
    public String id = null;
    public String name = null;
    public XMLBoolArray boolArray = null;
    public XMLFloatArray floatArray = null;
    public XMLIntArray intArray = null;
    public XMLNameArray nameArray = null;
    public XMLIDREFArray idrefArray = null;
    public TechniqueCommon techniqueCommon = null;

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        Location loc = parser.getLocation();
        if (!this.doParsing(parser)) {
            JAGTLog.exception(loc.getLineNumber(), ":", loc.getColumnNumber(), " ", this.getClass().getSimpleName(), ": missing any array.");
        }
    }

    private boolean doParsing(XMLStreamReader parser) throws XMLStreamException {
        boolean arrayParsed = false;
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("id")) {
                this.id = parser.getAttributeValue(i);
            } else if (attr.getLocalPart().equals("name")) {
                this.name = parser.getAttributeValue(i);
            } else {
                JAGTLog.println("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("asset")) {
                        this.asset = new XMLAsset();
                        this.asset.parse(parser);
                        break;
                    }
                    if (localName.equals("float_array")) {
                        if (arrayParsed) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " array already processed");
                        }
                        this.floatArray = new XMLFloatArray();
                        this.floatArray.parse(parser);
                        arrayParsed = true;
                        break;
                    }
                    if (localName.equals("int_array")) {
                        if (arrayParsed) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " array already processed");
                        }
                        this.intArray = new XMLIntArray();
                        this.intArray.parse(parser, "int_array");
                        arrayParsed = true;
                        break;
                    }
                    if (localName.equals("bool_array")) {
                        if (arrayParsed) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " array already processed");
                        }
                        this.boolArray = new XMLBoolArray();
                        this.boolArray.parse(parser);
                        arrayParsed = true;
                        break;
                    }
                    if (localName.equals("Name_array")) {
                        if (arrayParsed) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " array already processed");
                        }
                        this.nameArray = new XMLNameArray();
                        this.nameArray.parse(parser);
                        arrayParsed = true;
                        break;
                    }
                    if (localName.equals("IDREF_array")) {
                        if (arrayParsed) {
                            JAGTLog.exception(this.getClass().getSimpleName(), " array already processed");
                        }
                        this.idrefArray = new XMLIDREFArray();
                        this.idrefArray.parse(parser);
                        arrayParsed = true;
                        break;
                    }
                    if (localName.equals("technique_common")) {
                        this.techniqueCommon = new TechniqueCommon();
                        this.techniqueCommon.parse(parser);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("source")) break;
                    return arrayParsed;
                }
            }
            event = parser.next();
        }
        return arrayParsed;
    }

    public static class TechniqueCommon {
        public XMLAccessor accessor = null;

        /*
         * Exception decompiling
         */
        public void parse(XMLStreamReader parser) throws XMLStreamException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

