/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.collada.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jagatoo.loaders.models.collada.stax.StAXHelper;
import org.jagatoo.logging.JAGTLog;

public class XMLSurface {
    public Type type;
    public String initFrom;
    public String format;

    public static Type readTypeString(String typeString) {
        return Type.valueOf("_" + typeString);
    }

    public void parse(XMLStreamReader parser) throws XMLStreamException {
        int i = 0;
        while (i < parser.getAttributeCount()) {
            QName attr = parser.getAttributeName(i);
            if (attr.getLocalPart().equals("type")) {
                this.type = XMLSurface.readTypeString(parser.getAttributeValue(i));
            } else {
                JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Attr tag: ", attr.getLocalPart());
            }
            ++i;
        }
        int event = parser.next();
        while (event != 8) {
            switch (event) {
                case 1: {
                    String localName = parser.getLocalName();
                    if (localName.equals("init_from")) {
                        this.initFrom = StAXHelper.parseText(parser);
                        break;
                    }
                    if (localName.equals("format")) {
                        this.format = StAXHelper.parseText(parser);
                        break;
                    }
                    JAGTLog.exception("Unsupported ", this.getClass().getSimpleName(), " Start tag: ", parser.getLocalName());
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals("surface")) break;
                    return;
                }
            }
            event = parser.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        _1D,
        _2D,
        _3D,
        _CUBE,
        _DEPTH,
        _RECT;

    }
}

