/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.md2;

import java.io.IOException;
import org.jagatoo.util.errorhandling.IncorrectFormatException;
import org.jagatoo.util.streams.LittleEndianDataInputStream;

public class MD2Header {
    public static final int MAGIC_NUMBER = 844121161;
    public final int version;
    public final int skinWidth;
    public final int skinHeight;
    public final int frameSize;
    public final int numSkins;
    public final int numVertices;
    public final int numTexCoords;
    public final int numTriangles;
    public final int numGlCommandBytes;
    public final int numFrames;
    public final int offsetSkins;
    public final int offsetTexCoords;
    public final int offsetTriangles;
    public final int offsetFrames;
    public final int offsetGlCommands;
    public final int offsetEnd;

    private MD2Header(LittleEndianDataInputStream in) throws IOException, IncorrectFormatException {
        int ident = in.readInt();
        if (ident != 844121161) {
            throw new IncorrectFormatException("This is not an MD2 file!");
        }
        this.version = in.readInt();
        if (this.version != 8) {
            throw new IncorrectFormatException("Unsupported MD2 version " + this.version + ". Currently ony version 8 is supported.");
        }
        this.skinWidth = in.readInt();
        this.skinHeight = in.readInt();
        this.frameSize = in.readInt();
        this.numSkins = in.readInt();
        this.numVertices = in.readInt();
        this.numTexCoords = in.readInt();
        this.numTriangles = in.readInt();
        this.numGlCommandBytes = in.readInt() * 4;
        this.numFrames = in.readInt();
        this.offsetSkins = in.readInt();
        this.offsetTexCoords = in.readInt();
        this.offsetTriangles = in.readInt();
        this.offsetFrames = in.readInt();
        this.offsetGlCommands = in.readInt();
        this.offsetEnd = in.readInt();
    }

    public static final MD2Header readHeader(LittleEndianDataInputStream in) throws IOException, IncorrectFormatException {
        return new MD2Header(in);
    }
}

