/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.md2.pak;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.jagatoo.loaders.models.md2.pak.PAKHeader;
import org.jagatoo.loaders.models.md2.pak.PAKListing;
import org.jagatoo.util.streams.RestrictedLengthInputStream;
import org.jagatoo.util.streams.StreamUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAKArchive {
    private PAKListing listing;
    private byte[] data;

    public InputStream getFile(String filename) throws IOException {
        int offset = this.listing.getFileOffset(filename);
        int length = this.listing.getFileLength(filename);
        if (offset == -1) {
            throw new FileNotFoundException("File " + filename + " not found in PAK");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.data);
        ((InputStream)in).skip(offset);
        return new RestrictedLengthInputStream(in, length);
    }

    public List<String> getFilenames() {
        return this.listing.getFilenames();
    }

    public PAKArchive(InputStream in) throws IOException {
        this.data = StreamUtils.buildByteArray(in);
        PAKHeader header = new PAKHeader(this.data);
        this.listing = new PAKListing(header, this.data);
    }

    public PAKArchive(URL url) throws IOException {
        this(url.openStream());
    }

    public PAKArchive(String filename) throws IOException {
        this(new FileInputStream(filename));
    }
}

