/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.ms3d;

import java.io.IOException;
import org.jagatoo.loaders.models.ms3d.utils.BinaryUtils;
import org.jagatoo.util.streams.LittleEndianDataInputStream;
import org.openmali.vecmath2.Colorf;

public class MS3DMaterial {
    public String name;
    public Colorf ambient;
    public Colorf diffuse;
    public Colorf specular;
    public Colorf emissive;
    public float shininess;
    public float transparency;
    public int mode;
    public int[] textureMap = new int[128];
    public int[] alpha = new int[128];

    public MS3DMaterial(LittleEndianDataInputStream in) throws IOException {
        this.name = BinaryUtils.readString(in, 32);
        this.ambient = BinaryUtils.readColorf(in);
        this.diffuse = BinaryUtils.readColorf(in);
        this.specular = BinaryUtils.readColorf(in);
        this.emissive = BinaryUtils.readColorf(in);
        this.shininess = in.readFloat();
        this.transparency = in.readFloat();
        this.mode = in.readUnsignedByte();
        this.textureMap = BinaryUtils.readIntArray(in, this.textureMap.length);
        this.alpha = BinaryUtils.readIntArray(in, this.alpha.length);
    }
}

