/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.obj;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jagatoo.loaders.models.obj.OBJFace;
import org.jagatoo.loaders.models.obj.OBJMaterial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBJFaceList {
    private List<OBJFace> faces = new ArrayList<OBJFace>();
    private List<float[]> verts;
    private List<float[]> normals;
    private List<float[]> texs;
    private boolean texturesUsed = false;
    private boolean normalsUsed = false;
    private boolean supportNormals = true;
    private boolean supportTextures = true;

    public void setFaces(List<OBJFace> faces) {
        this.faces = faces;
    }

    public List<OBJFace> getFaces() {
        return this.faces;
    }

    public List<float[]> getVertexList() {
        return this.verts;
    }

    public List<float[]> getNormalList() {
        return this.normals;
    }

    public List<float[]> getTexList() {
        return this.texs;
    }

    public void setNormalsUsed(boolean used) {
        this.normalsUsed = used;
    }

    public boolean normalsUsed() {
        return this.normalsUsed;
    }

    public boolean normalsSupported() {
        return this.supportNormals;
    }

    public void setTexturesUsed(boolean used) {
        this.texturesUsed = used;
    }

    public boolean texturesUsed() {
        return this.texturesUsed;
    }

    public boolean texturesSupported() {
        return this.supportTextures;
    }

    private int parseInt(String token) {
        if (token.length() == 0) {
            return -1;
        }
        return Integer.parseInt(token);
    }

    private int parseVertIndex(String token) {
        if (token.indexOf("/") >= 0) {
            return this.parseInt(token.substring(0, token.indexOf("/")));
        }
        return this.parseInt(token);
    }

    private int parseTextureIndex(String token) {
        int slashPos = token.indexOf("/");
        if (slashPos < 0) {
            return -1;
        }
        if ((slashPos = (token = token.substring(slashPos + 1)).indexOf("/")) >= 0) {
            int result = this.parseInt(token.substring(0, slashPos));
            if (result != -1) {
                this.texturesUsed = true;
            }
            return result;
        }
        int result = this.parseInt(token);
        if (result != -1) {
            this.texturesUsed = true;
        }
        return result;
    }

    private int parseNormalIndex(String token) {
        if (token.indexOf("/") < 0) {
            return -1;
        }
        if ((token = token.substring(token.indexOf("/") + 1)).indexOf("/") < 0) {
            return -1;
        }
        if ((token = token.substring(token.indexOf("/") + 1)).indexOf("/") >= 0) {
            int result = this.parseInt(token.substring(0, token.indexOf("/")));
            if (result != -1) {
                this.normalsUsed = true;
            }
            return result;
        }
        int result = this.parseInt(token);
        if (result != -1) {
            this.normalsUsed = true;
        }
        return result;
    }

    public void add(String line, OBJMaterial mat) {
        StringTokenizer tokens = new StringTokenizer(line);
        OBJFace face = new OBJFace(this, tokens.countTokens() - 1, mat);
        tokens.nextToken();
        while (tokens.hasMoreTokens()) {
            String pt = tokens.nextToken();
            int vi = this.parseVertIndex(pt);
            int ti = this.parseTextureIndex(pt);
            int ni = this.parseNormalIndex(pt);
            face.add(vi > 0 ? vi - 1 : -1, ni > 0 ? ni - 1 : -1, ti > 0 ? ti - 1 : -1);
        }
        this.faces.add(face);
    }

    public OBJFaceList(List<float[]> verts, List<float[]> normals, List<float[]> texs) {
        this.verts = verts;
        this.normals = normals;
        this.texs = texs;
    }
}

