/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.chunks.processors;

import java.io.IOException;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.TDSFile;
import org.jagatoo.loaders.models.tds.chunks.processors.ChunkProcessor;
import org.jagatoo.loaders.models.tds.internal.ModelContext;
import org.openmali.spatial.bounds.BoundsType;

public class NamedObjectProcessor
extends ChunkProcessor {
    public void process(TDSFile file, AppearanceFactory appFactory, GeometryFactory geomFactory, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, ModelContext context, int length) throws IOException {
        context.composeAppearance(appFactory);
        context.createUnsmoothedFaces(geomFactory, nodeFactory);
        context.meshDataBegun = true;
        context.objectName = file.readName();
        if (file.hiddenObject(context.objectName)) {
            file.skipChunk(length - context.objectName.length() - 1);
            return;
        }
        context.shape = nodeFactory.createShape(context.objectName, null, null, BoundsType.SPHERE);
        file.processChunk();
        siHandler.addSpecialItem(SpecialItemsHandler.SpecialItemType.SHAPE, context.shape.getName(), context.shape);
        context.objectTable.put(context.objectName, context.shape);
        context.unanimatedNodes.add(context.shape);
    }
}

