/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.chunks.processors;

import java.io.IOException;
import org.jagatoo.loaders.models._util.AnimationFactory;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models._util.SpecialItemsHandler;
import org.jagatoo.loaders.models.tds.TDSFile;
import org.jagatoo.loaders.models.tds.chunks.processors.TransformTrackProcessor;
import org.jagatoo.loaders.models.tds.internal.ModelContext;
import org.jagatoo.loaders.models.tds.internal.ScaleTransform;
import org.jagatoo.logging.JAGTLog;
import org.openmali.vecmath2.Tuple3f;

public class SclTrackProcessor
extends TransformTrackProcessor {
    public void process(TDSFile file, AppearanceFactory appFactory, GeometryFactory geomFactory, NodeFactory nodeFactory, AnimationFactory animFactory, SpecialItemsHandler siHandler, ModelContext context, int length) throws IOException {
        file.readUnsignedShort();
        file.skipBytes(8);
        int numKeys = file.readUnsignedInt();
        context.scale = new ScaleTransform();
        JAGTLog.debug("Scale key frames: ", numKeys);
        int i = 0;
        while (i < numKeys) {
            int frameNumber = file.readUnsignedInt();
            file.readUnsignedShort();
            float x = file.readFloat();
            float y = file.readFloat();
            float z = file.readFloat();
            Tuple3f scale = numKeys == 1 && x == 1.0f && y == 1.0f && z == 1.0f ? null : new Tuple3f(x, y, z);
            JAGTLog.debug("\tScale key frame: ", String.valueOf(frameNumber) + " : ", scale);
            context.scale.addKeyFrame(frameNumber, (float)frameNumber / (float)context.framesCount, scale);
            ++i;
        }
        if (file.hiddenObject(context.nodeName)) {
            return;
        }
        SclTrackProcessor.checkAndApplyTransform(context, false, nodeFactory, animFactory, siHandler, file.convertZup2Yup());
    }
}

