/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.tds.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.jagatoo.datatypes.NamedObject;
import org.jagatoo.loaders.models._util.AppearanceFactory;
import org.jagatoo.loaders.models._util.GeometryFactory;
import org.jagatoo.loaders.models._util.NodeFactory;
import org.jagatoo.loaders.models.tds.internal.Face;
import org.jagatoo.loaders.models.tds.internal.PosTransform;
import org.jagatoo.loaders.models.tds.internal.RotTransform;
import org.jagatoo.loaders.models.tds.internal.ScaleTransform;
import org.jagatoo.loaders.models.tds.internal.Surface;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Vector3f;

public class ModelContext {
    public int totalVerts;
    public int totalFaces;
    public float transparency;
    public String objectName;
    public NamedObject shape;
    public Point3f[] vertexCoords;
    public ArrayList<Face>[] sharedFaces;
    public Surface[] surfaces;
    public TexCoord2f[] textureCoords;
    public int numberOfVerts;
    public HashMap<String, NamedObject> objectTable = new HashMap();
    public HashMap<Integer, NamedObject> nodeIDMap = new HashMap();
    public HashSet<NamedObject> unanimatedNodes = new HashSet();
    public ArrayList<NamedObject> rootNodes = new ArrayList();
    public ArrayList<NamedObject> nestedNodes = new ArrayList();
    public ArrayList<Object> animControllers = new ArrayList();
    public HashMap<String, ModelContext> instanceTable = new HashMap();
    public Face[] faces;
    public int numberOfFaces;
    public NamedObject geometry;
    public RotTransform orientation;
    public ScaleTransform scale;
    public PosTransform translation;
    public String instanceName;
    public String nodeName;
    public int nodeID;
    public int father;
    public HashMap<String, NamedObject> appearanceMap = new HashMap();
    public HashMap<FaceCullMode, NamedObject> faceCullPolyAttribsCache = new HashMap();
    public NamedObject textureAttributes = null;
    public NamedObject coloringAttributes = null;
    public FaceCullMode faceCullMode = null;
    public NamedObject material = null;
    public float shininess;
    public String appName = null;
    public NamedObject appearance;
    public boolean meshDataBegun = false;
    public boolean facesCreated = false;
    public boolean animationFound = false;
    public Point3f pivot;
    public int framesCount;

    public void composeAppearance(AppearanceFactory appFactory) {
        if (this.appearance == null || this.meshDataBegun) {
            return;
        }
        appFactory.applyMaterial(this.material, this.appearance);
        if (this.textureAttributes != null) {
            appFactory.applyTextureAttributes(this.textureAttributes, 0, this.appearance);
        }
        if (this.coloringAttributes != null) {
            appFactory.applyColoringAttributes(this.coloringAttributes, this.appearance);
        }
        if (this.faceCullMode != null) {
            NamedObject polyAttribs = this.faceCullPolyAttribsCache.get((Object)this.faceCullMode);
            if (polyAttribs == null) {
                polyAttribs = appFactory.createPolygonAttributes("");
                appFactory.setPolygonAttribsFaceCullMode(polyAttribs, this.faceCullMode);
                this.faceCullPolyAttribsCache.put(this.faceCullMode, polyAttribs);
            }
            appFactory.applyPolygonAttributes(polyAttribs, this.appearance);
        }
        this.textureAttributes = null;
        this.coloringAttributes = null;
        this.faceCullMode = null;
        this.material = null;
        this.appName = null;
        this.appearance = null;
    }

    public void applyAppearanceAttributes(NodeFactory nodeFactory) {
        if (this.appearance == null || this.shape == null) {
            return;
        }
        nodeFactory.applyAppearanceToShape(this.appearance, this.shape);
        this.appearance = null;
    }

    private void prepareForNewObject() {
        this.geometry = null;
        this.numberOfVerts = 0;
        this.vertexCoords = null;
        this.textureCoords = null;
        this.sharedFaces = null;
        this.numberOfFaces = 0;
        this.faces = null;
        this.nodeName = null;
        this.nodeID = -1;
        this.father = -1;
        this.instanceName = null;
        this.translation = null;
        this.orientation = null;
        this.scale = null;
        this.facesCreated = false;
        this.pivot = new Point3f(0.0f, 0.0f, 0.0f);
        this.orientation = null;
        this.scale = null;
        this.translation = null;
        this.textureAttributes = null;
        this.coloringAttributes = null;
        this.material = null;
        this.faceCullMode = null;
        this.appearance = null;
    }

    public void createUnsmoothedFaces(GeometryFactory geomFactory, NodeFactory nodeFactory) {
        if (!this.facesCreated && this.numberOfFaces > 0) {
            Point3f[] coords = new Point3f[this.numberOfVerts];
            Vector3f[] normals = new Vector3f[this.numberOfVerts];
            TexCoord2f[] texCoords = new TexCoord2f[this.numberOfVerts];
            int i = 0;
            while (i < this.numberOfFaces) {
                Face f = this.faces[i];
                coords[f.getCoordAIndex()] = f.getCoordA();
                coords[f.getCoordBIndex()] = f.getCoordB();
                coords[f.getCoordCIndex()] = f.getCoordC();
                normals[f.getCoordAIndex()] = f.getNormal();
                normals[f.getCoordBIndex()] = f.getNormal();
                normals[f.getCoordCIndex()] = f.getNormal();
                if (this.textureCoords != null) {
                    texCoords[f.getCoordAIndex()] = this.textureCoords[f.getCoordAIndex()];
                    texCoords[f.getCoordBIndex()] = this.textureCoords[f.getCoordBIndex()];
                    texCoords[f.getCoordCIndex()] = this.textureCoords[f.getCoordCIndex()];
                }
                ++i;
            }
            GeometryFactory.GeometryType geomType = GeometryFactory.GeometryType.INDEXED_TRIANGLE_ARRAY;
            int i2 = 0;
            while (i2 < coords.length) {
                geomFactory.setCoordinate(this.geometry, geomType, i2, coords[i2].getX(), coords[i2].getY(), coords[i2].getZ());
                geomFactory.setNormal(this.geometry, geomType, i2, normals[i2].getX(), normals[i2].getY(), normals[i2].getZ());
                if (this.textureCoords != null) {
                    geomFactory.setTexCoord(this.geometry, geomType, 0, i2, texCoords[i2].getS(), texCoords[i2].getT());
                }
                ++i2;
            }
        }
        if (this.shape != null) {
            this.applyAppearanceAttributes(nodeFactory);
        }
        this.prepareForNewObject();
    }
}

