/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jagatoo.image.BufferedImageFactory;
import org.jagatoo.image.SharedBufferedImage;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoader;
import org.jagatoo.util.image.ImageUtility;
import org.jagatoo.util.streams.StreamUtils;

public class TextureImageFormatLoaderSGI
implements TextureImageFormatLoader {
    public static final int HEADER_SIZE = 512;
    public static final short MAGIC_NUMBER = 474;

    private static void transferScaledBytes(byte[] unscaledData, int bytesPerPixel, ByteBuffer bb, int orgWidth, int orgHeight, int width, int height) {
        SharedBufferedImage sbi = BufferedImageFactory.createSharedBufferedImage(orgWidth, orgHeight, bytesPerPixel, null, unscaledData);
        SharedBufferedImage sbi_scaled = ImageUtility.scaleImage(sbi, width, height, bytesPerPixel == 4);
        byte[] scaledData = sbi_scaled.getSharedData();
        int i = 0;
        while (i < scaledData.length) {
            bb.put(scaledData[i + 2]);
            bb.put(scaledData[i + 1]);
            bb.put(scaledData[i + 0]);
            if (bytesPerPixel == 4) {
                bb.put(scaledData[i + 3]);
            }
            i += bytesPerPixel;
        }
    }

    /*
     * Unable to fully structure code
     */
    public AbstractTextureImage loadTextureImage(BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        block25: {
            block24: {
                if (in.available() < 512) {
                    return null;
                }
                magicNumber = StreamUtils.readShort(in);
                if (magicNumber != 474) {
                    return null;
                }
                header = new SGIHeader(in);
                orgWidth = header.xSize;
                orgHeight = header.ySize;
                width = ImageUtility.roundUpPower2(orgWidth);
                height = ImageUtility.roundUpPower2(orgHeight);
                bytesPerPixel = header.zSize;
                isTransparent = bytesPerPixel == 4;
                isCompressed = header.storage == 1;
                image = texFactory.createTextureImage(width, height, orgWidth, orgHeight, isTransparent != false && acceptAlpha != false ? 4 : 3);
                bb = image.getDataBuffer();
                bb.limit(bb.capacity());
                byteOffset0 = bb.position();
                dstBytesPerPixel = image.getPixelSize();
                imageData = null;
                if ((width != orgWidth || height != orgHeight) && allowStreching) {
                    imageData = new byte[orgWidth * orgHeight * dstBytesPerPixel];
                }
                if (!isCompressed) break block24;
                numScanLines = orgHeight * bytesPerPixel;
                scanlineOffsets = new int[numScanLines];
                scanlineLengths = new int[numScanLines];
                i = 0;
                while (i < numScanLines) {
                    scanlineOffsets[i] = StreamUtils.readInt(in) - 512 - 8 * numScanLines;
                    ++i;
                }
                i = 0;
                while (i < numScanLines) {
                    scanlineLengths[i] = StreamUtils.readInt(in);
                    ++i;
                }
                if (header.bpc != 1) break block25;
                compressedImageSize = scanlineOffsets[0] + scanlineLengths[0];
                nIndex = 1;
                while (nIndex < numScanLines) {
                    reqBytes = scanlineOffsets[nIndex] + scanlineLengths[nIndex];
                    if (reqBytes > compressedImageSize) {
                        compressedImageSize = reqBytes;
                    }
                    ++nIndex;
                }
                compressedImageData = new byte[compressedImageSize];
                numBytesSoFar = 0;
                c = 0;
                while (c < bytesPerPixel) {
                    pixelIndex = 0;
                    y = orgHeight - 1;
                    while (y >= 0) {
                        rleDataIndex = y + c * orgHeight;
                        offsetRLE = scanlineOffsets[rleDataIndex];
                        reqBytes = offsetRLE + scanlineLengths[rleDataIndex];
                        while (reqBytes > numBytesSoFar && (numBytesRead = in.read(compressedImageData, numBytesSoFar, reqBytes - numBytesSoFar)) != -1) {
                            numBytesSoFar += numBytesRead;
                        }
                        offset = flipVertically != false ? y * orgWidth : 0;
                        x = 0;
                        while ((count = (byte)((start = compressedImageData[offsetRLE++]) & 127)) != 0) {
                            block26: {
                                if ((start & 128) != 128) break block26;
                                if (true) ** GOTO lbl73
                                do {
                                    pos = flipVertically != false ? (offset + x) * dstBytesPerPixel + c : pixelIndex * dstBytesPerPixel + c;
                                    if (imageData == null) {
                                        bb.put(byteOffset0 + pos, compressedImageData[offsetRLE++]);
                                    } else {
                                        imageData[pos] = compressedImageData[offsetRLE++];
                                    }
                                    ++pixelIndex;
                                    ++x;
lbl73:
                                    // 2 sources

                                    v0 = count;
                                    count = (byte)(v0 - 1);
                                } while (v0 > 0);
                                continue;
                            }
                            b = compressedImageData[offsetRLE++];
                            if (true) ** GOTO lbl89
                            do {
                                pos = flipVertically != false ? (offset + x) * dstBytesPerPixel + c : pixelIndex * dstBytesPerPixel + c;
                                if (imageData == null) {
                                    bb.put(byteOffset0 + pos, b);
                                } else {
                                    imageData[pos] = b;
                                }
                                ++pixelIndex;
                                ++x;
lbl89:
                                // 2 sources

                                v1 = count;
                                count = (byte)(v1 - 1);
                            } while (v1 > 0);
                        }
                        --y;
                    }
                    ++c;
                }
                break block25;
            }
            if (header.bpc == 1) {
                srcScanlineSize = orgWidth * bytesPerPixel;
                trgScanlineSize = orgWidth * dstBytesPerPixel;
                c = 0;
                while (c < bytesPerPixel) {
                    y = 0;
                    while (y < orgHeight) {
                        offset = flipVertically != false ? y * trgScanlineSize : (orgHeight - y - 1) * trgScanlineSize;
                        x = 0;
                        while (x < srcScanlineSize) {
                            pos = offset + x + c;
                            if (imageData == null) {
                                bb.put(byteOffset0 + pos, StreamUtils.readByte(in));
                            } else {
                                imageData[pos] = StreamUtils.readByte(in);
                            }
                            x += bytesPerPixel;
                        }
                        ++y;
                    }
                    ++c;
                }
            }
        }
        if (imageData != null) {
            TextureImageFormatLoaderSGI.transferScaledBytes(imageData, dstBytesPerPixel, bb, orgWidth, orgHeight, width, height);
        }
        bb.position(0);
        bb.limit(byteOffset0 + width * height * dstBytesPerPixel);
        return image;
    }

    private static class SGIHeader {
        public static final int IMAGE_NAME_SIZE = 80;
        public byte storage;
        public byte bpc;
        public int xSize;
        public int ySize;
        public int zSize;

        public SGIHeader(BufferedInputStream in) throws IOException {
            this.storage = StreamUtils.readByte(in);
            this.bpc = StreamUtils.readByte(in);
            in.skip(2L);
            this.xSize = StreamUtils.readUnsignedShort(in);
            this.ySize = StreamUtils.readUnsignedShort(in);
            this.zSize = StreamUtils.readUnsignedShort(in);
            in.skip(8L);
            in.skip(4L);
            in.skip(80L);
            in.skip(4L);
            in.skip(404L);
        }
    }
}

