/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.formats;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jagatoo.image.BufferedImageFactory;
import org.jagatoo.image.SharedBufferedImage;
import org.jagatoo.loaders.textures.AbstractTextureImage;
import org.jagatoo.loaders.textures.TextureFactory;
import org.jagatoo.loaders.textures.formats.TextureImageFormatLoader;
import org.jagatoo.util.image.ImageUtility;
import org.jagatoo.util.streams.StreamUtils;

public class TextureImageFormatLoaderTGA
implements TextureImageFormatLoader {
    private static final int HEADER_SIZE = 18;
    private static final int HEADER_INVALID = 0;
    private static final int HEADER_UNCOMPRESSED = 1;
    private static final int HEADER_COMPRESSED = 2;

    private static final short getUnsignedByte(byte[] bytes, int byteIndex) {
        return (short)(bytes[byteIndex] & 0xFF);
    }

    private static final int getUnsignedShort(byte[] bytes, int byteIndex) {
        return (TextureImageFormatLoaderTGA.getUnsignedByte(bytes, byteIndex + 1) << 8) + TextureImageFormatLoaderTGA.getUnsignedByte(bytes, byteIndex + 0);
    }

    private static void readBuffer(BufferedInputStream in, byte[] buffer) throws IOException {
        int bytesRead = 0;
        int bytesToRead = buffer.length;
        while (bytesToRead > 0) {
            int read = in.read(buffer, bytesRead, bytesToRead);
            bytesRead += read;
            bytesToRead -= read;
        }
    }

    private static final int compareFormatHeader(BufferedInputStream in, byte[] header) throws IOException {
        TextureImageFormatLoaderTGA.readBuffer(in, header);
        boolean hasPalette = false;
        int result = 0;
        short imgIDSize = TextureImageFormatLoaderTGA.getUnsignedByte(header, 0);
        if (header[1] != 0 && header[1] != 1) {
            return 0;
        }
        switch (TextureImageFormatLoaderTGA.getUnsignedByte(header, 2)) {
            case 0: {
                result = 1;
                break;
            }
            case 1: {
                hasPalette = true;
                result = 1;
                System.err.println("Indexed TGA is not yet supported!");
                return 0;
            }
            case 2: {
                result = 1;
                break;
            }
            case 3: {
                result = 1;
                break;
            }
            case 9: {
                hasPalette = true;
                result = 2;
                System.err.println("Indexed TGA is not yet supported!");
                return 0;
            }
            case 10: {
                result = 2;
                break;
            }
            case 11: {
                result = 2;
                break;
            }
            default: {
                return 0;
            }
        }
        if (!hasPalette && TextureImageFormatLoaderTGA.getUnsignedShort(header, 3) != 0) {
            return 0;
        }
        if (!hasPalette && TextureImageFormatLoaderTGA.getUnsignedShort(header, 5) != 0) {
            return 0;
        }
        short paletteEntrySize = TextureImageFormatLoaderTGA.getUnsignedByte(header, 7);
        if (!hasPalette ? paletteEntrySize != 0 : paletteEntrySize != 15 && paletteEntrySize != 16 && paletteEntrySize != 24 && paletteEntrySize != 32) {
            return 0;
        }
        if (TextureImageFormatLoaderTGA.getUnsignedShort(header, 8) != 0) {
            return 0;
        }
        if (TextureImageFormatLoaderTGA.getUnsignedShort(header, 10) != 0) {
            return 0;
        }
        switch (TextureImageFormatLoaderTGA.getUnsignedByte(header, 16)) {
            case 1: 
            case 8: 
            case 15: 
            case 16: {
                System.err.println("TGAs with non RGB or RGBA pixels are not yet supported.");
                return 0;
            }
            case 24: 
            case 32: {
                break;
            }
            default: {
                return 0;
            }
        }
        if (imgIDSize != 0) {
            StreamUtils.skipBytes(in, (long)imgIDSize);
        }
        return result;
    }

    private static void readBuffer(BufferedInputStream in, int width, int height, int srcBytesPerPixel, boolean acceptAlpha, boolean flipVertically, byte[] bb) throws IOException {
        byte[] buffer = new byte[srcBytesPerPixel];
        boolean copyAlpha = srcBytesPerPixel == 4 && acceptAlpha;
        int dstBytesPerPixel = acceptAlpha ? srcBytesPerPixel : 3;
        int trgLineSize = width * dstBytesPerPixel;
        int dstByteOffset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int read = in.read(buffer, 0, srcBytesPerPixel);
                if (read < srcBytesPerPixel) {
                    return;
                }
                int actualByteOffset = dstByteOffset;
                if (!flipVertically) {
                    actualByteOffset = (height - y - 1) * trgLineSize + x * dstBytesPerPixel;
                }
                bb[actualByteOffset + 0] = buffer[0];
                bb[actualByteOffset + 1] = buffer[1];
                bb[actualByteOffset + 2] = buffer[2];
                if (copyAlpha) {
                    bb[actualByteOffset + 3] = buffer[3];
                }
                dstByteOffset += dstBytesPerPixel;
                ++x;
            }
            ++y;
        }
    }

    private static void readBuffer(BufferedInputStream in, int width, int height, int srcBytesPerPixel, boolean acceptAlpha, boolean flipVertically, ByteBuffer bb, int byteOffset0) throws IOException {
        byte[] buffer = new byte[srcBytesPerPixel];
        boolean copyAlpha = srcBytesPerPixel == 4 && acceptAlpha;
        int dstBytesPerPixel = acceptAlpha ? srcBytesPerPixel : 3;
        int trgLineSize = width * dstBytesPerPixel;
        int dstByteOffset = 0;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int read = in.read(buffer, 0, srcBytesPerPixel);
                if (read < srcBytesPerPixel) {
                    return;
                }
                int actualByteOffset = dstByteOffset;
                if (!flipVertically) {
                    actualByteOffset = (height - y - 1) * trgLineSize + x * dstBytesPerPixel;
                }
                bb.put(byteOffset0 + actualByteOffset + 0, buffer[2]);
                bb.put(byteOffset0 + actualByteOffset + 1, buffer[1]);
                bb.put(byteOffset0 + actualByteOffset + 2, buffer[0]);
                if (copyAlpha) {
                    bb.put(byteOffset0 + actualByteOffset + 3, buffer[3]);
                }
                dstByteOffset += dstBytesPerPixel;
                ++x;
            }
            ++y;
        }
    }

    private static void transferScaledBytes(byte[] unscaledData, int bytesPerPixel, ByteBuffer bb, int orgWidth, int orgHeight, int width, int height) {
        SharedBufferedImage sbi = BufferedImageFactory.createSharedBufferedImage(orgWidth, orgHeight, bytesPerPixel, null, unscaledData);
        SharedBufferedImage sbi_scaled = ImageUtility.scaleImage(sbi, width, height, bytesPerPixel == 4);
        byte[] scaledData = sbi_scaled.getSharedData();
        int i = 0;
        while (i < scaledData.length) {
            bb.put(scaledData[i + 2]);
            bb.put(scaledData[i + 1]);
            bb.put(scaledData[i + 0]);
            if (bytesPerPixel == 4) {
                bb.put(scaledData[i + 3]);
            }
            i += bytesPerPixel;
        }
    }

    private AbstractTextureImage loadUncompressedTGA(byte[] header, BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        boolean isOriginBottom;
        int orgWidth = TextureImageFormatLoaderTGA.getUnsignedShort(header, 12);
        int orgHeight = TextureImageFormatLoaderTGA.getUnsignedShort(header, 14);
        short bpp = TextureImageFormatLoaderTGA.getUnsignedByte(header, 16);
        boolean bl = isOriginBottom = (header[17] & 0x20) == 0;
        if (!isOriginBottom) {
            boolean bl2 = flipVertically = !flipVertically;
        }
        if (orgWidth <= 0 || orgHeight <= 0 || bpp != 24 && bpp != 32) {
            throw new IOException("Invalid texture information");
        }
        int bytesPerPixel = bpp / 8;
        int width = ImageUtility.roundUpPower2(orgWidth);
        int height = ImageUtility.roundUpPower2(orgHeight);
        AbstractTextureImage image = texFactory.createTextureImage(width, height, orgWidth, orgHeight, acceptAlpha ? bytesPerPixel : 3);
        ByteBuffer bb = image.getDataBuffer();
        bb.limit(bb.capacity());
        int byteOffset0 = bb.position();
        if ((width != orgWidth || height != orgHeight) && allowStreching) {
            byte[] imageData = new byte[orgWidth * orgHeight * (acceptAlpha ? bytesPerPixel : 3)];
            TextureImageFormatLoaderTGA.readBuffer(in, orgWidth, orgHeight, bytesPerPixel, acceptAlpha, flipVertically, imageData);
            TextureImageFormatLoaderTGA.transferScaledBytes(imageData, acceptAlpha ? bytesPerPixel : 3, bb, orgWidth, orgHeight, width, height);
        } else {
            TextureImageFormatLoaderTGA.readBuffer(in, orgWidth, orgHeight, bytesPerPixel, acceptAlpha, flipVertically, bb, byteOffset0);
        }
        bb.position(0);
        bb.limit(width * height * image.getFormat().getPixelSize());
        return image;
    }

    private AbstractTextureImage loadCompressedTGA(byte[] header, BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        boolean isOriginBottom;
        int orgWidth = TextureImageFormatLoaderTGA.getUnsignedShort(header, 12);
        int orgHeight = TextureImageFormatLoaderTGA.getUnsignedShort(header, 14);
        short bpp = TextureImageFormatLoaderTGA.getUnsignedByte(header, 16);
        boolean bl = isOriginBottom = (header[17] & 0x20) == 0;
        if (!isOriginBottom) {
            boolean bl2 = flipVertically = !flipVertically;
        }
        if (orgWidth <= 0 || orgHeight <= 0 || bpp != 24 && bpp != 32) {
            throw new IOException("Invalid texture information");
        }
        int bytesPerPixel = bpp / 8;
        int pixelCount = orgHeight * orgWidth;
        int currentPixel = 0;
        byte[] colorBuffer = new byte[bytesPerPixel];
        int width = ImageUtility.roundUpPower2(orgWidth);
        int height = ImageUtility.roundUpPower2(orgHeight);
        AbstractTextureImage image = texFactory.createTextureImage(width, height, orgWidth, orgHeight, acceptAlpha ? bytesPerPixel : 3);
        ByteBuffer bb = image.getDataBuffer();
        bb.limit(bb.capacity());
        int byteOffset0 = bb.position();
        int dstBytesPerPixel = image.getFormat().getPixelSize();
        int trgLineSize = orgWidth * dstBytesPerPixel;
        byte[] imageData = null;
        int dstByteOffset = 0;
        if ((width != orgWidth || height != orgHeight) && allowStreching) {
            imageData = new byte[orgWidth * orgHeight * (acceptAlpha ? bytesPerPixel : 3)];
        }
        do {
            boolean repeatColor;
            int chunkHeader = 0;
            try {
                chunkHeader = (byte)in.read() & 0xFF;
            }
            catch (IOException e) {
                throw new IOException("Could not read RLE header");
            }
            if (chunkHeader < 128) {
                ++chunkHeader;
                repeatColor = false;
            } else {
                chunkHeader -= 127;
                TextureImageFormatLoaderTGA.readBuffer(in, colorBuffer);
                repeatColor = true;
            }
            int counter = 0;
            while (counter < chunkHeader) {
                if (!repeatColor) {
                    TextureImageFormatLoaderTGA.readBuffer(in, colorBuffer);
                }
                int x = currentPixel % orgWidth;
                int y = currentPixel / orgWidth;
                int actualByteOffset = dstByteOffset;
                if (!flipVertically) {
                    actualByteOffset = (height - y - 1) * trgLineSize + x * dstBytesPerPixel;
                }
                if (imageData == null) {
                    bb.put(byteOffset0 + actualByteOffset + 0, colorBuffer[2]);
                    bb.put(byteOffset0 + actualByteOffset + 1, colorBuffer[1]);
                    bb.put(byteOffset0 + actualByteOffset + 2, colorBuffer[0]);
                    if (dstBytesPerPixel == 4) {
                        bb.put(byteOffset0 + actualByteOffset + 3, colorBuffer[3]);
                    }
                } else {
                    System.arraycopy(colorBuffer, 0, imageData, actualByteOffset, dstBytesPerPixel);
                }
                dstByteOffset += dstBytesPerPixel;
                if (++currentPixel > pixelCount) {
                    throw new IOException("Too many pixels read");
                }
                ++counter;
            }
        } while (currentPixel < pixelCount);
        if (imageData != null) {
            TextureImageFormatLoaderTGA.transferScaledBytes(imageData, dstBytesPerPixel, bb, orgWidth, orgHeight, width, height);
        }
        bb.position(0);
        bb.limit(byteOffset0 + width * height * dstBytesPerPixel);
        return image;
    }

    public AbstractTextureImage loadTextureImage(BufferedInputStream in, boolean acceptAlpha, boolean flipVertically, boolean allowStreching, TextureFactory texFactory) throws IOException {
        if (in.available() < 18) {
            return null;
        }
        byte[] header = new byte[18];
        int headerType = TextureImageFormatLoaderTGA.compareFormatHeader(in, header);
        if (headerType == 0) {
            return null;
        }
        AbstractTextureImage image = null;
        if (headerType == 1) {
            image = this.loadUncompressedTGA(header, in, acceptAlpha, flipVertically, allowStreching, texFactory);
        } else if (headerType == 2) {
            image = this.loadCompressedTGA(header, in, acceptAlpha, flipVertically, allowStreching, texFactory);
        } else {
            return null;
        }
        return image;
    }
}

