/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.textures.pixelprocessing;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import org.jagatoo.loaders.textures.pixelprocessing.PixelProcessor;
import org.jagatoo.opengl.enums.TextureImageFormat;

public class PixelProcessorRGB
extends PixelProcessor {
    private static final PixelProcessorRGB instance = new PixelProcessorRGB();

    public static PixelProcessorRGB getInstance() {
        return instance;
    }

    public final TextureImageFormat getTextureImageFormat() {
        return TextureImageFormat.RGB;
    }

    public int readImageData(BufferedImage img, int startX, int startY, int width, int height, ByteBuffer trg, int trgOffset, boolean flipVertically) {
        ColorModel cm = img.getColorModel();
        WritableRaster r = img.getRaster();
        int trgLineSize = this.getLineSize(width);
        int trgOffset0 = trgOffset;
        trg.position(trgOffset0);
        trg.limit(trg.capacity());
        switch (img.getType()) {
            case 1: 
            case 2: {
                Object data = new int[width];
                int y = 0;
                while (y < height) {
                    int trgOffsetX = trgOffset;
                    int realY = startY + (flipVertically ? height - 1 - y : y);
                    r.getDataElements(startX, realY, width, 1, data);
                    int x = 0;
                    while (x < width) {
                        int rgb = data[x];
                        trg.put(trgOffsetX++, (byte)(rgb >> 16));
                        trg.put(trgOffsetX++, (byte)(rgb >> 8));
                        trg.put(trgOffsetX++, (byte)rgb);
                        ++x;
                    }
                    trgOffset += trgLineSize;
                    ++y;
                }
                break;
            }
            default: {
                Object data = null;
                int y = 0;
                while (y < height) {
                    int trgOffsetX = trgOffset;
                    int realY = startY + (flipVertically ? height - 1 - y : y);
                    int x = 0;
                    while (x < width) {
                        data = r.getDataElements(startX + x, realY, data);
                        trg.put(trgOffsetX++, (byte)cm.getRed(data));
                        trg.put(trgOffsetX++, (byte)cm.getGreen(data));
                        trg.put(trgOffsetX++, (byte)cm.getBlue(data));
                        ++x;
                    }
                    trgOffset += trgLineSize;
                    ++y;
                }
                break block0;
            }
        }
        int dataSize = height * trgLineSize;
        trg.position(0);
        trg.limit(trgOffset0 + dataSize);
        return dataSize;
    }

    private PixelProcessorRGB() {
        super(3);
    }
}

