/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.logging;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.LogInterface;

public class FileLog
implements LogInterface {
    private int logLevel;
    private int channelFilter;
    private final FileOutputStream out;
    private final PrintStream prn;

    public final void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public final int getLogLevel() {
        return this.logLevel;
    }

    public final void setChannelFilter(int filter) {
        this.channelFilter = filter;
    }

    public final int getChannelFilter() {
        return this.channelFilter;
    }

    public final boolean acceptsChannel(LogChannel channel) {
        return (this.channelFilter & channel.getID()) > 0;
    }

    public void print(LogChannel channel, int logLevel, String message) {
        if (this.acceptsChannel(channel) && logLevel <= this.logLevel) {
            this.prn.print(message);
        }
    }

    public void println(LogChannel channel, int logLevel, String message) {
        if (this.acceptsChannel(channel) && logLevel <= this.logLevel) {
            this.prn.println(message);
        }
    }

    public void flush() {
        this.prn.flush();
    }

    public void close() {
        try {
            this.out.close();
            this.prn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public FileLog(int channelFilter, int logLevel, String filename) throws FileNotFoundException {
        this.logLevel = logLevel;
        this.channelFilter = channelFilter;
        this.out = new FileOutputStream(filename);
        this.prn = new PrintStream(this.out, true);
    }

    public FileLog(int logLevel, String filename) throws FileNotFoundException {
        this(-1, logLevel, filename);
    }

    public FileLog(String filename) throws FileNotFoundException {
        this(-1, 0, filename);
    }
}

