/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.lists;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jagatoo.datatypes.Chainable;
import org.jagatoo.datatypes.DoublyChainable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedList<E extends DoublyChainable<E>>
implements List<E>,
Queue<E> {
    private E head = null;
    private E tail = null;
    private int size = 0;

    public ChainedList() {
    }

    public ChainedList(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public E getHead() {
        return this.head;
    }

    public E getTail() {
        return this.tail;
    }

    public E removeHead() {
        return (E)this.remove(0);
    }

    public E removeTail() {
        E result = this.tail;
        if (this.tail != null) {
            this.remove(this.tail);
        }
        return result;
    }

    public void addHead(E o) {
        this.addBefore(o, this.head);
    }

    public void append(E o) {
        if (this.tail == null) {
            this.head = o;
            o.setPrevious(null);
        } else {
            this.tail.setNext(o);
            o.setPrevious(this.tail);
        }
        this.tail = o;
        o.setNext(null);
        ++this.size;
    }

    @Override
    public boolean add(E o) {
        this.append(o);
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index >= this.size) {
            this.append(element);
            return;
        }
        this.addBefore(element, this.get(index));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Iterator<E> it = c.iterator();
        while (it.hasNext()) {
            this.append((DoublyChainable)it.next());
        }
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        if (index >= this.size) {
            return this.addAll(c);
        }
        Object elem = this.get(index);
        DoublyChainable prev = (DoublyChainable)elem.getPrevious();
        E oldTail = this.getTail();
        this.tail = prev;
        Chainable lastAdded2 = null;
        for (Chainable lastAdded2 : c) {
            this.append(lastAdded2);
        }
        lastAdded2.setNext(elem);
        elem.setPrevious(lastAdded2);
        this.tail = oldTail;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        DoublyChainable elem = (DoublyChainable)o;
        boolean result = false;
        if (elem == this.head) {
            this.head = (DoublyChainable)elem.getNext();
            result = true;
        }
        if (elem == this.tail) {
            this.tail = (DoublyChainable)elem.getPrevious();
            result = true;
        }
        if (elem.getPrevious() != null) {
            ((DoublyChainable)elem.getPrevious()).setNext((DoublyChainable)elem.getNext());
            result = true;
        }
        if (elem.getNext() != null) {
            ((DoublyChainable)elem.getNext()).setPrevious((DoublyChainable)elem.getPrevious());
            result = true;
        }
        --this.size;
        return result;
    }

    @Override
    public E remove(int index) {
        int i = 0;
        Object elem = this.head;
        while (elem != null) {
            if (i == index) {
                this.remove(elem);
                return elem;
            }
            elem = (DoublyChainable)elem.getNext();
            ++i;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Object[] items = new Object[c.size()];
        int i = 0;
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            items[i++] = it.next();
        }
        boolean result = false;
        i = 0;
        while (i < items.length) {
            result = this.remove(items[i]) || result;
            ++i;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] items = new Object[this.size()];
        Object elem = this.head;
        int i = 0;
        while (elem != null) {
            items[i] = elem;
            elem = (DoublyChainable)elem.getNext();
            ++i;
        }
        boolean result = false;
        i = 0;
        while (i < items.length) {
            if (!c.contains(items[i])) {
                this.remove(items[i]);
                result = true;
            }
            ++i;
        }
        return result;
    }

    @Override
    public E set(int index, E element) {
        Object old = this.get(index);
        if (old != null) {
            DoublyChainable prev = (DoublyChainable)old.getPrevious();
            DoublyChainable next = (DoublyChainable)old.getNext();
            element.setPrevious((DoublyChainable)prev);
            element.setNext((DoublyChainable)next);
            if (prev != null) {
                prev.setNext(element);
            }
            if (next != null) {
                next.setPrevious(element);
            }
            if (this.head == old) {
                this.head = element;
            }
            if (this.tail == old) {
                this.tail = element;
            }
            return (E)old;
        }
        return null;
    }

    @Override
    public E get(int index) {
        int i = 0;
        Object elem = this.head;
        while (elem != null) {
            if (i == index) {
                return elem;
            }
            elem = (DoublyChainable)elem.getNext();
            ++i;
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        Object elem = this.head;
        while (elem != null) {
            if (elem.equals(o)) {
                return i;
            }
            elem = (DoublyChainable)elem.getNext();
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.size - 1;
        Object elem = this.tail;
        while (elem != null) {
            if (elem.equals(o)) {
                return i;
            }
            elem = (DoublyChainable)elem.getPrevious();
            --i;
        }
        return -1;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    @Override
    public boolean contains(Object o) {
        Object elem = this.head;
        while (elem != null) {
            if (elem.equals(o)) {
                return true;
            }
            elem = (DoublyChainable)elem.getNext();
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            Object elem = this.head;
            while (elem != null) {
                if (elem.equals(o)) {
                    return true;
                }
                elem = (DoublyChainable)elem.getNext();
            }
        }
        return false;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList() is not yet implemented");
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return this.getHead();
    }

    @Override
    public E element() {
        return this.getHead();
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        return this.removeHead();
    }

    @Override
    public E remove() {
        return this.removeHead();
    }

    @Override
    public boolean offer(E o) {
        return this.add(o);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    private void addBefore(E o, E e) {
        if (e.getPrevious() != null) {
            ((DoublyChainable)e.getPrevious()).setNext(o);
        }
        o.setPrevious((DoublyChainable)((DoublyChainable)e.getPrevious()));
        o.setNext(e);
        e.setPrevious(o);
        ++this.size;
    }

    public ChainedList<E> clone() {
        ChainedList clone = null;
        try {
            clone = (ChainedList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.head = this.head;
        clone.tail = this.tail;
        clone.size = this.size;
        return clone;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        Object elem = this.head;
        while (elem != null) {
            result[i] = elem;
            elem = (DoublyChainable)elem.getNext();
            ++i;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        T[] result = a;
        Object elem = this.head;
        int i = 0;
        while (elem != null) {
            result[i] = elem;
            elem = (DoublyChainable)elem.getNext();
            ++i;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    implements ListIterator<E> {
        private E lastReturned;
        private E next;
        private int nextIndex;

        ListItr(int index) {
            this.lastReturned = ChainedList.this.head;
            if (index < 0 || index > ChainedList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + ChainedList.this.size);
            }
            if (index < ChainedList.this.size >> 1) {
                this.next = (DoublyChainable)ChainedList.this.head.getNext();
                this.nextIndex = 0;
                while (this.nextIndex < index) {
                    this.next = (DoublyChainable)this.next.getNext();
                    ++this.nextIndex;
                }
            } else {
                this.next = ChainedList.this.head;
                this.nextIndex = ChainedList.this.size;
                while (this.nextIndex > index) {
                    this.next = (DoublyChainable)this.next.getPrevious();
                    --this.nextIndex;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != ChainedList.this.size;
        }

        @Override
        public E next() {
            if (this.nextIndex == ChainedList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = (DoublyChainable)this.next.getNext();
            ++this.nextIndex;
            return this.lastReturned;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        @Override
        public E previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.next = (DoublyChainable)this.next.getPrevious();
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            DoublyChainable lastNext = (DoublyChainable)this.lastReturned.getNext();
            try {
                ChainedList.this.remove(this.lastReturned);
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException();
            }
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = ChainedList.this.head;
        }

        @Override
        public void set(E o) {
            if (this.lastReturned == ChainedList.this.head) {
                throw new IllegalStateException();
            }
            this.lastReturned = o;
        }

        @Override
        public void add(E o) {
            this.lastReturned = ChainedList.this.head;
            ChainedList.this.addBefore(o, this.next);
            ++this.nextIndex;
        }
    }
}

