/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.nio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class BufferUtils {
    private static boolean useDirectBuffers = true;

    public static void setUseDirectBuffers(boolean b) {
        useDirectBuffers = b;
    }

    public static final boolean getUseDirectBuffers() {
        return useDirectBuffers;
    }

    public static ByteBuffer createByteBuffer(int size) {
        if (useDirectBuffers) {
            return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        }
        return ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer createByteBuffer(byte ... values) {
        ByteBuffer buff = BufferUtils.createByteBuffer(values.length);
        buff.flip();
        return buff;
    }

    public static ShortBuffer createShortBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 1).asShortBuffer();
    }

    public static ShortBuffer createShortBuffer(short ... values) {
        ShortBuffer buff = BufferUtils.createShortBuffer(values.length);
        buff.put(values);
        buff.flip();
        return buff;
    }

    public static CharBuffer createCharBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 1).asCharBuffer();
    }

    public static CharBuffer createCharBuffer(char ... values) {
        CharBuffer buff = BufferUtils.createCharBuffer(values.length);
        buff.put(values);
        buff.flip();
        return buff;
    }

    public static IntBuffer createIntBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 2).asIntBuffer();
    }

    public static IntBuffer createIntBuffer(int ... values) {
        IntBuffer buff = BufferUtils.createIntBuffer(values.length);
        buff.put(values);
        buff.flip();
        return buff;
    }

    public static LongBuffer createLongBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 3).asLongBuffer();
    }

    public static LongBuffer createLongBuffer(long ... values) {
        LongBuffer buff = BufferUtils.createLongBuffer(values.length);
        buff.put(values);
        buff.flip();
        return buff;
    }

    public static FloatBuffer createFloatBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 2).asFloatBuffer();
    }

    public static FloatBuffer createFloatBuffer(float ... values) {
        FloatBuffer buff = BufferUtils.createFloatBuffer(values.length);
        buff.put(values);
        buff.flip();
        return buff;
    }

    public static DoubleBuffer createDoubleBuffer(int size) {
        return BufferUtils.createByteBuffer(size << 3).asDoubleBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(double ... values) {
        DoubleBuffer buff = BufferUtils.createDoubleBuffer(values.length);
        buff.put(values);
        buff.flip();
        return buff;
    }

    public static int getElementSizeExponent(Buffer buf) {
        if (buf instanceof ByteBuffer) {
            return 0;
        }
        if (buf instanceof ShortBuffer || buf instanceof CharBuffer) {
            return 1;
        }
        if (buf instanceof FloatBuffer || buf instanceof IntBuffer) {
            return 2;
        }
        if (buf instanceof LongBuffer || buf instanceof DoubleBuffer) {
            return 3;
        }
        throw new IllegalStateException("Unsupported buffer type: " + buf);
    }

    public static int getOffset(Buffer buffer) {
        return buffer.position() << BufferUtils.getElementSizeExponent(buffer);
    }
}

