/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.util.strings;

public class SimpleStringTokenizer {
    private String string;
    private int pos = -1;
    private Boolean hasMore = null;
    private String lastToken = null;
    private boolean useQuotes = false;
    private final StringBuilder sb = new StringBuilder();

    public void useQuotes(boolean keep) {
        this.useQuotes = keep;
    }

    public final boolean useQuotes() {
        return this.useQuotes;
    }

    public void reset() {
        this.pos = -1;
        this.hasMore = null;
        this.lastToken = null;
    }

    public void setString(String string, int skipChars) {
        if (string == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        this.string = string;
        this.reset();
        this.pos = skipChars - 1;
    }

    public void setString(String string) {
        this.setString(string, 0);
    }

    public static final boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f';
    }

    private final boolean searchForNextToken() {
        while (++this.pos < this.string.length()) {
            char ch = this.string.charAt(this.pos);
            if (SimpleStringTokenizer.isWhitespace(ch)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasMoreTokens() {
        if (this.pos >= this.string.length()) {
            return false;
        }
        if (this.hasMore == null) {
            this.hasMore = this.searchForNextToken();
        }
        return this.hasMore;
    }

    public final String nextToken(boolean discard) {
        char ch;
        if (!this.hasMoreTokens()) {
            return null;
        }
        boolean quoteBegan = false;
        if (!discard) {
            this.sb.setLength(0);
            ch = this.string.charAt(this.pos);
            if (ch != '\"' || !this.useQuotes) {
                this.sb.append(ch);
            } else {
                quoteBegan = true;
            }
        }
        while (++this.pos < this.string.length()) {
            ch = this.string.charAt(this.pos);
            if (ch == '\"' && this.useQuotes) {
                quoteBegan = !quoteBegan;
                continue;
            }
            if (SimpleStringTokenizer.isWhitespace(ch) && !quoteBegan) {
                this.hasMore = null;
                if (discard) {
                    return null;
                }
                return this.sb.toString();
            }
            if (discard) continue;
            this.sb.append(ch);
        }
        this.hasMore = null;
        if (discard || this.sb.length() == 0) {
            return null;
        }
        return this.sb.toString();
    }

    public final String nextToken() {
        this.lastToken = this.nextToken(false);
        return this.lastToken;
    }

    public final SimpleStringTokenizer skipToken() {
        this.nextToken(true);
        return this;
    }

    public final String getLastToken() {
        return this.lastToken;
    }

    private final String getRest(boolean acceptQuotes) {
        this.sb.setLength(0);
        int numWhitespaces = 0;
        int i = this.pos;
        while (i < this.string.length()) {
            char ch = this.string.charAt(i);
            boolean ws = SimpleStringTokenizer.isWhitespace(ch);
            numWhitespaces = ws ? ++numWhitespaces : 0;
            if (!(!acceptQuotes && ch == '\"' || ws && this.sb.length() <= 0)) {
                this.sb.append(ch);
            }
            ++i;
        }
        if (numWhitespaces > 0) {
            this.sb.delete(this.sb.length() - numWhitespaces, this.sb.length() - 1);
        }
        return this.sb.toString();
    }

    public final String getRest() {
        return this.getRest(true);
    }

    public final String getUnquotedRest() {
        return this.getRest(false);
    }

    public SimpleStringTokenizer(String string) {
        this.setString(string);
    }
}

