/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.util.Display;

public final class Display {
    private static final boolean DEBUG = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static DisplayMode[] getAvailableDisplayModes(int minWidth, int minHeight, int maxWidth, int maxHeight, int minBPP, int maxBPP, int minFreq, int maxFreq) throws LWJGLException {
        DisplayMode[] modes = org.lwjgl.opengl.Display.getAvailableDisplayModes();
        if (LWJGLUtil.DEBUG) {
            System.out.println("Available screen modes:");
            for (int i = 0; i < modes.length; ++i) {
                System.out.println(modes[i]);
            }
        }
        ArrayList<DisplayMode> matches = new ArrayList<DisplayMode>(modes.length);
        for (int i = 0; i < modes.length; ++i) {
            if (!$assertionsDisabled && modes[i] == null) {
                throw new AssertionError((Object)("" + i + " " + modes.length));
            }
            if (minWidth != -1 && modes[i].getWidth() < minWidth || maxWidth != -1 && modes[i].getWidth() > maxWidth || minHeight != -1 && modes[i].getHeight() < minHeight || maxHeight != -1 && modes[i].getHeight() > maxHeight || minBPP != -1 && modes[i].getBitsPerPixel() < minBPP || maxBPP != -1 && modes[i].getBitsPerPixel() > maxBPP || modes[i].getFrequency() != 0 && (minFreq != -1 && modes[i].getFrequency() < minFreq || maxFreq != -1 && modes[i].getFrequency() > maxFreq)) continue;
            matches.add(modes[i]);
        }
        DisplayMode[] ret = new DisplayMode[matches.size()];
        matches.toArray(ret);
        if (LWJGLUtil.DEBUG) {
            // empty if block
        }
        return ret;
    }

    public static DisplayMode setDisplayMode(DisplayMode[] dm, String[] param) throws Exception {
        int i;
        class Sorter
        implements Comparator {
            final 1FieldAccessor[] field;
            private final /* synthetic */ String[] val$param;

            Sorter(String[] stringArray) {
                this.val$param = stringArray;
                class FieldAccessor {
                    final String fieldName;
                    final int order;
                    final int preferred;
                    final boolean usePreferred;

                    FieldAccessor(String fieldName, int order, int preferred, boolean usePreferred) {
                        this.fieldName = fieldName;
                        this.order = order;
                        this.preferred = preferred;
                        this.usePreferred = usePreferred;
                    }

                    int getInt(DisplayMode mode) {
                        if ("width".equals(this.fieldName)) {
                            return mode.getWidth();
                        }
                        if ("height".equals(this.fieldName)) {
                            return mode.getHeight();
                        }
                        if ("freq".equals(this.fieldName)) {
                            return mode.getFrequency();
                        }
                        if ("bpp".equals(this.fieldName)) {
                            return mode.getBitsPerPixel();
                        }
                        throw new IllegalArgumentException("Unknown field " + this.fieldName);
                    }
                }
                this.field = new FieldAccessor[this.val$param.length];
                for (int i = 0; i < this.field.length; ++i) {
                    int idx = this.val$param[i].indexOf(61);
                    this.field[i] = idx > 0 ? new FieldAccessor(this.val$param[i].substring(0, idx), 0, Integer.parseInt(this.val$param[i].substring(idx + 1, this.val$param[i].length())), true) : (this.val$param[i].charAt(0) == '-' ? new FieldAccessor(this.val$param[i].substring(1), -1, 0, false) : new FieldAccessor(this.val$param[i], 1, 0, false));
                }
            }

            public int compare(Object o1, Object o2) {
                DisplayMode dm1 = (DisplayMode)o1;
                DisplayMode dm2 = (DisplayMode)o2;
                for (int i = 0; i < this.field.length; ++i) {
                    int f1 = this.field[i].getInt(dm1);
                    int f2 = this.field[i].getInt(dm2);
                    if (this.field[i].usePreferred && f1 != f2) {
                        int absf2;
                        if (f1 == this.field[i].preferred) {
                            return -1;
                        }
                        if (f2 == this.field[i].preferred) {
                            return 1;
                        }
                        int absf1 = Math.abs(f1 - this.field[i].preferred);
                        if (absf1 < (absf2 = Math.abs(f2 - this.field[i].preferred))) {
                            return -1;
                        }
                        if (absf1 <= absf2) continue;
                        return 1;
                    }
                    if (f1 < f2) {
                        return this.field[i].order;
                    }
                    if (f1 == f2) continue;
                    return -this.field[i].order;
                }
                return 0;
            }
        }
        Arrays.sort(dm, new Sorter(param));
        if (LWJGLUtil.DEBUG) {
            System.out.println("Sorted display modes:");
            for (i = 0; i < dm.length; ++i) {
                System.out.println(dm[i]);
            }
        }
        for (i = 0; i < dm.length; ++i) {
            try {
                if (LWJGLUtil.DEBUG) {
                    System.out.println("Attempting to set displaymode: " + dm[i]);
                }
                org.lwjgl.opengl.Display.setDisplayMode(dm[i]);
                return dm[i];
            }
            catch (Exception e) {
                if (!LWJGLUtil.DEBUG) continue;
                System.out.println("Failed to set display mode to " + dm[i]);
                e.printStackTrace();
                continue;
            }
        }
        throw new Exception("Failed to set display mode.");
    }

    static {
        $assertionsDisabled = !Display.class.desiredAssertionStatus();
    }
}

