/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.decomposition;

import org.openmali.FastMath;
import org.openmali.vecmath2.MatrixMxNf;

public class EigenvalueDecomposition {
    private final int n;
    private final boolean isSymmetric;
    private final float[] d;
    private final float[] e;
    private final MatrixMxNf V;
    private final MatrixMxNf H;
    private final float[] ort;
    private transient float cdivr;
    private transient float cdivi;

    private void tred2() {
        int j = 0;
        while (j < this.n) {
            this.d[j] = this.V.get(this.n - 1, j);
            ++j;
        }
        int i = this.n - 1;
        while (i > 0) {
            float scale = 0.0f;
            float h = 0.0f;
            int k = 0;
            while (k < i) {
                scale += Math.abs(this.d[k]);
                ++k;
            }
            if (scale == 0.0f) {
                this.e[i] = this.d[i - 1];
                int j2 = 0;
                while (j2 < i) {
                    this.d[j2] = this.V.get(i - 1, j2);
                    this.V.set(i, j2, 0.0f);
                    this.V.set(j2, i, 0.0f);
                    ++j2;
                }
            } else {
                k = 0;
                while (k < i) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                    ++k;
                }
                float f = this.d[i - 1];
                float g = FastMath.sqrt(h);
                if (f > 0.0f) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                int j3 = 0;
                while (j3 < i) {
                    this.e[j3] = 0.0f;
                    ++j3;
                }
                j3 = 0;
                while (j3 < i) {
                    f = this.d[j3];
                    this.V.set(j3, i, f);
                    g = this.e[j3] + this.V.get(j3, j3) * f;
                    int k2 = j3 + 1;
                    while (k2 <= i - 1) {
                        g += this.V.get(k2, j3) * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.V.get(k2, j3) * f;
                        ++k2;
                    }
                    this.e[j3] = g;
                    ++j3;
                }
                f = 0.0f;
                j3 = 0;
                while (j3 < i) {
                    int n = j3;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j3] * this.d[j3];
                    ++j3;
                }
                float hh = f / (h + h);
                int j4 = 0;
                while (j4 < i) {
                    int n = j4;
                    this.e[n] = this.e[n] - hh * this.d[j4];
                    ++j4;
                }
                j4 = 0;
                while (j4 < i) {
                    f = this.d[j4];
                    g = this.e[j4];
                    int k3 = j4;
                    while (k3 <= i - 1) {
                        this.V.sub(k3, j4, f * this.e[k3] + g * this.d[k3]);
                        ++k3;
                    }
                    this.d[j4] = this.V.get(i - 1, j4);
                    this.V.set(i, j4, 0.0f);
                    ++j4;
                }
            }
            this.d[i] = h;
            --i;
        }
        i = 0;
        while (i < this.n - 1) {
            this.V.set(this.n - 1, i, this.V.get(i, i));
            this.V.set(i, i, 1.0f);
            float h = this.d[i + 1];
            if (h != 0.0f) {
                int k = 0;
                while (k <= i) {
                    this.d[k] = this.V.get(k, i + 1) / h;
                    ++k;
                }
                int j5 = 0;
                while (j5 <= i) {
                    float g = 0.0f;
                    int k4 = 0;
                    while (k4 <= i) {
                        g += this.V.get(k4, i + 1) * this.V.get(k4, j5);
                        ++k4;
                    }
                    k4 = 0;
                    while (k4 <= i) {
                        this.V.sub(k4, j5, g * this.d[k4]);
                        ++k4;
                    }
                    ++j5;
                }
            }
            int k = 0;
            while (k <= i) {
                this.V.set(k, i + 1, 0.0f);
                ++k;
            }
            ++i;
        }
        j = 0;
        while (j < this.n) {
            this.d[j] = this.V.get(this.n - 1, j);
            this.V.set(this.n - 1, j, 0.0f);
            ++j;
        }
        this.V.set(this.n - 1, this.n - 1, 1.0f);
        this.e[0] = 0.0f;
    }

    private void tql2() {
        int i = 1;
        while (i < this.n) {
            this.e[i - 1] = this.e[i];
            ++i;
        }
        this.e[this.n - 1] = 0.0f;
        float f = 0.0f;
        float tst1 = 0.0f;
        float eps = FastMath.pow(2.0f, -52.0f);
        int l = 0;
        while (l < this.n) {
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            int m = l;
            while (m < this.n) {
                if (Math.abs(this.e[m]) <= eps * tst1) break;
                ++m;
            }
            if (m > l) {
                int iter = 0;
                do {
                    float c;
                    ++iter;
                    float g = this.d[l];
                    float p = (this.d[l + 1] - g) / (2.0f * this.e[l]);
                    float r = FastMath.hypot(p, 1.0f);
                    if (p < 0.0f) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    float dl1 = this.d[l + 1];
                    float h = g - this.d[l];
                    int i2 = l + 2;
                    while (i2 < this.n) {
                        int n = i2++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    float c2 = c = 1.0f;
                    float c3 = c;
                    float el1 = this.e[l + 1];
                    float s = 0.0f;
                    float s2 = 0.0f;
                    int i3 = m - 1;
                    while (i3 >= l) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i3];
                        h = c * p;
                        r = FastMath.hypot(p, this.e[i3]);
                        this.e[i3 + 1] = s * r;
                        s = this.e[i3] / r;
                        c = p / r;
                        p = c * this.d[i3] - s * g;
                        this.d[i3 + 1] = h + s * (c * g + s * this.d[i3]);
                        int k = 0;
                        while (k < this.n) {
                            h = this.V.get(k, i3 + 1);
                            this.V.set(k, i3 + 1, s * this.V.get(k, i3) + c * h);
                            this.V.set(k, i3, c * this.V.get(k, i3) - s * h);
                            ++k;
                        }
                        --i3;
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0f;
            ++l;
        }
        int i4 = 0;
        while (i4 < this.n - 1) {
            int k = i4;
            float p = this.d[i4];
            int j = i4 + 1;
            while (j < this.n) {
                if (this.d[j] < p) {
                    k = j;
                    p = this.d[j];
                }
                ++j;
            }
            if (k != i4) {
                this.d[k] = this.d[i4];
                this.d[i4] = p;
                j = 0;
                while (j < this.n) {
                    p = this.V.get(j, i4);
                    this.V.set(j, i4, this.V.get(j, k));
                    this.V.set(j, k, p);
                    ++j;
                }
            }
            ++i4;
        }
    }

    private void orthes() {
        boolean low = false;
        int high = this.n - 1;
        int m = 1;
        while (m <= high - 1) {
            float scale = 0.0f;
            int i = m;
            while (i <= high) {
                scale += Math.abs(this.H.get(i, m - 1));
                ++i;
            }
            if (scale != 0.0f) {
                float f;
                float h = 0.0f;
                int i2 = high;
                while (i2 >= m) {
                    this.ort[i2] = this.H.get(i2, m - 1) / scale;
                    h += this.ort[i2] * this.ort[i2];
                    --i2;
                }
                float g = FastMath.sqrt(h);
                if (this.ort[m] > 0.0f) {
                    g = -g;
                }
                h -= this.ort[m] * g;
                this.ort[m] = this.ort[m] - g;
                int j = m;
                while (j < this.n) {
                    f = 0.0f;
                    int i3 = high;
                    while (i3 >= m) {
                        f += this.ort[i3] * this.H.get(i3, j);
                        --i3;
                    }
                    f /= h;
                    i3 = m;
                    while (i3 <= high) {
                        this.H.sub(i3, j, f * this.ort[i3]);
                        ++i3;
                    }
                    ++j;
                }
                int i4 = 0;
                while (i4 <= high) {
                    f = 0.0f;
                    int j2 = high;
                    while (j2 >= m) {
                        f += this.ort[j2] * this.H.get(i4, j2);
                        --j2;
                    }
                    f /= h;
                    j2 = m;
                    while (j2 <= high) {
                        this.H.sub(i4, j2, f * this.ort[j2]);
                        ++j2;
                    }
                    ++i4;
                }
                this.ort[m] = scale * this.ort[m];
                this.H.set(m, m - 1, scale * g);
            }
            ++m;
        }
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                this.V.set(i, j, i == j ? 1.0f : 0.0f);
                ++j;
            }
            ++i;
        }
        m = high - 1;
        while (m >= 1) {
            if (this.H.get(m, m - 1) != 0.0f) {
                int i5 = m + 1;
                while (i5 <= high) {
                    this.ort[i5] = this.H.get(i5, m - 1);
                    ++i5;
                }
                int j = m;
                while (j <= high) {
                    float g = 0.0f;
                    int i6 = m;
                    while (i6 <= high) {
                        g += this.ort[i6] * this.V.get(i6, j);
                        ++i6;
                    }
                    g = g / this.ort[m] / this.H.get(m, m - 1);
                    i6 = m;
                    while (i6 <= high) {
                        this.V.add(i6, j, g * this.ort[i6]);
                        ++i6;
                    }
                    ++j;
                }
            }
            --m;
        }
    }

    private void cdiv(float xr, float xi, float yr, float yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            float r = yi / yr;
            float d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            float r = yr / yi;
            float d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    private void hqr2() {
        float y;
        int i;
        int j;
        float x;
        float w;
        int l;
        int j2;
        int nn = this.n;
        int n = nn - 1;
        boolean low = false;
        int high = nn - 1;
        float eps = FastMath.pow(2.0f, -52.0f);
        float exshift = 0.0f;
        float p = 0.0f;
        float q = 0.0f;
        float r = 0.0f;
        float s = 0.0f;
        float z = 0.0f;
        float norm = 0.0f;
        int i2 = 0;
        while (i2 < nn) {
            if (i2 < 0 | i2 > high) {
                this.d[i2] = this.H.get(i2, i2);
                this.e[i2] = 0.0f;
            }
            j2 = Math.max(i2 - 1, 0);
            while (j2 < nn) {
                norm += Math.abs(this.H.get(i2, j2));
                ++j2;
            }
            ++i2;
        }
        int iter = 0;
        block2: while (n >= 0) {
            l = n;
            while (l > 0) {
                s = Math.abs(this.H.get(l - 1, l - 1)) + Math.abs(this.H.get(l, l));
                if (s == 0.0f) {
                    s = norm;
                }
                if (Math.abs(this.H.get(l, l - 1)) < eps * s) break;
                --l;
            }
            if (l == n) {
                this.H.set(n, n, this.H.get(n, n) + exshift);
                this.d[n] = this.H.get(n, n);
                this.e[n] = 0.0f;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this.H.get(n, n - 1) * this.H.get(n - 1, n);
                p = (this.H.get(n - 1, n - 1) - this.H.get(n, n)) / 2.0f;
                q = p * p + w;
                z = FastMath.sqrt(Math.abs(q));
                this.H.set(n, n, this.H.get(n, n) + exshift);
                this.H.set(n - 1, n - 1, this.H.get(n - 1, n - 1) + exshift);
                x = this.H.get(n, n);
                if (q >= 0.0f) {
                    z = p >= 0.0f ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = this.d[n - 1];
                    if (z != 0.0f) {
                        this.d[n] = x - w / z;
                    }
                    this.e[n - 1] = 0.0f;
                    this.e[n] = 0.0f;
                    x = this.H.get(n, n - 1);
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = FastMath.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    j = n - 1;
                    while (j < nn) {
                        z = this.H.get(n - 1, j);
                        this.H.set(n - 1, j, q * z + p * this.H.get(n, j));
                        this.H.set(n, j, q * this.H.get(n, j) - p * z);
                        ++j;
                    }
                    i = 0;
                    while (i <= n) {
                        z = this.H.get(i, n - 1);
                        this.H.set(i, n - 1, q * z + p * this.H.get(i, n));
                        this.H.set(i, n, q * this.H.get(i, n) - p * z);
                        ++i;
                    }
                    i = 0;
                    while (i <= high) {
                        z = this.V.get(i, n - 1);
                        this.V.set(i, n - 1, q * z + p * this.V.get(i, n));
                        this.V.set(i, n, q * this.V.get(i, n) - p * z);
                        ++i;
                    }
                } else {
                    this.d[n - 1] = x + p;
                    this.d[n] = x + p;
                    this.e[n - 1] = z;
                    this.e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this.H.get(n, n);
            y = 0.0f;
            w = 0.0f;
            if (l < n) {
                y = this.H.get(n - 1, n - 1);
                w = this.H.get(n, n - 1) * this.H.get(n - 1, n);
            }
            if (iter == 10) {
                exshift += x;
                i = 0;
                while (i <= n) {
                    this.H.sub(i, i, x);
                    ++i;
                }
                s = Math.abs(this.H.get(n, n - 1)) + Math.abs(this.H.get(n - 1, n - 2));
                x = y = 0.75f * s;
                w = -0.4375f * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0f;
                if ((s = s * s + w) > 0.0f) {
                    s = FastMath.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0f + s);
                    i = 0;
                    while (i <= n) {
                        this.H.sub(i, i, s);
                        ++i;
                    }
                    exshift += s;
                    w = 0.964f;
                    y = 0.964f;
                    x = 0.964f;
                }
            }
            ++iter;
            int m = n - 2;
            while (m >= l) {
                z = this.H.get(m, m);
                r = x - z;
                s = y - z;
                p = (r * s - w) / this.H.get(m + 1, m) + this.H.get(m, m + 1);
                q = this.H.get(m + 1, m + 1) - z - r - s;
                r = this.H.get(m + 2, m + 1);
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(this.H.get(m, m - 1)) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.H.get(m - 1, m - 1)) + Math.abs(z) + Math.abs(this.H.get(m + 1, m + 1))))) break;
                --m;
            }
            int i3 = m + 2;
            while (i3 <= n) {
                this.H.set(i3, i3 - 2, 0.0f);
                if (i3 > m + 2) {
                    this.H.set(i3, i3 - 3, 0.0f);
                }
                ++i3;
            }
            int k = m;
            while (k <= n - 1) {
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this.H.get(k, k - 1);
                    q = this.H.get(k + 1, k - 1);
                    r = notlast ? this.H.get(k + 2, k - 1) : 0.0f;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0f) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0f) continue block2;
                s = FastMath.sqrt(p * p + q * q + r * r);
                if (p < 0.0f) {
                    s = -s;
                }
                if (s != 0.0f) {
                    if (k != m) {
                        this.H.set(k, k - 1, -s * x);
                    } else if (l != m) {
                        this.H.set(k, k - 1, -this.H.get(k, k - 1));
                    }
                    x = (p += s) / s;
                    y = q / s;
                    z = r / s;
                    q /= p;
                    r /= p;
                    int j3 = k;
                    while (j3 < nn) {
                        p = this.H.get(k, j3) + q * this.H.get(k + 1, j3);
                        if (notlast) {
                            this.H.set(k + 2, j3, this.H.get(k + 2, j3) - (p += r * this.H.get(k + 2, j3)) * z);
                        }
                        this.H.set(k, j3, this.H.get(k, j3) - p * x);
                        this.H.set(k + 1, j3, this.H.get(k + 1, j3) - p * y);
                        ++j3;
                    }
                    int i4 = 0;
                    while (i4 <= Math.min(n, k + 3)) {
                        p = x * this.H.get(i4, k) + y * this.H.get(i4, k + 1);
                        if (notlast) {
                            this.H.set(i4, k + 2, this.H.get(i4, k + 2) - (p += z * this.H.get(i4, k + 2)) * r);
                        }
                        this.H.set(i4, k, this.H.get(i4, k) - p);
                        this.H.set(i4, k + 1, this.H.get(i4, k + 1) - p * q);
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 <= high) {
                        p = x * this.V.get(i4, k) + y * this.V.get(i4, k + 1);
                        if (notlast) {
                            this.V.set(i4, k + 2, this.V.get(i4, k + 2) - (p += z * this.V.get(i4, k + 2)) * r);
                        }
                        this.V.set(i4, k, this.V.get(i4, k) - p);
                        this.V.set(i4, k + 1, this.V.get(i4, k + 1) - p * q);
                        ++i4;
                    }
                }
                ++k;
            }
        }
        if (norm == 0.0f) {
            return;
        }
        n = nn - 1;
        while (n >= 0) {
            float t;
            p = this.d[n];
            q = this.e[n];
            if (q == 0.0f) {
                l = n;
                this.H.set(n, n, 1.0f);
                i = n - 1;
                while (i >= 0) {
                    w = this.H.get(i, i) - p;
                    r = 0.0f;
                    int j4 = l;
                    while (j4 <= n) {
                        r += this.H.get(i, j4) * this.H.get(j4, n);
                        ++j4;
                    }
                    if (this.e[i] < 0.0f) {
                        z = w;
                        s = r;
                    } else {
                        l = i;
                        if (this.e[i] == 0.0f) {
                            if (w != 0.0f) {
                                this.H.set(i, n, -r / w);
                            } else {
                                this.H.set(i, n, -r / (eps * norm));
                            }
                        } else {
                            x = this.H.get(i, i + 1);
                            y = this.H.get(i + 1, i);
                            q = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i];
                            t = (x * s - z * r) / q;
                            this.H.set(i, n, t);
                            if (Math.abs(x) > Math.abs(z)) {
                                this.H.set(i + 1, n, (-r - w * t) / x);
                            } else {
                                this.H.set(i + 1, n, (-s - y * t) / z);
                            }
                        }
                        t = Math.abs(this.H.get(i, n));
                        if (eps * t * t > 1.0f) {
                            j4 = i;
                            while (j4 <= n) {
                                this.H.set(j4, n, this.H.get(j4, n) / t);
                                ++j4;
                            }
                        }
                    }
                    --i;
                }
            } else if (q < 0.0f) {
                l = n - 1;
                if (Math.abs(this.H.get(n, n - 1)) > Math.abs(this.H.get(n - 1, n))) {
                    this.H.set(n - 1, n - 1, q / this.H.get(n, n - 1));
                    this.H.set(n - 1, n, -(this.H.get(n, n) - p) / this.H.get(n, n - 1));
                } else {
                    this.cdiv(0.0f, -this.H.get(n - 1, n), this.H.get(n - 1, n - 1) - p, q);
                    this.H.set(n - 1, n - 1, this.cdivr);
                    this.H.set(n - 1, n, this.cdivi);
                }
                this.H.set(n, n - 1, 0.0f);
                this.H.set(n, n, 1.0f);
                i = n - 2;
                while (i >= 0) {
                    float ra = 0.0f;
                    float sa = 0.0f;
                    int j5 = l;
                    while (j5 <= n) {
                        ra += this.H.get(i, j5) * this.H.get(j5, n - 1);
                        sa += this.H.get(i, j5) * this.H.get(j5, n);
                        ++j5;
                    }
                    w = this.H.get(i, i) - p;
                    if (this.e[i] < 0.0f) {
                        z = w;
                        r = ra;
                        s = sa;
                    } else {
                        l = i;
                        if (this.e[i] == 0.0f) {
                            this.cdiv(-ra, -sa, w, q);
                            this.H.set(i, n - 1, this.cdivr);
                            this.H.set(i, n, this.cdivi);
                        } else {
                            float vi;
                            x = this.H.get(i, i + 1);
                            y = this.H.get(i + 1, i);
                            float vr = (this.d[i] - p) * (this.d[i] - p) + this.e[i] * this.e[i] - q * q;
                            if (vr == 0.0f & (vi = (this.d[i] - p) * 2.0f * q) == 0.0f) {
                                vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                            }
                            this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                            this.H.set(i, n - 1, this.cdivr);
                            this.H.set(i, n, this.cdivi);
                            if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                                this.H.set(i + 1, n - 1, (-ra - w * this.H.get(i, n - 1) + q * this.H.get(i, n)) / x);
                                this.H.set(i + 1, n, (-sa - w * this.H.get(i, n) - q * this.H.get(i, n - 1)) / x);
                            } else {
                                this.cdiv(-r - y * this.H.get(i, n - 1), -s - y * this.H.get(i, n), z, q);
                                this.H.set(i + 1, n - 1, this.cdivr);
                                this.H.set(i + 1, n, this.cdivi);
                            }
                        }
                        t = Math.max(Math.abs(this.H.get(i, n - 1)), Math.abs(this.H.get(i, n)));
                        if (eps * t * t > 1.0f) {
                            j5 = i;
                            while (j5 <= n) {
                                this.H.set(j5, n - 1, this.H.get(j5, n - 1) / t);
                                this.H.set(j5, n, this.H.get(j5, n) / t);
                                ++j5;
                            }
                        }
                    }
                    --i;
                }
            }
            --n;
        }
        int i5 = 0;
        while (i5 < nn) {
            if (i5 < 0 | i5 > high) {
                j = i5;
                while (j < nn) {
                    this.V.set(i5, j, this.H.get(i5, j));
                    ++j;
                }
            }
            ++i5;
        }
        j2 = nn - 1;
        while (j2 >= 0) {
            i = 0;
            while (i <= high) {
                z = 0.0f;
                int k = 0;
                while (k <= Math.min(j2, high)) {
                    z += this.V.get(i, k) * this.H.get(k, j2);
                    ++k;
                }
                this.V.set(i, j2, z);
                ++i;
            }
            --j2;
        }
    }

    public EigenvalueDecomposition(MatrixMxNf A) {
        int i;
        this.n = A.getNumCols();
        this.V = new MatrixMxNf(this.n, this.n);
        this.d = new float[this.n];
        this.e = new float[this.n];
        boolean isSym = true;
        int j = 0;
        while (j < this.n & isSym) {
            i = 0;
            while (i < this.n & isSym) {
                isSym = A.get(i, j) == A.get(j, i);
                ++i;
            }
            ++j;
        }
        this.isSymmetric = isSym;
        if (this.isSymmetric) {
            int i2 = 0;
            while (i2 < this.n) {
                int j2 = 0;
                while (j2 < this.n) {
                    this.V.set(i2, j2, A.get(i2, j2));
                    ++j2;
                }
                ++i2;
            }
            this.tred2();
            this.tql2();
            this.H = null;
            this.ort = null;
        } else {
            this.H = new MatrixMxNf(this.n, this.n);
            this.ort = new float[this.n];
            j = 0;
            while (j < this.n) {
                i = 0;
                while (i < this.n) {
                    this.H.set(i, j, A.get(i, j));
                    ++i;
                }
                ++j;
            }
            this.orthes();
            this.hqr2();
        }
    }

    public MatrixMxNf getV() {
        MatrixMxNf result = new MatrixMxNf(this.n, this.n);
        result.set(this.V);
        return result;
    }

    public float[] getRealEigenvalues() {
        return this.d;
    }

    public float[] getImagEigenvalues() {
        return this.e;
    }

    public MatrixMxNf getD() {
        MatrixMxNf D = new MatrixMxNf(this.n, this.n);
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                D.set(i, j, 0.0f);
                ++j;
            }
            D.set(i, i, this.d[i]);
            if (this.e[i] > 0.0f) {
                D.set(i, i + 1, this.e[i]);
            } else if (this.e[i] < 0.0f) {
                D.set(i, i - 1, this.e[i]);
            }
            ++i;
        }
        return D;
    }
}

