/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.bodies;

import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bodies.Classifier;
import org.openmali.spatial.bodies.Plane;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Vector3f;

public class Frustum {
    private final Plane planeRight = new Plane();
    private final Plane planeLeft = new Plane();
    private final Plane planeBottom = new Plane();
    private final Plane planeTop = new Plane();
    private final Plane planeFar = new Plane();
    private final Plane planeNear = new Plane();
    private final Matrix4f matrix = new Matrix4f();

    public Matrix4f getMatrix() {
        return this.matrix;
    }

    public final void setPlaneRight(Plane plane) {
        this.planeRight.set(plane);
    }

    public final Plane getPlaneRight() {
        return this.planeRight;
    }

    public final Plane getPlaneRight(Plane plane) {
        plane.set(this.planeRight);
        return plane;
    }

    public final void setPlaneLeft(Plane plane) {
        this.planeLeft.set(plane);
    }

    public final Plane getPlaneLeft() {
        return this.planeLeft;
    }

    public final Plane getPlaneLeft(Plane plane) {
        plane.set(this.planeLeft);
        return plane;
    }

    public final void setPlaneBottom(Plane plane) {
        this.planeBottom.set(plane);
    }

    public final Plane getPlaneBottom() {
        return this.planeBottom;
    }

    public final Plane getPlaneBottom(Plane plane) {
        plane.set(this.planeBottom);
        return plane;
    }

    public final void setPlaneTop(Plane plane) {
        this.planeTop.set(plane);
    }

    public final Plane getPlaneTop() {
        return this.planeTop;
    }

    public final Plane getPlaneTop(Plane plane) {
        plane.set(this.planeTop);
        return plane;
    }

    public final void setPlaneFar(Plane plane) {
        this.planeFar.set(plane);
    }

    public final Plane getPlaneFar() {
        return this.planeFar;
    }

    public final Plane getPlaneFar(Plane plane) {
        plane.set(this.planeFar);
        return plane;
    }

    public final void setPlaneNear(Plane plane) {
        this.planeNear.set(plane);
    }

    public final Plane getPlaneNear() {
        return this.planeNear;
    }

    public final Plane getPlaneNear(Plane plane) {
        plane.set(this.planeNear);
        return plane;
    }

    private static final boolean quickClassify(Plane p, Box box) {
        if (p.distanceTo(box.getLowerX(), box.getLowerY(), box.getLowerZ()) > 0.0f) {
            return true;
        }
        if (p.distanceTo(box.getUpperX(), box.getLowerY(), box.getLowerZ()) > 0.0f) {
            return true;
        }
        if (p.distanceTo(box.getLowerX(), box.getUpperY(), box.getLowerZ()) > 0.0f) {
            return true;
        }
        if (p.distanceTo(box.getUpperX(), box.getUpperY(), box.getLowerZ()) > 0.0f) {
            return true;
        }
        if (p.distanceTo(box.getLowerX(), box.getLowerY(), box.getUpperZ()) > 0.0f) {
            return true;
        }
        if (p.distanceTo(box.getUpperX(), box.getLowerY(), box.getUpperZ()) > 0.0f) {
            return true;
        }
        if (p.distanceTo(box.getLowerX(), box.getUpperY(), box.getUpperZ()) > 0.0f) {
            return true;
        }
        return p.distanceTo(box.getUpperX(), box.getUpperY(), box.getUpperZ()) > 0.0f;
    }

    public final Classifier.Classification quickClassify(Box box) {
        if (!Frustum.quickClassify(this.planeRight, box)) {
            return Classifier.Classification.OUTSIDE;
        }
        if (!Frustum.quickClassify(this.planeLeft, box)) {
            return Classifier.Classification.OUTSIDE;
        }
        if (!Frustum.quickClassify(this.planeBottom, box)) {
            return Classifier.Classification.OUTSIDE;
        }
        if (!Frustum.quickClassify(this.planeTop, box)) {
            return Classifier.Classification.OUTSIDE;
        }
        if (!Frustum.quickClassify(this.planeFar, box)) {
            return Classifier.Classification.OUTSIDE;
        }
        if (!Frustum.quickClassify(this.planeNear, box)) {
            return Classifier.Classification.OUTSIDE;
        }
        return Classifier.Classification.SPANNING;
    }

    public final boolean intersects(Plane p, Vector3f[] quad) {
        return false;
    }

    public final void compute(Matrix4f proj, Matrix4f modl) {
        this.matrix.mul(proj, modl);
        this.planeRight.set(this.matrix.m03() - this.matrix.m00(), this.matrix.m13() - this.matrix.m10(), this.matrix.m23() - this.matrix.m20(), this.matrix.m33() - this.matrix.m30());
        this.planeLeft.set(this.matrix.m03() + this.matrix.m00(), this.matrix.m13() + this.matrix.m10(), this.matrix.m23() + this.matrix.m20(), this.matrix.m33() + this.matrix.m30());
        this.planeBottom.set(this.matrix.m03() + this.matrix.m01(), this.matrix.m13() + this.matrix.m11(), this.matrix.m23() + this.matrix.m21(), this.matrix.m33() + this.matrix.m31());
        this.planeTop.set(this.matrix.m03() - this.matrix.m01(), this.matrix.m13() - this.matrix.m11(), this.matrix.m23() - this.matrix.m21(), this.matrix.m33() - this.matrix.m31());
        this.planeFar.set(this.matrix.m03() - this.matrix.m02(), this.matrix.m13() - this.matrix.m12(), this.matrix.m23() - this.matrix.m22(), this.matrix.m33() - this.matrix.m32());
        this.planeNear.set(this.matrix.m03() + this.matrix.m02(), this.matrix.m13() + this.matrix.m12(), this.matrix.m23() + this.matrix.m22(), this.matrix.m33() + this.matrix.m32());
    }

    public final Matrix4f computeInverse(Matrix4f proj) {
        this.matrix.m00((this.planeLeft.getA() - this.planeRight.getA()) / 2.0f);
        this.matrix.m01((this.planeBottom.getA() - this.planeTop.getA()) / 2.0f);
        this.matrix.m02((this.planeNear.getA() - this.planeFar.getA()) / 2.0f);
        this.matrix.m03(this.planeRight.getA() + this.matrix.m00());
        this.matrix.m10((this.planeLeft.getB() - this.planeRight.getB()) / 2.0f);
        this.matrix.m11((this.planeBottom.getB() - this.planeTop.getB()) / 2.0f);
        this.matrix.m12((this.planeNear.getB() - this.planeFar.getB()) / 2.0f);
        this.matrix.m13(this.planeRight.getB() + this.matrix.m10());
        this.matrix.m20((this.planeLeft.getC() - this.planeRight.getC()) / 2.0f);
        this.matrix.m21((this.planeBottom.getC() - this.planeTop.getC()) / 2.0f);
        this.matrix.m22((this.planeNear.getC() - this.planeFar.getC()) / 2.0f);
        this.matrix.m23(this.planeRight.getC() + this.matrix.m20());
        this.matrix.m30((this.planeLeft.getD() - this.planeRight.getD()) / 2.0f);
        this.matrix.m31((this.planeBottom.getD() - this.planeTop.getD()) / 2.0f);
        this.matrix.m32((this.planeNear.getD() - this.planeFar.getD()) / 2.0f);
        this.matrix.m33(this.planeRight.getD() + this.matrix.m30());
        if (proj != null) {
            proj.set(this.matrix);
        }
        return this.matrix;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(this.getClass().getSimpleName());
        sb.append(" { ");
        sb.append("Left: ");
        sb.append(this.planeLeft);
        sb.append(", Right: ");
        sb.append(this.planeRight);
        sb.append(", Bottom:");
        sb.append(this.planeBottom);
        sb.append(", Top:");
        sb.append(this.planeTop);
        sb.append(", Far:");
        sb.append(this.planeFar);
        sb.append(", Near:");
        sb.append(this.planeNear);
        sb.append(" }");
        return sb.toString();
    }
}

