/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.octree;

import java.io.PrintStream;
import org.openmali.spatial.SpatialNode;
import org.openmali.spatial.bodies.Box;
import org.openmali.spatial.bounds.Bounds;
import org.openmali.spatial.bounds.BoundsType;
import org.openmali.spatial.octree.BoundsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OcCell<T extends SpatialNode>
extends Box {
    private static final long serialVersionUID = 5236486961328161769L;
    private final int level;
    private final float sizeX;
    private final float sizeY;
    private final float sizeZ;
    private final float halfSizeX;
    private final float halfSizeY;
    private final float halfSizeZ;
    private OcCell<T> ocUpperFrontLeft = null;
    private OcCell<T> ocUpperFrontRight = null;
    private OcCell<T> ocUpperBackLeft = null;
    private OcCell<T> ocUpperBackRight = null;
    private OcCell<T> ocLowerFrontLeft = null;
    private OcCell<T> ocLowerFrontRight = null;
    private OcCell<T> ocLowerBackLeft = null;
    private OcCell<T> ocLowerBackRight = null;
    private OcCell<T> quUpperBack = null;
    private OcCell<T> quUpperFront = null;
    private OcCell<T> quUpperLeft = null;
    private OcCell<T> quUpperRight = null;
    private OcCell<T> quLowerBack = null;
    private OcCell<T> quLowerFront = null;
    private OcCell<T> quLowerLeft = null;
    private OcCell<T> quLowerRight = null;
    private OcCell<T> quBackLeft = null;
    private OcCell<T> quBackRight = null;
    private OcCell<T> quFrontLeft = null;
    private OcCell<T> quFrontRight = null;
    private OcCell<T> hUpper = null;
    private OcCell<T> hLower = null;
    private OcCell<T> hLeft = null;
    private OcCell<T> hRight = null;
    private OcCell<T> hBack = null;
    private OcCell<T> hFront = null;
    private final boolean useExtendedCells;
    private Object[] nodes = this.newTArray(8);
    private int numNodes = 0;
    private boolean hasChildCells = false;

    private final Object[] newTArray(int length) {
        return new Object[length];
    }

    public final boolean usesExtendedCells() {
        return this.useExtendedCells;
    }

    public final int getLevel() {
        return this.level;
    }

    public final float getSizeX() {
        return this.sizeX;
    }

    public final float getSizeY() {
        return this.sizeY;
    }

    public final float getSizeZ() {
        return this.sizeZ;
    }

    public final float getHalfSizeX() {
        return this.halfSizeX;
    }

    public final float getHalfSizeY() {
        return this.halfSizeY;
    }

    public final float getHalfSizeZ() {
        return this.halfSizeZ;
    }

    public final OcCell<T> getCellOcUpperFrontLeft() {
        return this.ocUpperFrontLeft;
    }

    public final OcCell<T> getCellOcUpperFrontRight() {
        return this.ocUpperFrontRight;
    }

    public final OcCell<T> getCellOcUpperBackLeft() {
        return this.ocUpperBackLeft;
    }

    public final OcCell<T> getCellOcUpperBackRight() {
        return this.ocUpperBackRight;
    }

    public final OcCell<T> getCellOcLowerFrontLeft() {
        return this.ocLowerFrontLeft;
    }

    public final OcCell<T> getCellOcLowerFrontRight() {
        return this.ocLowerFrontRight;
    }

    public final OcCell<T> getCellOcLowerBackLeft() {
        return this.ocLowerBackLeft;
    }

    public final OcCell<T> getCellOcLowerBackRight() {
        return this.ocLowerBackRight;
    }

    public final int getNumNodes() {
        return this.numNodes;
    }

    public final OcCell<T> getCellQuUpperBack() {
        return this.quUpperBack;
    }

    public final OcCell<T> getCellQuUpperFront() {
        return this.quUpperFront;
    }

    public final OcCell<T> getCellQuUpperLeft() {
        return this.quUpperLeft;
    }

    public final OcCell<T> getCellQuUpperRight() {
        return this.quUpperRight;
    }

    public final OcCell<T> getCellQuLowerBack() {
        return this.quLowerBack;
    }

    public final OcCell<T> getCellQuLowerFront() {
        return this.quLowerFront;
    }

    public final OcCell<T> getCellQuLowerLeft() {
        return this.quLowerLeft;
    }

    public final OcCell<T> getCellQuLowerRight() {
        return this.quLowerRight;
    }

    public final OcCell<T> getCellQuBackLeft() {
        return this.quBackLeft;
    }

    public final OcCell<T> getCellQuBackRight() {
        return this.quBackRight;
    }

    public final OcCell<T> getCellQuFrontLeft() {
        return this.quFrontLeft;
    }

    public final OcCell<T> getCellQuFrontRight() {
        return this.quFrontRight;
    }

    public final OcCell<T> getCellHUpper() {
        return this.hUpper;
    }

    public final OcCell<T> getCellHLower() {
        return this.hLower;
    }

    public final OcCell<T> getCellHLeft() {
        return this.hLeft;
    }

    public final OcCell<T> getCellHRight() {
        return this.hRight;
    }

    public final OcCell<T> getCellHBack() {
        return this.hBack;
    }

    public final OcCell<T> getCellHFront() {
        return this.hFront;
    }

    public final T getNode(int index) {
        return (T)((SpatialNode)this.nodes[index]);
    }

    public final boolean hasChildCells() {
        return this.hasChildCells;
    }

    private void reinsertNodes(int minNodesBeforeSplit, int maxLevelForExtendedCells) {
        int pushedNodes = 0;
        int i = 0;
        while (i < this.getNumNodes()) {
            OcCell<T> cell = this.findChildCell(this.getNode(i).getWorldBounds(), this.getNode(i).getWorldBounds().getType(), minNodesBeforeSplit, maxLevelForExtendedCells, true);
            if (cell != this) {
                super.insertNode_(this.getNode(i));
                this.nodes[i] = null;
                ++pushedNodes;
            }
            ++i;
        }
        if (pushedNodes > 0) {
            Object[] temp = this.newTArray(this.getNumNodes() - pushedNodes);
            int j = 0;
            int i2 = 0;
            while (i2 < this.getNumNodes()) {
                if (this.getNode(i2) != null) {
                    temp[j++] = this.getNode(i2);
                }
                ++i2;
            }
            this.nodes = temp;
            this.numNodes -= pushedNodes;
        }
    }

    protected OcCell<T> findChildCell(Bounds bounds, BoundsType type, int minNodesBeforeSplit, int maxLevelForExtendedCells, boolean ignoreReinserting) {
        if (!ignoreReinserting) {
            if (this.getNumNodes() < minNodesBeforeSplit) {
                return this;
            }
            if (this.getNumNodes() == minNodesBeforeSplit) {
                this.reinsertNodes(minNodesBeforeSplit, maxLevelForExtendedCells);
            }
        }
        if (BoundsHelper.getMinY(bounds, type) >= this.centerY) {
            if (BoundsHelper.getMinZ(bounds, type) >= this.centerZ) {
                if (BoundsHelper.getMinX(bounds, type) >= this.centerX) {
                    if (this.ocUpperFrontRight == null) {
                        this.ocUpperFrontRight = new OcCell<T>(this.getLevel() + 1, this.centerX + this.sizeX / 4.0f, this.centerY + this.sizeY / 4.0f, this.centerZ + this.sizeZ / 4.0f, this.halfSizeX, this.halfSizeY, this.halfSizeZ, this.useExtendedCells && this.level < maxLevelForExtendedCells);
                        this.hasChildCells = true;
                    }
                    return this.ocUpperFrontRight.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
                }
                if (BoundsHelper.getMaxX(bounds, type) <= this.centerX) {
                    if (this.ocUpperFrontLeft == null) {
                        this.ocUpperFrontLeft = new OcCell<T>(this.getLevel() + 1, this.centerX - this.sizeX / 4.0f, this.centerY + this.sizeY / 4.0f, this.centerZ + this.sizeZ / 4.0f, this.halfSizeX, this.halfSizeY, this.halfSizeZ, this.useExtendedCells && this.level < maxLevelForExtendedCells);
                        this.hasChildCells = true;
                    }
                    return this.ocUpperFrontLeft.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
                }
                if (this.useExtendedCells) {
                    if (this.quUpperFront == null) {
                        this.quUpperFront = new OcCell<T>(this.getLevel() + 1, this.centerX, this.centerY + this.sizeY / 4.0f, this.centerZ + this.sizeZ / 4.0f, this.sizeX, this.halfSizeY, this.halfSizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quUpperFront;
                }
                return this;
            }
            if (BoundsHelper.getMaxZ(bounds, type) <= this.centerZ) {
                if (BoundsHelper.getMinX(bounds, type) >= this.centerX) {
                    if (this.ocUpperBackRight == null) {
                        this.ocUpperBackRight = new OcCell<T>(this.getLevel() + 1, this.centerX + this.sizeX / 4.0f, this.centerY + this.sizeY / 4.0f, this.centerZ - this.sizeZ / 4.0f, this.halfSizeX, this.halfSizeY, this.halfSizeZ, this.useExtendedCells && this.level < maxLevelForExtendedCells);
                        this.hasChildCells = true;
                    }
                    return this.ocUpperBackRight.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
                }
                if (BoundsHelper.getMaxX(bounds, type) <= this.centerX) {
                    if (this.ocUpperBackLeft == null) {
                        this.ocUpperBackLeft = new OcCell<T>(this.getLevel() + 1, this.centerX - this.sizeX / 4.0f, this.centerY + this.sizeY / 4.0f, this.centerZ - this.sizeZ / 4.0f, this.halfSizeX, this.halfSizeY, this.halfSizeZ, this.useExtendedCells && this.level < maxLevelForExtendedCells);
                        this.hasChildCells = true;
                    }
                    return this.ocUpperBackLeft.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
                }
                if (this.useExtendedCells) {
                    if (this.quUpperBack == null) {
                        this.quUpperBack = new OcCell<T>(this.getLevel() + 1, this.centerX, this.centerY + this.sizeY / 4.0f, this.centerZ - this.sizeZ / 4.0f, this.sizeX, this.halfSizeY, this.halfSizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quUpperBack;
                }
                return this;
            }
            if (this.useExtendedCells) {
                if (BoundsHelper.getMaxX(bounds, type) <= this.centerX) {
                    if (this.quUpperLeft == null) {
                        this.quUpperLeft = new OcCell<T>(this.getLevel() + 1, this.centerX - this.sizeX / 4.0f, this.centerY + this.sizeY / 4.0f, this.centerZ, this.halfSizeX, this.halfSizeY, this.sizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quUpperLeft;
                }
                if (BoundsHelper.getMinX(bounds, type) >= this.centerX) {
                    if (this.quUpperRight == null) {
                        this.quUpperRight = new OcCell<T>(this.getLevel() + 1, this.centerX + this.sizeX / 4.0f, this.centerY + this.sizeY / 4.0f, this.centerZ, this.halfSizeX, this.halfSizeY, this.sizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quUpperRight;
                }
                if (this.hUpper == null) {
                    this.hUpper = new OcCell<T>(this.getLevel() + 1, this.centerX, this.centerY + this.sizeY / 4.0f, this.centerZ, this.sizeX, this.halfSizeY, this.sizeZ, false);
                    this.hasChildCells = true;
                }
                return this.hUpper;
            }
            return this;
        }
        if (BoundsHelper.getMaxY(bounds, type) <= this.centerY) {
            if (BoundsHelper.getMinZ(bounds, type) >= this.centerZ) {
                if (BoundsHelper.getMinX(bounds, type) >= this.centerX) {
                    if (this.ocLowerFrontRight == null) {
                        this.ocLowerFrontRight = new OcCell<T>(this.getLevel() + 1, this.centerX + this.sizeX / 4.0f, this.centerY - this.sizeY / 4.0f, this.centerZ + this.sizeZ / 4.0f, this.halfSizeX, this.halfSizeY, this.halfSizeZ, this.useExtendedCells && this.level < maxLevelForExtendedCells);
                        this.hasChildCells = true;
                    }
                    return this.ocLowerFrontRight.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
                }
                if (BoundsHelper.getMaxX(bounds, type) <= this.centerX) {
                    if (this.ocLowerFrontLeft == null) {
                        this.ocLowerFrontLeft = new OcCell<T>(this.getLevel() + 1, this.centerX - this.sizeX / 4.0f, this.centerY - this.sizeY / 4.0f, this.centerZ + this.sizeZ / 4.0f, this.halfSizeX, this.halfSizeY, this.halfSizeZ, this.useExtendedCells && this.level < maxLevelForExtendedCells);
                        this.hasChildCells = true;
                    }
                    return this.ocLowerFrontLeft.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
                }
                if (this.useExtendedCells) {
                    if (this.quLowerFront == null) {
                        this.quLowerFront = new OcCell<T>(this.getLevel() + 1, this.centerX, this.centerY - this.sizeY / 4.0f, this.centerZ + this.sizeZ / 4.0f, this.sizeX, this.halfSizeY, this.halfSizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quLowerFront;
                }
                return this;
            }
            if (BoundsHelper.getMaxZ(bounds, type) <= this.centerZ) {
                if (BoundsHelper.getMinX(bounds, type) >= this.centerX) {
                    if (this.ocLowerBackRight == null) {
                        this.ocLowerBackRight = new OcCell<T>(this.getLevel() + 1, this.centerX + this.sizeX / 4.0f, this.centerY - this.sizeY / 4.0f, this.centerZ - this.sizeZ / 4.0f, this.halfSizeX, this.halfSizeY, this.halfSizeZ, this.useExtendedCells && this.level < maxLevelForExtendedCells);
                        this.hasChildCells = true;
                    }
                    return this.ocLowerBackRight.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
                }
                if (BoundsHelper.getMaxX(bounds, type) <= this.centerX) {
                    if (this.ocLowerBackLeft == null) {
                        this.ocLowerBackLeft = new OcCell<T>(this.getLevel() + 1, this.centerX - this.sizeX / 4.0f, this.centerY - this.sizeY / 4.0f, this.centerZ - this.sizeZ / 4.0f, this.halfSizeX, this.halfSizeY, this.halfSizeZ, this.useExtendedCells && this.level < maxLevelForExtendedCells);
                        this.hasChildCells = true;
                    }
                    return this.ocLowerBackLeft.findChildCell(bounds, minNodesBeforeSplit, maxLevelForExtendedCells);
                }
                if (this.useExtendedCells) {
                    if (this.quLowerBack == null) {
                        this.quLowerBack = new OcCell<T>(this.getLevel() + 1, this.centerX, this.centerY - this.sizeY / 4.0f, this.centerZ - this.sizeZ / 4.0f, this.sizeX, this.halfSizeY, this.halfSizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quLowerBack;
                }
                return this;
            }
            if (this.useExtendedCells) {
                if (BoundsHelper.getMaxX(bounds, type) <= this.centerX) {
                    if (this.quLowerLeft == null) {
                        this.quLowerLeft = new OcCell<T>(this.getLevel() + 1, this.centerX - this.sizeX / 4.0f, this.centerY - this.sizeY / 4.0f, this.centerZ, this.halfSizeX, this.halfSizeY, this.sizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quLowerLeft;
                }
                if (BoundsHelper.getMinX(bounds, type) >= this.centerX) {
                    if (this.quLowerRight == null) {
                        this.quLowerRight = new OcCell<T>(this.getLevel() + 1, this.centerX + this.sizeX / 4.0f, this.centerY - this.sizeY / 4.0f, this.centerZ, this.halfSizeX, this.halfSizeY, this.sizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quLowerRight;
                }
                if (this.hLower == null) {
                    this.hLower = new OcCell<T>(this.getLevel() + 1, this.centerX, this.centerY - this.sizeY / 4.0f, this.centerZ, this.sizeX, this.halfSizeY, this.sizeZ, false);
                    this.hasChildCells = true;
                }
                return this.hLower;
            }
            return this;
        }
        if (this.useExtendedCells) {
            if (BoundsHelper.getMinZ(bounds, type) >= this.centerZ) {
                if (BoundsHelper.getMaxX(bounds, type) <= this.centerX) {
                    if (this.quFrontLeft == null) {
                        this.quFrontLeft = new OcCell<T>(this.getLevel() + 1, this.centerX - this.sizeX / 4.0f, this.centerY, this.centerZ + this.sizeZ / 4.0f, this.halfSizeX, this.sizeY, this.halfSizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quFrontLeft;
                }
                if (BoundsHelper.getMinX(bounds, type) >= this.centerX) {
                    if (this.quFrontRight == null) {
                        this.quFrontRight = new OcCell<T>(this.getLevel() + 1, this.centerX + this.sizeX / 4.0f, this.centerY, this.centerZ + this.sizeZ / 4.0f, this.halfSizeX, this.sizeY, this.halfSizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quFrontRight;
                }
                if (this.hFront == null) {
                    this.hFront = new OcCell<T>(this.getLevel() + 1, this.centerX, this.centerY, this.centerZ + this.sizeZ / 4.0f, this.sizeX, this.sizeY, this.halfSizeZ, false);
                    this.hasChildCells = true;
                }
                return this.hFront;
            }
            if (BoundsHelper.getMaxZ(bounds, type) <= this.centerZ) {
                if (BoundsHelper.getMaxX(bounds, type) <= this.centerX) {
                    if (this.quBackLeft == null) {
                        this.quBackLeft = new OcCell<T>(this.getLevel() + 1, this.centerX - this.sizeX / 4.0f, this.centerY, this.centerZ - this.sizeZ / 4.0f, this.halfSizeX, this.sizeY, this.halfSizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quBackLeft;
                }
                if (BoundsHelper.getMinX(bounds, type) >= this.centerX) {
                    if (this.quBackRight == null) {
                        this.quBackRight = new OcCell<T>(this.getLevel() + 1, this.centerX + this.sizeX / 4.0f, this.centerY, this.centerZ - this.sizeZ / 4.0f, this.halfSizeX, this.sizeY, this.halfSizeZ, false);
                        this.hasChildCells = true;
                    }
                    return this.quBackRight;
                }
                if (this.hBack == null) {
                    this.hBack = new OcCell<T>(this.getLevel() + 1, this.centerX, this.centerY, this.centerZ - this.sizeZ / 4.0f, this.sizeX, this.sizeY, this.halfSizeZ, false);
                    this.hasChildCells = true;
                }
                return this.hBack;
            }
            if (BoundsHelper.getMaxX(bounds, type) <= this.centerX) {
                if (this.hLeft == null) {
                    this.hLeft = new OcCell<T>(this.getLevel() + 1, this.centerX - this.sizeX / 4.0f, this.centerY, this.centerZ, this.halfSizeX, this.sizeY, this.sizeZ, false);
                    this.hasChildCells = true;
                }
                return this.hLeft;
            }
            if (BoundsHelper.getMinX(bounds, type) >= this.centerX) {
                if (this.hRight == null) {
                    this.hRight = new OcCell<T>(this.getLevel() + 1, this.centerX + this.sizeX / 4.0f, this.centerY, this.centerZ, this.halfSizeX, this.sizeY, this.sizeZ, false);
                    this.hasChildCells = true;
                }
                return this.hRight;
            }
        }
        return this;
    }

    protected OcCell<T> findChildCell(Bounds bounds, int minNodesBeforeSplit, int maxLevelForExtendedCells) {
        switch (bounds.getType()) {
            case SPHERE: 
            case AABB: {
                return this.findChildCell(bounds, bounds.getType(), minNodesBeforeSplit, maxLevelForExtendedCells, false);
            }
        }
        return this;
    }

    protected OcCell<T> findChildCell(T node2, int minNodesBeforeSplit, int maxLevelForExtendedCells) {
        return this.findChildCell((T)node2.getWorldBounds(), minNodesBeforeSplit, maxLevelForExtendedCells);
    }

    private final void insertNode_(T node2) {
        double growFactor = 1.0;
        if (this.numNodes == this.nodes.length) {
            Object[] nodes2 = this.newTArray((int)((double)(this.numNodes + 1) * 1.0));
            System.arraycopy(this.nodes, 0, nodes2, 0, this.numNodes);
            this.nodes = nodes2;
        }
        this.nodes[this.numNodes++] = node2;
        node2.setTreeCell(this);
    }

    public int insertNode(T node2, int minNodesBeforeSplit, int maxLevelForExtendedCells) {
        OcCell<T> cell = this.findChildCell(node2, minNodesBeforeSplit, maxLevelForExtendedCells);
        super.insertNode_(node2);
        return cell.getLevel();
    }

    private final void removeNode_(T node2) {
        int index = -1;
        int i = 0;
        while (i < this.numNodes) {
            if (this.nodes[i] == node2) {
                index = i;
                break;
            }
            ++i;
        }
        System.arraycopy(this.nodes, index + 1, this.nodes, index, this.numNodes - index - 1);
        --this.numNodes;
        node2.setTreeCell(null);
    }

    public boolean removeNode(T node2) {
        Object treeCellObj = node2.getTreeCell();
        if (treeCellObj == null) {
            return false;
        }
        OcCell treeCell = (OcCell)treeCellObj;
        treeCell.removeNode_(node2);
        return true;
    }

    public void clear() {
        int i = 0;
        while (i < this.nodes.length) {
            this.nodes[i] = null;
            ++i;
        }
        this.numNodes = 0;
        this.ocUpperFrontLeft = null;
        this.ocUpperFrontRight = null;
        this.ocUpperBackLeft = null;
        this.ocUpperBackRight = null;
        this.ocLowerFrontLeft = null;
        this.ocLowerFrontRight = null;
        this.ocLowerBackLeft = null;
        this.ocLowerBackRight = null;
        this.quUpperBack = null;
        this.quUpperFront = null;
        this.quUpperLeft = null;
        this.quUpperRight = null;
        this.quLowerBack = null;
        this.quLowerFront = null;
        this.quLowerLeft = null;
        this.quLowerRight = null;
        this.quBackLeft = null;
        this.quBackRight = null;
        this.quFrontLeft = null;
        this.quFrontRight = null;
        this.hUpper = null;
        this.hLower = null;
        this.hLeft = null;
        this.hRight = null;
        this.hBack = null;
        this.hFront = null;
    }

    private static final void printIndentation(int indentation, PrintStream ps) {
        int i = 0;
        while (i < indentation) {
            ps.print("  ");
            ++i;
        }
    }

    private void dumpCellSize(PrintStream ps) {
        if (this.sizeX == this.sizeY && this.sizeY == this.sizeZ) {
            ps.print(this.sizeX);
        } else {
            ps.print(String.valueOf(this.sizeX) + ", " + this.sizeY + ", " + this.sizeZ);
        }
    }

    void dump(String cellName, int indentation, PrintStream ps) {
        OcCell.printIndentation(indentation, ps);
        ps.print(String.valueOf(this.getClass().getSimpleName()) + " \"" + cellName + "\" ( level: " + this.getLevel() + ", center: [ " + this.centerX + ", " + this.centerY + ", " + this.centerZ + "], size: ");
        this.dumpCellSize(ps);
        ps.println(" )");
        OcCell.printIndentation(indentation, ps);
        ps.println("{");
        OcCell.printIndentation(indentation + 1, ps);
        if (this.numNodes == 0) {
            ps.println("Nodes:");
            OcCell.printIndentation(indentation + 1, ps);
            ps.println("[No nodes]");
        } else {
            ps.println("Nodes (" + this.numNodes + "):");
            int i = 0;
            while (i < this.numNodes) {
                OcCell.printIndentation(indentation + 1, ps);
                ps.println(this.nodes[i] + ", " + ((SpatialNode)this.nodes[i]).getWorldBounds());
                ++i;
            }
        }
        if (this.hasChildCells()) {
            OcCell.printIndentation(indentation + 1, ps);
            ps.println("");
            OcCell.dump(this.hUpper, "hUpper", indentation + 1, ps);
            OcCell.dump(this.hLower, "hLower", indentation + 1, ps);
            OcCell.dump(this.hLeft, "hLeft", indentation + 1, ps);
            OcCell.dump(this.hRight, "hRight", indentation + 1, ps);
            OcCell.dump(this.hBack, "hBack", indentation + 1, ps);
            OcCell.dump(this.hFront, "hFront", indentation + 1, ps);
            OcCell.dump(this.quUpperBack, "quUpperBack", indentation + 1, ps);
            OcCell.dump(this.quUpperFront, "quUpperFront", indentation + 1, ps);
            OcCell.dump(this.quUpperLeft, "quUpperLeft", indentation + 1, ps);
            OcCell.dump(this.quUpperRight, "quUpperRight", indentation + 1, ps);
            OcCell.dump(this.quLowerBack, "quLowerBack", indentation + 1, ps);
            OcCell.dump(this.quLowerFront, "quLowerFront", indentation + 1, ps);
            OcCell.dump(this.quLowerLeft, "quLowerLeft", indentation + 1, ps);
            OcCell.dump(this.quLowerRight, "quLowerRight", indentation + 1, ps);
            OcCell.dump(this.quBackLeft, "quBackLeft", indentation + 1, ps);
            OcCell.dump(this.quBackRight, "quBackRight", indentation + 1, ps);
            OcCell.dump(this.quFrontLeft, "quFrontLeft", indentation + 1, ps);
            OcCell.dump(this.quFrontRight, "quFrontRight", indentation + 1, ps);
            OcCell.dump(this.ocUpperFrontLeft, "ocUpperFrontLeft", indentation + 1, ps);
            OcCell.dump(this.ocUpperFrontRight, "ocUpperFrontRight", indentation + 1, ps);
            OcCell.dump(this.ocUpperBackLeft, "ocUpperBackLeft", indentation + 1, ps);
            OcCell.dump(this.ocUpperBackRight, "ocUpperBackRight", indentation + 1, ps);
            OcCell.dump(this.ocLowerFrontLeft, "ocLowerFrontLeft", indentation + 1, ps);
            OcCell.dump(this.ocLowerFrontRight, "ocLowerFrontRight", indentation + 1, ps);
            OcCell.dump(this.ocLowerBackLeft, "ocLowerBackLeft", indentation + 1, ps);
            OcCell.dump(this.ocLowerBackRight, "ocLowerBackRight", indentation + 1, ps);
        }
        OcCell.printIndentation(indentation, ps);
        ps.println("}");
    }

    static final void dump(OcCell<?> cell, String cellName, int indentation, PrintStream ps) {
        if (cell == null) {
            return;
        }
        cell.dump(cellName, indentation, ps);
    }

    public void dump() {
        OcCell.dump(this, "root", 0, System.out);
    }

    protected OcCell(int level, float centerX, float centerY, float centerZ, float sizeX, float sizeY, float sizeZ, boolean useExtendedCells) {
        super(centerX - sizeX / 2.0f, centerY - sizeY / 2.0f, centerZ - sizeZ / 2.0f, centerX + sizeX / 2.0f, centerY + sizeY / 2.0f, centerZ + sizeZ / 2.0f);
        this.level = level;
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.halfSizeX = sizeX / 2.0f;
        this.halfSizeY = sizeY / 2.0f;
        this.halfSizeZ = sizeZ / 2.0f;
        this.useExtendedCells = useExtendedCells;
        this.nodes = new Object[8];
    }

    public OcCell(int level, float centerX, float centerY, float centerZ, float sizeX, float sizeY, float sizeZ) {
        this(level, centerX, centerY, centerZ, sizeX, sizeY, sizeZ, true);
    }

    public OcCell(int level, float centerX, float centerY, float centerZ, float size, boolean useExtendedCells) {
        this(level, centerX, centerY, centerZ, size, size, size, useExtendedCells);
    }

    public OcCell(int level, float centerX, float centerY, float centerZ, float size) {
        this(level, centerX, centerY, centerZ, size, size, size, false);
    }
}

