/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.spatial.octree;

import org.openmali.spatial.SpatialNode;
import org.openmali.spatial.octree.OcCell;
import org.openmali.vecmath2.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OcTree<T extends SpatialNode> {
    private final OcCell<T> rootCell;
    private int minNodesBeforeSplit = 8;
    private int maxLevelForExtendedCells = 0;
    private int maxLevel = 0;

    public final OcCell<T> getRootCell() {
        return this.rootCell;
    }

    public final int getMaxLevel() {
        return this.maxLevel;
    }

    public final float getCenterX() {
        return this.rootCell.getCenterX();
    }

    public final float getCenterY() {
        return this.rootCell.getCenterY();
    }

    public final float getCenterZ() {
        return this.rootCell.getCenterZ();
    }

    public final float getSizeX() {
        return this.rootCell.getSizeX();
    }

    public final float getSizeY() {
        return this.rootCell.getSizeY();
    }

    public final float getSizeZ() {
        return this.rootCell.getSizeZ();
    }

    public void setMinNodesBeforeSplit(int minNodesBeforeSplit) {
        this.minNodesBeforeSplit = minNodesBeforeSplit;
    }

    public final int getMinNodesBeforeSplit() {
        return this.minNodesBeforeSplit;
    }

    public void setMaxLevelForExtendedCells(int maxLevelForExtendedCells) {
        this.maxLevelForExtendedCells = maxLevelForExtendedCells;
    }

    public final int getMaxLevelForExtendedCells() {
        return this.maxLevelForExtendedCells;
    }

    public final int insertNode(T node2) {
        int level = this.rootCell.insertNode(node2, this.getMinNodesBeforeSplit(), this.getMaxLevelForExtendedCells());
        if (level > this.maxLevel) {
            this.maxLevel = level;
        }
        return level;
    }

    public final void removeNode(T node2) {
        this.rootCell.removeNode(node2);
    }

    public final void clear() {
        this.rootCell.clear();
    }

    public final void updateNodePosition(T node2) {
        if (this.rootCell.removeNode(node2)) {
            this.insertNode(node2);
        }
    }

    public void dump() {
        System.out.println(String.valueOf(this.getClass().getSimpleName()) + " ( max-level: " + this.getMaxLevel() + " )");
        this.rootCell.dump();
    }

    public OcTree(float centerX, float centerY, float centerZ, float sizeX, float sizeY, float sizeZ, boolean useExtendedCells) {
        this.rootCell = new OcCell(0, centerX, centerY, centerZ, sizeX, sizeY, sizeZ, useExtendedCells);
    }

    public OcTree(Tuple3f center, float sizeX, float sizeY, float sizeZ, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), sizeX, sizeY, sizeZ, useExtendedCells);
    }

    public OcTree(float centerX, float centerY, float centerZ, float size, boolean useExtendedCells) {
        this.rootCell = new OcCell(0, centerX, centerY, centerZ, size, useExtendedCells);
    }

    public OcTree(Tuple3f center, float size, boolean useExtendedCells) {
        this(center.getX(), center.getY(), center.getZ(), size, useExtendedCells);
    }
}

