/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.FastMath;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.pools.AxisAngle3fPool;
import org.openmali.vecmath2.util.SerializationUtils;
import org.openmali.vecmath2.util.VecMathUtils;

public class AxisAngle3f
extends Tuple3f
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 3228663669018590981L;
    public static final AxisAngle3f ZERO = AxisAngle3f.newReadOnly(0.0f, 0.0f, 0.0f, 0.0f);
    private static final ThreadLocal<AxisAngle3fPool> POOL = new ThreadLocal<AxisAngle3fPool>(){

        @Override
        protected AxisAngle3fPool initialValue() {
            return new AxisAngle3fPool(128);
        }
    };
    private float angle;

    public final void setAngle(float angle) {
        this.values[this.roTrick + 0] = this.values[0];
        this.angle = angle;
        this.isDirty[0] = true;
    }

    public final float getAngle() {
        return this.angle;
    }

    public final void set(Tuple3f axis, float angle) {
        super.set((TupleNf)axis);
        this.setAngle(angle);
    }

    public final void set(float x, float y, float z, float angle) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setAngle(angle);
    }

    public final AxisAngle3f set(float[] values) {
        super.set(values);
        this.setAngle(values[3]);
        return this;
    }

    public final void set(AxisAngle3f aa3f) {
        super.set((TupleNf)aa3f);
        this.setAngle(aa3f.getAngle());
    }

    public final void get(float[] buffer) {
        super.get(buffer);
        buffer[3] = this.getAngle();
    }

    public final void set(Matrix4f mat) {
        this.setFromMat(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
    }

    public final void set(Matrix3f mat) {
        this.setFromMat(mat.m00(), mat.m01(), mat.m02(), mat.m10(), mat.m11(), mat.m12(), mat.m20(), mat.m21(), mat.m22());
    }

    public final void set(Quaternion4f quat) {
        this.setFromQuat(quat.getA(), quat.getB(), quat.getC(), quat.getD());
    }

    public final AxisAngle3f addAngle(float v) {
        this.setAngle(this.getAngle() + v);
        return this;
    }

    public final AxisAngle3f subAngle(float v) {
        this.setAngle(this.getAngle() - v);
        return this;
    }

    public final AxisAngle3f mulAngle(float v) {
        this.setAngle(this.getAngle() * v);
        return this;
    }

    public final AxisAngle3f divAngle(float v) {
        this.setAngle(this.getAngle() / v);
        return this;
    }

    private final void setFromMat(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float cos = (m00 + m11 + m22 - 1.0f) * 0.5f;
        this.setX(m21 - m12);
        this.setY(m02 - m20);
        this.setZ(m10 - m01);
        float sin = 0.5f * FastMath.sqrt(this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ());
        this.setAngle(FastMath.atan2(sin, cos));
    }

    private final void setFromQuat(float x, float y, float z, float w) {
        float sin_a2 = FastMath.sqrt(x * x + y * y + z * z);
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setAngle(2.0f * FastMath.atan2(sin_a2, w));
    }

    public String toString() {
        return "[ " + super.toString() + ", " + this.angle + " ]";
    }

    public int hashCode() {
        return VecMathUtils.floatToIntBits(this.getX()) ^ VecMathUtils.floatToIntBits(this.getY()) ^ VecMathUtils.floatToIntBits(this.getZ()) ^ VecMathUtils.floatToIntBits(this.getAngle());
    }

    public boolean equals(AxisAngle3f aa3f) {
        if (!super.equals(aa3f)) {
            return false;
        }
        return aa3f.angle == this.angle;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof AxisAngle3f && this.equals((AxisAngle3f)o);
    }

    public boolean epsilonEquals(AxisAngle3f aa3f, float epsilon) {
        if (!super.epsilonEquals(aa3f, epsilon)) {
            return false;
        }
        return Math.abs(aa3f.angle - this.angle) <= epsilon;
    }

    public AxisAngle3f clone() {
        return new AxisAngle3f(this);
    }

    public int serialize(int pos, byte[] buffer) {
        pos = super.serialize(pos, buffer);
        SerializationUtils.writeToBuffer(this.angle, pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        pos = super.deserialize(pos, buffer);
        this.angle = SerializationUtils.readFloatFromBuffer(pos, buffer);
        return ++pos;
    }

    protected int getSerializationBufferSize() {
        return super.getSerializationBufferSize() + 4;
    }

    protected AxisAngle3f(boolean readOnly, float x, float y, float z, float angle) {
        super(readOnly, x, y, z);
        this.angle = angle;
    }

    protected AxisAngle3f(boolean readOnly, float[] values) {
        this(readOnly, values[0], values[1], values[2], values[3]);
    }

    protected AxisAngle3f(boolean readOnly, AxisAngle3f aa3f) {
        this(readOnly, aa3f.getX(), aa3f.getY(), aa3f.getZ(), aa3f.getAngle());
    }

    protected AxisAngle3f(boolean readOnly, Tuple3f axis, float angle) {
        this(readOnly, axis.getX(), axis.getY(), axis.getZ(), angle);
    }

    protected AxisAngle3f(boolean readOnly) {
        this(readOnly, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public AxisAngle3f(float x, float y, float z, float angle) {
        this(false, x, y, z, angle);
    }

    public AxisAngle3f(float[] values) {
        this(false, values);
    }

    public AxisAngle3f(AxisAngle3f aa3f) {
        this(false, aa3f);
    }

    public AxisAngle3f(Tuple3f axis, float angle) {
        this(false, axis, angle);
    }

    public AxisAngle3f() {
        this(false, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static AxisAngle3f newReadOnly(float x, float y, float z, float angle) {
        return new AxisAngle3f(true, x, y, z, angle);
    }

    public static AxisAngle3f newReadOnly(float[] values) {
        return new AxisAngle3f(true, values);
    }

    public static AxisAngle3f newReadOnly(AxisAngle3f aa3f) {
        return new AxisAngle3f(true, aa3f);
    }

    public static AxisAngle3f newReadOnly(Tuple3f axis, float angle) {
        return new AxisAngle3f(true, axis, angle);
    }

    public static AxisAngle3f newReadOnly() {
        return new AxisAngle3f(true, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static AxisAngle3f fromPool() {
        return POOL.get().alloc();
    }

    public static AxisAngle3f fromPool(float x, float y, float z, float angle) {
        return POOL.get().alloc(x, y, z, angle);
    }

    public static AxisAngle3f fromPool(AxisAngle3f aa) {
        return AxisAngle3f.fromPool(aa.getX(), aa.getY(), aa.getZ(), aa.getAngle());
    }

    public static void toPool(AxisAngle3f o) {
        POOL.get().free(o);
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly() {
        return AxisAngle3f.newReadOnly();
    }

    public static /* bridge */ /* synthetic */ Tuple3f newReadOnly(float[] fArray) {
        return AxisAngle3f.newReadOnly(fArray);
    }

    public static /* bridge */ /* synthetic */ Tuple3f fromPool() {
        return AxisAngle3f.fromPool();
    }
}

