/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.openmali.FastMath;
import org.openmali.vecmath2.AxisAngle3f;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.MatrixMxNf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Quaternion4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.openmali.vecmath2.Vector4f;
import org.openmali.vecmath2.pools.Matrix4fPool;
import org.openmali.vecmath2.util.VecMathUtils;

public class Matrix4f
extends MatrixMxNf
implements Externalizable {
    private static final long serialVersionUID = 7087741531605103802L;
    public static final Matrix4f ZERO = Matrix4f.newReadOnly(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    public static final Matrix4f IDENTITY = Matrix4f.newReadOnly(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    public static final Matrix4f ROT_PLUS_90_DEG_BY_X_AXIS = new Matrix4f(true, Matrix3f.ROT_PLUS_90_DEG_BY_X_AXIS);
    public static final Matrix4f ROT_MINUS_90_DEG_BY_X_AXIS = new Matrix4f(true, Matrix3f.ROT_MINUS_90_DEG_BY_X_AXIS);
    public static final Matrix4f ROT_PLUS_90_DEG_BY_Y_AXIS = new Matrix4f(true, Matrix3f.ROT_PLUS_90_DEG_BY_Y_AXIS);
    public static final Matrix4f ROT_MINUS_90_DEG_BY_Y_AXIS = new Matrix4f(true, Matrix3f.ROT_MINUS_90_DEG_BY_Y_AXIS);
    public static final Matrix4f ROT_PLUS_90_DEG_BY_Z_AXIS = new Matrix4f(true, Matrix3f.ROT_PLUS_90_DEG_BY_Z_AXIS);
    public static final Matrix4f ROT_MINUS_90_DEG_BY_Z_AXIS = new Matrix4f(true, Matrix3f.ROT_MINUS_90_DEG_BY_Z_AXIS);
    public static final Matrix4f Z_UP_TO_Y_UP = ROT_MINUS_90_DEG_BY_X_AXIS;
    private static final ThreadLocal<Matrix4fPool> POOL = new ThreadLocal<Matrix4fPool>(){

        @Override
        protected Matrix4fPool initialValue() {
            return new Matrix4fPool(128);
        }
    };
    private Matrix4f readOnlyInstance = null;
    protected static final int M = 4;
    protected static final int N = 4;

    public final float m00() {
        return this.get(0, 0);
    }

    public final float m01() {
        return this.get(0, 1);
    }

    public final float m02() {
        return this.get(0, 2);
    }

    public final float m03() {
        return this.get(0, 3);
    }

    public final float m10() {
        return this.get(1, 0);
    }

    public final float m11() {
        return this.get(1, 1);
    }

    public final float m12() {
        return this.get(1, 2);
    }

    public final float m13() {
        return this.get(1, 3);
    }

    public final float m20() {
        return this.get(2, 0);
    }

    public final float m21() {
        return this.get(2, 1);
    }

    public final float m22() {
        return this.get(2, 2);
    }

    public final float m23() {
        return this.get(2, 3);
    }

    public final float m30() {
        return this.get(3, 0);
    }

    public final float m31() {
        return this.get(3, 1);
    }

    public final float m32() {
        return this.get(3, 2);
    }

    public final float m33() {
        return this.get(3, 3);
    }

    public final Matrix4f m00(float v) {
        this.set(0, 0, v);
        return this;
    }

    public final Matrix4f m01(float v) {
        this.set(0, 1, v);
        return this;
    }

    public final Matrix4f m02(float v) {
        this.set(0, 2, v);
        return this;
    }

    public final Matrix4f m03(float v) {
        this.set(0, 3, v);
        return this;
    }

    public final Matrix4f m10(float v) {
        this.set(1, 0, v);
        return this;
    }

    public final Matrix4f m11(float v) {
        this.set(1, 1, v);
        return this;
    }

    public final Matrix4f m12(float v) {
        this.set(1, 2, v);
        return this;
    }

    public final Matrix4f m13(float v) {
        this.set(1, 3, v);
        return this;
    }

    public final Matrix4f m20(float v) {
        this.set(2, 0, v);
        return this;
    }

    public final Matrix4f m21(float v) {
        this.set(2, 1, v);
        return this;
    }

    public final Matrix4f m22(float v) {
        this.set(2, 2, v);
        return this;
    }

    public final Matrix4f m23(float v) {
        this.set(2, 3, v);
        return this;
    }

    public final Matrix4f m30(float v) {
        this.set(3, 0, v);
        return this;
    }

    public final Matrix4f m31(float v) {
        this.set(3, 1, v);
        return this;
    }

    public final Matrix4f m32(float v) {
        this.set(3, 2, v);
        return this;
    }

    public final Matrix4f m33(float v) {
        this.set(3, 3, v);
        return this;
    }

    public final Matrix4f set(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        if (!this.isSubMatrix()) {
            this.values[0] = m00;
            this.values[1] = m01;
            this.values[2] = m02;
            this.values[3] = m03;
            this.values[4] = m10;
            this.values[5] = m11;
            this.values[6] = m12;
            this.values[7] = m13;
            this.values[8] = m20;
            this.values[9] = m21;
            this.values[10] = m22;
            this.values[11] = m23;
            this.values[12] = m30;
            this.values[13] = m31;
            this.values[14] = m32;
            this.values[15] = m33;
            this.isDirty[0] = true;
        } else {
            this.m00(m00);
            this.m01(m01);
            this.m02(m02);
            this.m03(m03);
            this.m10(m10);
            this.m11(m11);
            this.m12(m12);
            this.m13(m13);
            this.m20(m20);
            this.m21(m21);
            this.m22(m22);
            this.m23(m23);
            this.m30(m30);
            this.m31(m31);
            this.m32(m32);
            this.m33(m33);
        }
        return this;
    }

    public final Matrix4f set(float scale) {
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        if (!this.isSubMatrix()) {
            this.values[0] = scale;
            this.values[1] = 0.0f;
            this.values[2] = 0.0f;
            this.values[3] = 0.0f;
            this.values[4] = 0.0f;
            this.values[5] = scale;
            this.values[6] = 0.0f;
            this.values[7] = 0.0f;
            this.values[8] = 0.0f;
            this.values[9] = 0.0f;
            this.values[10] = scale;
            this.values[11] = 0.0f;
            this.values[12] = 0.0f;
            this.values[13] = 0.0f;
            this.values[14] = 0.0f;
            this.values[15] = 0.0f;
            this.isDirty[0] = true;
        } else {
            this.m00(scale);
            this.m01(0.0f);
            this.m02(0.0f);
            this.m03(0.0f);
            this.m10(0.0f);
            this.m11(scale);
            this.m12(0.0f);
            this.m13(0.0f);
            this.m20(0.0f);
            this.m21(0.0f);
            this.m22(scale);
            this.m23(0.0f);
            this.m30(0.0f);
            this.m31(0.0f);
            this.m32(0.0f);
            this.m33(1.0f);
        }
        return this;
    }

    public void set(Matrix3f mat) {
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        this.values[0] = mat.m00();
        this.values[1] = mat.m01();
        this.values[2] = mat.m02();
        this.values[3] = 0.0f;
        this.values[4] = mat.m10();
        this.values[5] = mat.m11();
        this.values[6] = mat.m12();
        this.values[7] = 0.0f;
        this.values[8] = mat.m20();
        this.values[9] = mat.m21();
        this.values[10] = mat.m22();
        this.values[11] = 0.0f;
        this.values[12] = 0.0f;
        this.values[13] = 0.0f;
        this.values[14] = 0.0f;
        this.values[15] = 1.0f;
        this.isDirty[0] = true;
    }

    public final Matrix4f set(Tuple3f pos) {
        this.setIdentity();
        this.setTranslation(pos);
        return this;
    }

    public final Matrix4f set(float scale, Tuple3f pos) {
        this.set(scale);
        this.setTranslation(pos);
        return this;
    }

    public final Matrix4f set(Tuple3f pos, float scale) {
        this.m00(scale);
        this.m01(0.0f);
        this.m02(0.0f);
        this.m03(scale * pos.getX());
        this.m10(0.0f);
        this.m11(scale);
        this.m12(0.0f);
        this.m13(scale * pos.getY());
        this.m20(0.0f);
        this.m21(0.0f);
        this.m22(scale);
        this.m23(scale * pos.getZ());
        this.m30(0.0f);
        this.m31(0.0f);
        this.m32(0.0f);
        this.m33(1.0f);
        return this;
    }

    public final Matrix4f set(Matrix3f mat, Tuple3f pos, float scale) {
        this.setRotationScale(mat);
        this.mulRotationScale(scale);
        this.setTranslation(pos);
        this.set(3, 3, 1.0f);
        return this;
    }

    public final Matrix4f setTranslation(float transX, float transY, float transZ) {
        this.set(0, 3, transX);
        this.set(1, 3, transY);
        this.set(2, 3, transZ);
        return this;
    }

    public final Matrix4f setTranslation(Tuple3f trans) {
        this.set(0, 3, trans.getX());
        this.set(1, 3, trans.getY());
        this.set(2, 3, trans.getZ());
        return this;
    }

    public final Matrix4f set(Quaternion4f quat) {
        this.setFromQuat(quat.getA(), quat.getB(), quat.getC(), quat.getD());
        return this;
    }

    public final Matrix4f set(AxisAngle3f aa3f) {
        this.setFromAxisAngle(aa3f.getX(), aa3f.getY(), aa3f.getZ(), aa3f.getAngle());
        return this;
    }

    public final Matrix4f set(Quaternion4f quat, Tuple3f pos, float scale) {
        this.set(quat);
        this.mulRotationScale(scale);
        this.set(0, 3, pos.getX());
        this.set(1, 3, pos.getY());
        this.set(2, 3, pos.getZ());
        return this;
    }

    public final Matrix4f setScale(float scale) {
        this.SVD(null, this);
        this.mulRotationScale(scale);
        return this;
    }

    public final void get(Matrix3f mat) {
        this.SVD(mat, null);
    }

    public final float get(Matrix3f mat, Tuple3f pos) {
        this.get(pos);
        return this.SVD(mat, null);
    }

    public final void get(Quaternion4f quat) {
        quat.set(this);
        quat.normalize();
    }

    public FloatBuffer writeToBuffer(FloatBuffer buffer, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.put(this.values[0]).put(this.values[4]).put(this.values[8]).put(this.values[12]).put(this.values[1]).put(this.values[5]).put(this.values[9]).put(this.values[13]).put(this.values[2]).put(this.values[6]).put(this.values[10]).put(this.values[14]).put(this.values[3]).put(this.values[7]).put(this.values[11]).put(this.values[15]);
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public FloatBuffer writeToBuffer(FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        buffer.put(this.values[0]).put(this.values[4]).put(this.values[8]).put(this.values[12]).put(this.values[1]).put(this.values[5]).put(this.values[9]).put(this.values[13]).put(this.values[2]).put(this.values[6]).put(this.values[10]).put(this.values[14]).put(this.values[3]).put(this.values[7]).put(this.values[11]).put(this.values[15]);
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public static FloatBuffer writeToBuffer(Matrix4f[] matrices, FloatBuffer buffer, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        int i = 0;
        while (i < matrices.length) {
            matrices[i].writeToBuffer(buffer, false, false);
            ++i;
        }
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public static FloatBuffer writeToBuffer(Matrix4f[] matrices, FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        int i = 0;
        while (i < matrices.length) {
            matrices[i].writeToBuffer(buffer, false, false);
            ++i;
        }
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public FloatBuffer readFromBuffer(FloatBuffer buffer) {
        buffer.get(this.values, 0, 1).get(this.values, 4, 1).get(this.values, 8, 1).get(this.values, 12, 1).get(this.values, 1, 1).get(this.values, 5, 1).get(this.values, 9, 1).get(this.values, 13, 1).get(this.values, 2, 1).get(this.values, 6, 1).get(this.values, 10, 1).get(this.values, 14, 1).get(this.values, 3, 1).get(this.values, 7, 1).get(this.values, 11, 1).get(this.values, 15, 1);
        return buffer;
    }

    public FloatBuffer readFromBuffer(FloatBuffer buffer, int position) {
        buffer.position(position);
        buffer.get(this.values, 0, 1).get(this.values, 4, 1).get(this.values, 8, 1).get(this.values, 12, 1).get(this.values, 1, 1).get(this.values, 5, 1).get(this.values, 9, 1).get(this.values, 13, 1).get(this.values, 2, 1).get(this.values, 6, 1).get(this.values, 10, 1).get(this.values, 14, 1).get(this.values, 3, 1).get(this.values, 7, 1).get(this.values, 11, 1).get(this.values, 15, 1);
        return buffer;
    }

    public static FloatBuffer readFromBuffer(Matrix4f[] matrices, FloatBuffer buffer) {
        int i = 0;
        while (i < matrices.length) {
            matrices[i].readFromBuffer(buffer);
            ++i;
        }
        return buffer;
    }

    public static FloatBuffer readFromBuffer(Matrix4f[] matrices, FloatBuffer buffer, int position) {
        buffer.position(position);
        int i = 0;
        while (i < matrices.length) {
            matrices[i].readFromBuffer(buffer);
            ++i;
        }
        return buffer;
    }

    public final void get(Tuple3f trans) {
        trans.set(this.m03(), this.m13(), this.m23());
    }

    public final void getRotationScale(Matrix3f mat) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                mat.set(i, j, this.get(i, j));
                ++j;
            }
            ++i;
        }
    }

    public final float getScale() {
        return this.SVD(null);
    }

    public final Matrix4f setRotationScale(Matrix3f mat) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                this.set(i, j, mat.get(i, j));
                ++j;
            }
            ++i;
        }
        return this;
    }

    public final Matrix4f setRow(int row, float x, float y, float z, float w) {
        if (row >= 0 && row <= 4) {
            this.set(row, 0, x);
            this.set(row, 1, y);
            this.set(row, 2, z);
            this.set(row, 3, w);
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 4 and is " + row);
    }

    public final Matrix4f setRow(int row, Vector4f values) {
        if (row >= 0 && row <= 4) {
            this.set(row, 0, values.getX());
            this.set(row, 1, values.getY());
            this.set(row, 2, values.getZ());
            this.set(row, 3, values.getW());
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 4 and is " + row);
    }

    public final Matrix4f getRow(int row, Vector4f buffer) {
        if (row >= 0 && row <= 4) {
            buffer.setX(this.get(row, 0));
            buffer.setY(this.get(row, 1));
            buffer.setZ(this.get(row, 2));
            buffer.setW(this.get(row, 3));
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("row must be 0 to 4 and is " + row);
    }

    public final Matrix4f setColumn(int column, float x, float y, float z, float w) {
        if (column >= 0 && column <= 4) {
            this.set(0, column, x);
            this.set(1, column, y);
            this.set(2, column, z);
            this.set(3, column, w);
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("column must be 0 to 4 and is " + column);
    }

    public final Matrix4f setColumn(int column, Vector4f values) {
        if (column >= 0 && column <= 4) {
            this.set(0, column, values.getX());
            this.set(1, column, values.getY());
            this.set(2, column, values.getZ());
            this.set(3, column, values.getW());
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("column must be 0 to 4 and is " + column);
    }

    public final void getColumn(int column, Vector4f buffer) {
        if (column < 0 || column > 4) {
            throw new ArrayIndexOutOfBoundsException("column must be 0 to 4 and is " + column);
        }
        buffer.setX(this.get(0, column));
        buffer.setY(this.get(1, column));
        buffer.setZ(this.get(2, column));
        buffer.setW(this.get(3, column));
    }

    public final float determinant() {
        return (this.m00() * this.m11() - this.m01() * this.m10()) * (this.m22() * this.m33() - this.m23() * this.m32()) - (this.m00() * this.m12() - this.m02() * this.m10()) * (this.m21() * this.m33() - this.m23() * this.m31()) + (this.m00() * this.m13() - this.m03() * this.m10()) * (this.m21() * this.m32() - this.m22() * this.m31()) + (this.m01() * this.m12() - this.m02() * this.m11()) * (this.m20() * this.m33() - this.m23() * this.m30()) - (this.m01() * this.m13() - this.m03() * this.m11()) * (this.m20() * this.m32() - this.m22() * this.m30()) + (this.m02() * this.m13() - this.m03() * this.m12()) * (this.m20() * this.m31() - this.m21() * this.m30());
    }

    public final Matrix4f transpose(Matrix4f mat) {
        super.transpose(mat);
        return this;
    }

    public final Matrix4f negate(Matrix4f m1) {
        this.set(m1);
        this.negate();
        return this;
    }

    public Matrix4f invert() {
        float d = this.determinant();
        if (d == 0.0f) {
            return this;
        }
        d = 1.0f / d;
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        this.set(this.values[5] * (this.values[10] * this.values[15] - this.values[11] * this.values[14]) + this.values[6] * (this.values[11] * this.values[13] - this.values[9] * this.values[15]) + this.values[7] * (this.values[9] * this.values[14] - this.values[10] * this.values[13]), this.values[9] * (this.values[2] * this.values[15] - this.values[3] * this.values[14]) + this.values[10] * (this.values[3] * this.values[13] - this.values[1] * this.values[15]) + this.values[11] * (this.values[1] * this.values[14] - this.values[2] * this.values[13]), this.values[13] * (this.values[2] * this.values[7] - this.values[3] * this.values[6]) + this.values[14] * (this.values[3] * this.values[5] - this.values[1] * this.values[7]) + this.values[15] * (this.values[1] * this.values[6] - this.values[2] * this.values[5]), this.values[1] * (this.values[7] * this.values[10] - this.values[6] * this.values[11]) + this.values[2] * (this.values[5] * this.values[11] - this.values[7] * this.values[9]) + this.values[3] * (this.values[6] * this.values[9] - this.values[5] * this.values[10]), this.values[6] * (this.values[8] * this.values[15] - this.values[11] * this.values[12]) + this.values[7] * (this.values[10] * this.values[12] - this.values[8] * this.values[14]) + this.values[4] * (this.values[11] * this.values[14] - this.values[10] * this.values[15]), this.values[10] * (this.values[0] * this.values[15] - this.values[3] * this.values[12]) + this.values[11] * (this.values[2] * this.values[12] - this.values[0] * this.values[14]) + this.values[8] * (this.values[3] * this.values[14] - this.values[2] * this.values[15]), this.values[14] * (this.values[0] * this.values[7] - this.values[3] * this.values[4]) + this.values[15] * (this.values[2] * this.values[4] - this.values[0] * this.values[6]) + this.values[12] * (this.values[3] * this.values[6] - this.values[2] * this.values[7]), this.values[2] * (this.values[7] * this.values[8] - this.values[4] * this.values[11]) + this.values[3] * (this.values[4] * this.values[10] - this.values[6] * this.values[8]) + this.values[0] * (this.values[6] * this.values[11] - this.values[7] * this.values[10]), this.values[7] * (this.values[8] * this.values[13] - this.values[9] * this.values[12]) + this.values[4] * (this.values[9] * this.values[15] - this.values[11] * this.values[13]) + this.values[5] * (this.values[11] * this.values[12] - this.values[8] * this.values[15]), this.values[11] * (this.values[0] * this.values[13] - this.values[1] * this.values[12]) + this.values[8] * (this.values[1] * this.values[15] - this.values[3] * this.values[13]) + this.values[9] * (this.values[3] * this.values[12] - this.values[0] * this.values[15]), this.values[15] * (this.values[0] * this.values[5] - this.values[1] * this.values[4]) + this.values[12] * (this.values[1] * this.values[7] - this.values[3] * this.values[5]) + this.values[13] * (this.values[3] * this.values[4] - this.values[0] * this.values[7]), this.values[3] * (this.values[5] * this.values[8] - this.values[4] * this.values[9]) + this.values[0] * (this.values[7] * this.values[9] - this.values[5] * this.values[11]) + this.values[1] * (this.values[4] * this.values[11] - this.values[7] * this.values[8]), this.values[4] * (this.values[10] * this.values[13] - this.values[9] * this.values[14]) + this.values[5] * (this.values[8] * this.values[14] - this.values[10] * this.values[12]) + this.values[6] * (this.values[9] * this.values[12] - this.values[8] * this.values[13]), this.values[8] * (this.values[2] * this.values[13] - this.values[1] * this.values[14]) + this.values[9] * (this.values[0] * this.values[14] - this.values[2] * this.values[12]) + this.values[10] * (this.values[1] * this.values[12] - this.values[0] * this.values[13]), this.values[12] * (this.values[2] * this.values[5] - this.values[1] * this.values[6]) + this.values[13] * (this.values[0] * this.values[6] - this.values[2] * this.values[4]) + this.values[14] * (this.values[1] * this.values[4] - this.values[0] * this.values[5]), this.values[0] * (this.values[5] * this.values[10] - this.values[6] * this.values[9]) + this.values[1] * (this.values[6] * this.values[8] - this.values[4] * this.values[10]) + this.values[2] * (this.values[4] * this.values[9] - this.values[5] * this.values[8]));
        this.mul(d);
        return this;
    }

    public final Matrix4f invert(Matrix4f mat) {
        this.set(mat);
        this.invert();
        return this;
    }

    public final Matrix4f add(float scalar, Matrix4f mat) {
        this.set(mat);
        this.add(scalar);
        return this;
    }

    public final Matrix4f add(Matrix4f mat1, Matrix4f mat2) {
        this.set(mat1);
        this.add(mat2);
        return this;
    }

    public final Matrix4f add(Matrix4f mat2) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.set(i, j, this.get(i, j) + mat2.get(i, j));
                ++j;
            }
            ++i;
        }
        return this;
    }

    public final Matrix4f sub(Matrix4f mat2) {
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                this.set(i, j, this.get(i, j) - mat2.get(i, j));
                ++j;
            }
            ++i;
        }
        return this;
    }

    public final Matrix4f sub(Matrix4f mat1, Matrix4f mat2) {
        this.set(mat1);
        this.sub(mat2);
        return this;
    }

    public final Matrix4f rotX(float angle) {
        float c = FastMath.cos(angle);
        float s = FastMath.sin(angle);
        this.m00(1.0f);
        this.m01(0.0f);
        this.m02(0.0f);
        this.m10(0.0f);
        this.m11(c);
        this.m12(-s);
        this.m20(0.0f);
        this.m21(s);
        this.m22(c);
        this.m30(0.0f);
        this.m31(0.0f);
        this.m32(0.0f);
        this.m33(1.0f);
        return this;
    }

    public final Matrix4f rotY(float angle) {
        float c = FastMath.cos(angle);
        float s = FastMath.sin(angle);
        this.m00(c);
        this.m01(0.0f);
        this.m02(s);
        this.m10(0.0f);
        this.m11(1.0f);
        this.m12(0.0f);
        this.m20(-s);
        this.m21(0.0f);
        this.m22(c);
        this.m30(0.0f);
        this.m31(0.0f);
        this.m32(0.0f);
        this.m33(1.0f);
        return this;
    }

    public final Matrix4f rotZ(float angle) {
        float c = FastMath.cos(angle);
        float s = FastMath.sin(angle);
        this.m00(c);
        this.m01(-s);
        this.m02(0.0f);
        this.m10(s);
        this.m11(c);
        this.m12(0.0f);
        this.m20(0.0f);
        this.m21(0.0f);
        this.m22(1.0f);
        this.m30(0.0f);
        this.m31(0.0f);
        this.m32(0.0f);
        this.m33(1.0f);
        return this;
    }

    public Matrix4f mul(float scalar) {
        this.values[0] = this.values[0] * scalar;
        this.values[1] = this.values[1] * scalar;
        this.values[2] = this.values[2] * scalar;
        this.values[3] = this.values[3] * scalar;
        this.values[4] = this.values[4] * scalar;
        this.values[5] = this.values[5] * scalar;
        this.values[6] = this.values[6] * scalar;
        this.values[7] = this.values[7] * scalar;
        this.values[8] = this.values[8] * scalar;
        this.values[9] = this.values[9] * scalar;
        this.values[10] = this.values[10] * scalar;
        this.values[11] = this.values[11] * scalar;
        this.values[12] = this.values[12] * scalar;
        this.values[13] = this.values[13] * scalar;
        this.values[14] = this.values[14] * scalar;
        this.values[15] = this.values[15] * scalar;
        this.isDirty[0] = true;
        return this;
    }

    public final Matrix4f mul(float scalar, Matrix4f mat) {
        this.set(mat);
        this.mul(scalar);
        return this;
    }

    public final Matrix4f mul(Matrix4f mat) {
        this.mul(this, mat);
        return this;
    }

    public Matrix4f mul(Matrix4f mat1, Matrix4f mat2) {
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        if (!mat1.isSubMatrix() && !mat1.isSubMatrix()) {
            this.set(mat1.values[0] * mat2.values[0] + mat1.values[1] * mat2.values[4] + mat1.values[2] * mat2.values[8] + mat1.values[3] * mat2.values[12], mat1.values[0] * mat2.values[1] + mat1.values[1] * mat2.values[5] + mat1.values[2] * mat2.values[9] + mat1.values[3] * mat2.values[13], mat1.values[0] * mat2.values[2] + mat1.values[1] * mat2.values[6] + mat1.values[2] * mat2.values[10] + mat1.values[3] * mat2.values[14], mat1.values[0] * mat2.values[3] + mat1.values[1] * mat2.values[7] + mat1.values[2] * mat2.values[11] + mat1.values[3] * mat2.values[15], mat1.values[4] * mat2.values[0] + mat1.values[5] * mat2.values[4] + mat1.values[6] * mat2.values[8] + mat1.values[7] * mat2.values[12], mat1.values[4] * mat2.values[1] + mat1.values[5] * mat2.values[5] + mat1.values[6] * mat2.values[9] + mat1.values[7] * mat2.values[13], mat1.values[4] * mat2.values[2] + mat1.values[5] * mat2.values[6] + mat1.values[6] * mat2.values[10] + mat1.values[7] * mat2.values[14], mat1.values[4] * mat2.values[3] + mat1.values[5] * mat2.values[7] + mat1.values[6] * mat2.values[11] + mat1.values[7] * mat2.values[15], mat1.values[8] * mat2.values[0] + mat1.values[9] * mat2.values[4] + mat1.values[10] * mat2.values[8] + mat1.values[11] * mat2.values[12], mat1.values[8] * mat2.values[1] + mat1.values[9] * mat2.values[5] + mat1.values[10] * mat2.values[9] + mat1.values[11] * mat2.values[13], mat1.values[8] * mat2.values[2] + mat1.values[9] * mat2.values[6] + mat1.values[10] * mat2.values[10] + mat1.values[11] * mat2.values[14], mat1.values[8] * mat2.values[3] + mat1.values[9] * mat2.values[7] + mat1.values[10] * mat2.values[11] + mat1.values[11] * mat2.values[15], mat1.values[12] * mat2.values[0] + mat1.values[13] * mat2.values[4] + mat1.values[14] * mat2.values[8] + mat1.values[15] * mat2.values[12], mat1.values[12] * mat2.values[1] + mat1.values[13] * mat2.values[5] + mat1.values[14] * mat2.values[9] + mat1.values[15] * mat2.values[13], mat1.values[12] * mat2.values[2] + mat1.values[13] * mat2.values[6] + mat1.values[14] * mat2.values[10] + mat1.values[15] * mat2.values[14], mat1.values[12] * mat2.values[3] + mat1.values[13] * mat2.values[7] + mat1.values[14] * mat2.values[11] + mat1.values[15] * mat2.values[15]);
        }
        return this;
    }

    public final Matrix4f mulTransposeBoth(Matrix4f mat1, Matrix4f mat2) {
        this.mul(mat2, mat1);
        this.transpose();
        return this;
    }

    public final Matrix4f mulTransposeLeft(Matrix4f mat1, Matrix4f mat2) {
        this.set(mat1.get(0, 0) * mat2.get(0, 0) + mat1.get(1, 0) * mat2.get(1, 0) + mat1.get(2, 0) * mat2.get(2, 0) + mat1.get(3, 0) * mat2.get(3, 0), mat1.get(0, 0) * mat2.get(0, 1) + mat1.get(1, 0) * mat2.get(1, 1) + mat1.get(2, 0) * mat2.get(2, 1) + mat1.get(3, 0) * mat2.get(3, 1), mat1.get(0, 0) * mat2.get(0, 2) + mat1.get(1, 0) * mat2.get(1, 2) + mat1.get(2, 0) * mat2.get(2, 2) + mat1.get(3, 0) * mat2.get(3, 2), mat1.get(0, 0) * mat2.get(0, 3) + mat1.get(1, 0) * mat2.get(1, 3) + mat1.get(2, 0) * mat2.get(2, 3) + mat1.get(3, 0) * mat2.get(3, 3), mat1.get(0, 1) * mat2.get(0, 0) + mat1.get(1, 1) * mat2.get(1, 0) + mat1.get(2, 1) * mat2.get(2, 0) + mat1.get(3, 1) * mat2.get(3, 0), mat1.get(0, 1) * mat2.get(0, 1) + mat1.get(1, 1) * mat2.get(1, 1) + mat1.get(2, 1) * mat2.get(2, 1) + mat1.get(3, 1) * mat2.get(3, 1), mat1.get(0, 1) * mat2.get(0, 2) + mat1.get(1, 1) * mat2.get(1, 2) + mat1.get(2, 1) * mat2.get(2, 2) + mat1.get(3, 1) * mat2.get(3, 2), mat1.get(0, 1) * mat2.get(0, 3) + mat1.get(1, 1) * mat2.get(1, 3) + mat1.get(2, 1) * mat2.get(2, 3) + mat1.get(3, 1) * mat2.get(3, 3), mat1.get(0, 2) * mat2.get(0, 0) + mat1.get(1, 2) * mat2.get(1, 0) + mat1.get(2, 2) * mat2.get(2, 0) + mat1.get(3, 2) * mat2.get(3, 0), mat1.get(0, 2) * mat2.get(0, 1) + mat1.get(1, 2) * mat2.get(1, 1) + mat1.get(2, 2) * mat2.get(2, 1) + mat1.get(3, 2) * mat2.get(3, 1), mat1.get(0, 2) * mat2.get(0, 2) + mat1.get(1, 2) * mat2.get(1, 2) + mat1.get(2, 2) * mat2.get(2, 2) + mat1.get(3, 2) * mat2.get(3, 2), mat1.get(0, 2) * mat2.get(0, 3) + mat1.get(1, 2) * mat2.get(1, 3) + mat1.get(2, 2) * mat2.get(2, 3) + mat1.get(3, 2) * mat2.get(3, 3), mat1.get(0, 3) * mat2.get(0, 0) + mat1.get(1, 3) * mat2.get(1, 0) + mat1.get(2, 3) * mat2.get(2, 0) + mat1.get(3, 3) * mat2.get(3, 0), mat1.get(0, 3) * mat2.get(0, 1) + mat1.get(1, 3) * mat2.get(1, 1) + mat1.get(2, 3) * mat2.get(2, 1) + mat1.get(3, 3) * mat2.get(3, 1), mat1.get(0, 3) * mat2.get(0, 2) + mat1.get(1, 3) * mat2.get(1, 2) + mat1.get(2, 3) * mat2.get(2, 2) + mat1.get(3, 3) * mat2.get(3, 2), mat1.get(0, 3) * mat2.get(0, 3) + mat1.get(1, 3) * mat2.get(1, 3) + mat1.get(2, 3) * mat2.get(2, 3) + mat1.get(3, 3) * mat2.get(3, 3));
        return this;
    }

    public final Matrix4f mulTransposeRight(Matrix4f mat1, Matrix4f mat2) {
        this.set(mat1.get(0, 0) * mat2.get(0, 0) + mat1.get(0, 1) * mat2.get(0, 1) + mat1.get(0, 2) * mat2.get(0, 2) + mat1.get(0, 3) * mat2.get(0, 3), mat1.get(0, 0) * mat2.get(1, 0) + mat1.get(0, 1) * mat2.get(1, 1) + mat1.get(0, 2) * mat2.get(1, 2) + mat1.get(0, 3) * mat2.get(1, 3), mat1.get(0, 0) * mat2.get(2, 0) + mat1.get(0, 1) * mat2.get(2, 1) + mat1.get(0, 2) * mat2.get(2, 2) + mat1.get(0, 3) * mat2.get(2, 3), mat1.get(0, 0) * mat2.get(3, 0) + mat1.get(0, 1) * mat2.get(3, 1) + mat1.get(0, 2) * mat2.get(3, 2) + mat1.get(0, 3) * mat2.get(3, 3), mat1.get(1, 0) * mat2.get(0, 0) + mat1.get(1, 1) * mat2.get(0, 1) + mat1.get(1, 2) * mat2.get(0, 2) + mat1.get(1, 3) * mat2.get(0, 3), mat1.get(1, 0) * mat2.get(1, 0) + mat1.get(1, 1) * mat2.get(1, 1) + mat1.get(1, 2) * mat2.get(1, 2) + mat1.get(1, 3) * mat2.get(1, 3), mat1.get(1, 0) * mat2.get(2, 0) + mat1.get(1, 1) * mat2.get(2, 1) + mat1.get(1, 2) * mat2.get(2, 2) + mat1.get(1, 3) * mat2.get(2, 3), mat1.get(1, 0) * mat2.get(3, 0) + mat1.get(1, 1) * mat2.get(3, 1) + mat1.get(1, 2) * mat2.get(3, 2) + mat1.get(1, 3) * mat2.get(3, 3), mat1.get(2, 0) * mat2.get(0, 0) + mat1.get(2, 1) * mat2.get(0, 1) + mat1.get(2, 2) * mat2.get(0, 2) + mat1.get(2, 3) * mat2.get(0, 3), mat1.get(2, 0) * mat2.get(1, 0) + mat1.get(2, 1) * mat2.get(1, 1) + mat1.get(2, 2) * mat2.get(1, 2) + mat1.get(2, 3) * mat2.get(1, 3), mat1.get(2, 0) * mat2.get(2, 0) + mat1.get(2, 1) * mat2.get(2, 1) + mat1.get(2, 2) * mat2.get(2, 2) + mat1.get(2, 3) * mat2.get(2, 3), mat1.get(2, 0) * mat2.get(3, 0) + mat1.get(2, 1) * mat2.get(3, 1) + mat1.get(2, 2) * mat2.get(3, 2) + mat1.get(2, 3) * mat2.get(3, 3), mat1.get(3, 0) * mat2.get(0, 0) + mat1.get(3, 1) * mat2.get(0, 1) + mat1.get(3, 2) * mat2.get(0, 2) + mat1.get(3, 3) * mat2.get(0, 3), mat1.get(3, 0) * mat2.get(1, 0) + mat1.get(3, 1) * mat2.get(1, 1) + mat1.get(3, 2) * mat2.get(1, 2) + mat1.get(3, 3) * mat2.get(1, 3), mat1.get(3, 0) * mat2.get(2, 0) + mat1.get(3, 1) * mat2.get(2, 1) + mat1.get(3, 2) * mat2.get(2, 2) + mat1.get(3, 3) * mat2.get(2, 3), mat1.get(3, 0) * mat2.get(3, 0) + mat1.get(3, 1) * mat2.get(3, 1) + mat1.get(3, 2) * mat2.get(3, 2) + mat1.get(3, 3) * mat2.get(3, 3));
        return this;
    }

    public final void transform(Vector4f vec, Vector4f vecOut) {
        vecOut.set(this.m00() * vec.getX() + this.m01() * vec.getY() + this.m02() * vec.getZ() + this.m03() * vec.getW(), this.m10() * vec.getX() + this.m11() * vec.getY() + this.m12() * vec.getZ() + this.m13() * vec.getW(), this.m20() * vec.getX() + this.m21() * vec.getY() + this.m22() * vec.getZ() + this.m23() * vec.getW(), this.m30() * vec.getX() + this.m31() * vec.getY() + this.m32() * vec.getZ() + this.m33() * vec.getW());
    }

    public final void transform(Vector4f vec) {
        this.transform(vec, vec);
    }

    public final void transform(Point3f point, Point3f pointOut) {
        pointOut.set(this.m00() * point.getX() + this.m01() * point.getY() + this.m02() * point.getZ() + this.m03(), this.m10() * point.getX() + this.m11() * point.getY() + this.m12() * point.getZ() + this.m13(), this.m20() * point.getX() + this.m21() * point.getY() + this.m22() * point.getZ() + this.m23());
    }

    public final void transform(Point3f point) {
        this.transform(point, point);
    }

    public final void transform(Vector3f vec, Vector3f vecOut) {
        vecOut.set(this.m00() * vec.getX() + this.m01() * vec.getY() + this.m02() * vec.getZ(), this.m10() * vec.getX() + this.m11() * vec.getY() + this.m12() * vec.getZ(), this.m20() * vec.getX() + this.m21() * vec.getY() + this.m22() * vec.getZ());
    }

    public final void transform(Vector3f vec) {
        this.transform(vec, vec);
    }

    public final Matrix4f setRotation(Matrix3f mat) {
        float scale = this.SVD(null);
        this.setRotationScale(mat);
        this.mulRotationScale(scale);
        return this;
    }

    public final Matrix4f setRotation(Quaternion4f quat) {
        float scale = this.SVD(null, null);
        float tx = this.get(0, 3);
        float ty = this.get(1, 3);
        float tz = this.get(2, 3);
        float w0 = this.get(3, 0);
        float w1 = this.get(3, 1);
        float w2 = this.get(3, 2);
        float w3 = this.get(3, 3);
        this.set(quat);
        this.mulRotationScale(scale);
        this.set(0, 3, tx);
        this.set(1, 3, ty);
        this.set(2, 3, tz);
        this.set(3, 0, w0);
        this.set(3, 1, w1);
        this.set(3, 2, w2);
        this.set(3, 3, w3);
        return this;
    }

    public final Matrix4f setRotation(AxisAngle3f aa) {
        float scale = this.SVD(null, null);
        float tx = this.get(0, 3);
        float ty = this.get(1, 3);
        float tz = this.get(2, 3);
        float w0 = this.get(3, 0);
        float w1 = this.get(3, 1);
        float w2 = this.get(3, 2);
        float w3 = this.get(3, 3);
        this.set(aa);
        this.mulRotationScale(scale);
        this.set(0, 3, tx);
        this.set(1, 3, ty);
        this.set(2, 3, tz);
        this.set(3, 0, w0);
        this.set(3, 1, w1);
        this.set(3, 2, w2);
        this.set(3, 3, w3);
        return this;
    }

    public final Matrix4f setRotation(Tuple3f tup) {
        float cx = FastMath.cos(tup.getX());
        float sx = FastMath.sin(tup.getX());
        float cy = FastMath.cos(tup.getY());
        float sy = FastMath.sin(tup.getY());
        float cz = FastMath.cos(tup.getZ());
        float sz = FastMath.sin(tup.getZ());
        this.m00(cy * cz);
        this.m01(cy * sz);
        this.m02(-sy);
        this.m10(sx * sy * cz - cx * sz);
        this.m11(sx * sy * sz + cx * cz);
        this.m12(sx * cy);
        this.m20(cx * sy * cz + sx * sz);
        this.m21(cx * sy * sz - sx * cz);
        this.m22(cx * cy);
        this.m33(1.0f);
        return this;
    }

    public final Matrix4f setInvRotation(Tuple3f tup) {
        float cx = FastMath.cos(tup.getX());
        float sx = FastMath.sin(tup.getX());
        float cy = FastMath.cos(tup.getY());
        float sy = FastMath.sin(tup.getY());
        float cz = FastMath.cos(tup.getZ());
        float sz = FastMath.sin(tup.getZ());
        this.m00(cy * cz);
        this.m10(cy * sz);
        this.m20(-sy);
        this.m01(sx * sy * cz - cx * sz);
        this.m11(sx * sy * sz + cx * cz);
        this.m21(sx * cy);
        this.m02(cx * sy * cz + sx * sz);
        this.m12(cx * sy * sz - sx * cz);
        this.m22(cx * cy);
        return this;
    }

    public void interpolate(Matrix4f m1, Matrix4f m2, float alpha, boolean interpolateLastLine) {
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        this.values[0] = m1.values[0] + (m2.values[0] - m1.values[0]) * alpha;
        this.values[1] = m1.values[1] + (m2.values[1] - m1.values[1]) * alpha;
        this.values[2] = m1.values[2] + (m2.values[2] - m1.values[2]) * alpha;
        this.values[3] = m1.values[3] + (m2.values[3] - m1.values[3]) * alpha;
        this.values[4] = m1.values[4] + (m2.values[4] - m1.values[4]) * alpha;
        this.values[5] = m1.values[5] + (m2.values[5] - m1.values[5]) * alpha;
        this.values[6] = m1.values[6] + (m2.values[6] - m1.values[6]) * alpha;
        this.values[7] = m1.values[7] + (m2.values[7] - m1.values[7]) * alpha;
        this.values[8] = m1.values[8] + (m2.values[8] - m1.values[8]) * alpha;
        this.values[9] = m1.values[9] + (m2.values[9] - m1.values[9]) * alpha;
        this.values[10] = m1.values[10] + (m2.values[10] - m1.values[10]) * alpha;
        this.values[11] = m1.values[11] + (m2.values[11] - m1.values[11]) * alpha;
        if (interpolateLastLine) {
            this.values[12] = m1.values[12] + (m2.values[12] - m1.values[12]) * alpha;
            this.values[13] = m1.values[13] + (m2.values[13] - m1.values[13]) * alpha;
            this.values[14] = m1.values[14] + (m2.values[14] - m1.values[14]) * alpha;
            this.values[15] = m1.values[15] + (m2.values[15] - m1.values[15]) * alpha;
        }
        this.isDirty[0] = true;
    }

    public final void interpolate(Matrix4f m1, Matrix4f m2, float alpha) {
        this.interpolate(m1, m2, alpha, true);
    }

    public int hashCode() {
        return VecMathUtils.floatToIntBits(this.m00()) ^ VecMathUtils.floatToIntBits(this.m01()) ^ VecMathUtils.floatToIntBits(this.m02()) ^ VecMathUtils.floatToIntBits(this.m03()) ^ VecMathUtils.floatToIntBits(this.m10()) ^ VecMathUtils.floatToIntBits(this.m11()) ^ VecMathUtils.floatToIntBits(this.m12()) ^ VecMathUtils.floatToIntBits(this.m13()) ^ VecMathUtils.floatToIntBits(this.m20()) ^ VecMathUtils.floatToIntBits(this.m21()) ^ VecMathUtils.floatToIntBits(this.m22()) ^ VecMathUtils.floatToIntBits(this.m23()) ^ VecMathUtils.floatToIntBits(this.m30()) ^ VecMathUtils.floatToIntBits(this.m31()) ^ VecMathUtils.floatToIntBits(this.m32()) ^ VecMathUtils.floatToIntBits(this.m33());
    }

    public boolean equals(Matrix4f mat2) {
        return super.equals(mat2);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Matrix4f && this.equals((Matrix4f)o);
    }

    public boolean epsilonEquals(Matrix4f mat2, float epsilon) {
        return super.epsilonEquals(mat2, epsilon);
    }

    public Matrix4f clone() {
        return new Matrix4f(this);
    }

    private final float SVD(Matrix3f rot3, Matrix4f rot4) {
        float t;
        float s = FastMath.sqrt((this.get(0, 0) * this.get(0, 0) + this.get(1, 0) * this.get(1, 0) + this.get(2, 0) * this.get(2, 0) + this.get(0, 1) * this.get(0, 1) + this.get(1, 1) * this.get(1, 1) + this.get(2, 1) * this.get(2, 1) + this.get(0, 2) * this.get(0, 2) + this.get(1, 2) * this.get(1, 2) + this.get(2, 2) * this.get(2, 2)) / 3.0f);
        float f = t = s == 0.0f ? 0.0f : 1.0f / s;
        if (rot3 != null) {
            this.getRotationScale(rot3);
            rot3.mul(t);
        }
        if (rot4 != null) {
            if (rot4 != this) {
                rot4.setRotationScale(this);
            }
            rot4.mulRotationScale(t);
        }
        return s;
    }

    private final float SVD(Matrix3f rot) {
        float t;
        float s = FastMath.sqrt((this.get(0, 0) * this.get(0, 0) + this.get(1, 0) * this.get(1, 0) + this.get(2, 0) * this.get(2, 0) + this.get(0, 1) * this.get(0, 1) + this.get(1, 1) * this.get(1, 1) + this.get(2, 1) * this.get(2, 1) + this.get(0, 2) * this.get(0, 2) + this.get(1, 2) * this.get(1, 2) + this.get(2, 2) * this.get(2, 2)) / 3.0f);
        float f = t = s == 0.0f ? 0.0f : 1.0f / s;
        if (rot != null) {
            this.getRotationScale(rot);
            rot.mul(t);
        }
        return s;
    }

    private final void mulRotationScale(float scale) {
        this.set(0, 0, this.get(0, 0) * scale);
        this.set(0, 1, this.get(0, 1) * scale);
        this.set(0, 2, this.get(0, 2) * scale);
        this.set(1, 0, this.get(1, 0) * scale);
        this.set(1, 1, this.get(1, 1) * scale);
        this.set(1, 2, this.get(1, 2) * scale);
        this.set(2, 0, this.get(2, 0) * scale);
        this.set(2, 1, this.get(2, 1) * scale);
        this.set(2, 2, this.get(2, 2) * scale);
    }

    private final void setRotationScale(Matrix4f that) {
        this.set(0, 0, that.get(0, 0));
        this.set(0, 1, that.get(0, 1));
        this.set(0, 2, that.get(0, 2));
        this.set(1, 0, that.get(1, 0));
        this.set(1, 1, that.get(1, 1));
        this.set(1, 2, that.get(1, 2));
        this.set(2, 0, that.get(2, 0));
        this.set(2, 1, that.get(2, 1));
        this.set(2, 2, that.get(2, 2));
    }

    private final void setFromQuat(float a, float b, float c, float d) {
        float n = a * a + b * b + c * c + d * d;
        float s = n > 0.0f ? 2.0f / n : 0.0f;
        float xs = a * s;
        float ys = b * s;
        float zs = c * s;
        float wx = d * xs;
        float wy = d * ys;
        float wz = d * zs;
        float xx = a * xs;
        float xy = a * ys;
        float xz = a * zs;
        float yy = b * ys;
        float yz = b * zs;
        float zz = c * zs;
        this.setIdentity();
        this.set(0, 0, 1.0f - (yy + zz));
        this.set(0, 1, xy - wz);
        this.set(0, 2, xz + wy);
        this.set(1, 0, xy + wz);
        this.set(1, 1, 1.0f - (xx + zz));
        this.set(1, 2, yz - wx);
        this.set(2, 0, xz - wy);
        this.set(2, 1, yz + wx);
        this.set(2, 2, 1.0f - (xx + yy));
    }

    public Matrix4f asReadOnly() {
        return new Matrix4f(true, this.dataBegin, this.colSkip, this.values, this.isDirty);
    }

    public Matrix4f getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    private final void setFromAxisAngle(float x, float y, float z, float angle) {
        float n = 1.0f / FastMath.sqrt(x * x + y * y + z * z);
        x *= n;
        y *= n;
        z *= n;
        float c = FastMath.cos(angle);
        float s = FastMath.sin(angle);
        float omc = 1.0f - c;
        this.set(0, 0, c + x * x * omc);
        this.set(1, 1, c + y * y * omc);
        this.set(2, 2, c + z * z * omc);
        float tmp1 = x * y * omc;
        float tmp2 = z * s;
        this.set(0, 1, tmp1 - tmp2);
        this.set(1, 0, tmp1 + tmp2);
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.set(0, 2, tmp1 + tmp2);
        this.set(2, 0, tmp1 - tmp2);
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.set(1, 2, tmp1 - tmp2);
        this.set(2, 1, tmp1 + tmp2);
    }

    protected Matrix4f(boolean readOnly) {
        super(readOnly, 4, 4);
        Arrays.fill(this.values, 0.0f);
    }

    protected Matrix4f(boolean readOnly, float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        super(readOnly, 4, 4);
        this.values[0 * this.getNumCols() + 0] = m00;
        this.values[0 * this.getNumCols() + 1] = m01;
        this.values[0 * this.getNumCols() + 2] = m02;
        this.values[0 * this.getNumCols() + 3] = m03;
        this.values[1 * this.getNumCols() + 0] = m10;
        this.values[1 * this.getNumCols() + 1] = m11;
        this.values[1 * this.getNumCols() + 2] = m12;
        this.values[1 * this.getNumCols() + 3] = m13;
        this.values[2 * this.getNumCols() + 0] = m20;
        this.values[2 * this.getNumCols() + 1] = m21;
        this.values[2 * this.getNumCols() + 2] = m22;
        this.values[2 * this.getNumCols() + 3] = m23;
        this.values[3 * this.getNumCols() + 0] = m30;
        this.values[3 * this.getNumCols() + 1] = m31;
        this.values[3 * this.getNumCols() + 2] = m32;
        this.values[3 * this.getNumCols() + 3] = m33;
    }

    protected Matrix4f(boolean readOnly, float[] values) {
        super(readOnly, 4, 4);
        int size = this.getNumRows() * this.getNumCols();
        System.arraycopy(values, 0, this.values, 0, size);
    }

    protected Matrix4f(boolean readOnly, Quaternion4f rot, Tuple3f pos, float scale) {
        super(readOnly, 4, 4);
        this.setFromQuat(rot.getA(), rot.getB(), rot.getC(), rot.getD());
        int n = 0 * this.getNumCols() + 0;
        this.values[n] = this.values[n] * scale;
        int n2 = 0 * this.getNumCols() + 1;
        this.values[n2] = this.values[n2] * scale;
        int n3 = 0 * this.getNumCols() + 2;
        this.values[n3] = this.values[n3] * scale;
        int n4 = 1 * this.getNumCols() + 0;
        this.values[n4] = this.values[n4] * scale;
        int n5 = 1 * this.getNumCols() + 1;
        this.values[n5] = this.values[n5] * scale;
        int n6 = 1 * this.getNumCols() + 2;
        this.values[n6] = this.values[n6] * scale;
        int n7 = 2 * this.getNumCols() + 0;
        this.values[n7] = this.values[n7] * scale;
        int n8 = 2 * this.getNumCols() + 1;
        this.values[n8] = this.values[n8] * scale;
        int n9 = 2 * this.getNumCols() + 2;
        this.values[n9] = this.values[n9] * scale;
        this.values[0 * this.getNumCols() + 3] = pos.getX();
        this.values[1 * this.getNumCols() + 3] = pos.getY();
        this.values[2 * this.getNumCols() + 3] = pos.getZ();
    }

    protected Matrix4f(boolean readOnly, Tuple3f pos, Matrix3f rot, float scale) {
        super(readOnly, 4, 4);
        this.values[0] = rot.m00();
        this.values[1] = rot.m01();
        this.values[2] = rot.m02();
        this.values[this.getNumCols() + 0] = rot.m10();
        this.values[this.getNumCols() + 1] = rot.m11();
        this.values[this.getNumCols() + 2] = rot.m12();
        this.values[2 * this.getNumCols() + 0] = rot.m20();
        this.values[2 * this.getNumCols() + 1] = rot.m21();
        this.values[2 * this.getNumCols() + 2] = rot.m22();
        this.values[3 * this.getNumCols() + 0] = 0.0f;
        this.values[3 * this.getNumCols() + 1] = 0.0f;
        this.values[3 * this.getNumCols() + 2] = 0.0f;
        this.values[3 * this.getNumCols() + 3] = 1.0f;
        int n = 0 * this.getNumCols() + 0;
        this.values[n] = this.values[n] * scale;
        int n2 = 0 * this.getNumCols() + 1;
        this.values[n2] = this.values[n2] * scale;
        int n3 = 0 * this.getNumCols() + 2;
        this.values[n3] = this.values[n3] * scale;
        int n4 = 1 * this.getNumCols() + 0;
        this.values[n4] = this.values[n4] * scale;
        int n5 = 1 * this.getNumCols() + 1;
        this.values[n5] = this.values[n5] * scale;
        int n6 = 1 * this.getNumCols() + 2;
        this.values[n6] = this.values[n6] * scale;
        int n7 = 2 * this.getNumCols() + 0;
        this.values[n7] = this.values[n7] * scale;
        int n8 = 2 * this.getNumCols() + 1;
        this.values[n8] = this.values[n8] * scale;
        int n9 = 2 * this.getNumCols() + 2;
        this.values[n9] = this.values[n9] * scale;
        this.values[0 * this.getNumCols() + 3] = pos.getX();
        this.values[1 * this.getNumCols() + 3] = pos.getY();
        this.values[2 * this.getNumCols() + 3] = pos.getZ();
        this.values[3 * this.getNumCols() + 3] = 1.0f;
    }

    protected Matrix4f(boolean readOnly, Matrix4f mat) {
        this(readOnly, mat.m00(), mat.m01(), mat.m02(), mat.m03(), mat.m10(), mat.m11(), mat.m12(), mat.m13(), mat.m20(), mat.m21(), mat.m22(), mat.m23(), mat.m30(), mat.m31(), mat.m32(), mat.m33());
    }

    protected Matrix4f(boolean readOnly, Matrix3f mat) {
        this(readOnly, mat.m00(), mat.m01(), mat.m02(), 0.0f, mat.m10(), mat.m11(), mat.m12(), 0.0f, mat.m20(), mat.m21(), mat.m22(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected Matrix4f(boolean readOnly, int dataBegin, int colSkip, float[] values, boolean[] isDirty) {
        super(readOnly, dataBegin, colSkip, 4, 4, values, isDirty);
    }

    public Matrix4f() {
        this(false);
    }

    public Matrix4f(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this(false, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }

    public Matrix4f(float[] values) {
        this(false, values);
    }

    public Matrix4f(Quaternion4f rot, Tuple3f pos, float scale) {
        this(false, rot, pos, scale);
    }

    public Matrix4f(Tuple3f pos, Matrix3f rot, float scale) {
        this(false, pos, rot, scale);
    }

    public Matrix4f(Matrix4f mat) {
        this(false, mat);
    }

    public Matrix4f(Matrix3f mat) {
        this(false, mat);
    }

    protected Matrix4f(int dataBegin, int colSkip, float[] values, boolean[] isDirty) {
        this(false, dataBegin, colSkip, values, isDirty);
    }

    public static Matrix4f newReadOnly() {
        return new Matrix4f(true);
    }

    public static Matrix4f newReadOnly(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        return new Matrix4f(true, m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33);
    }

    public static Matrix4f newReadOnly(float[] values) {
        return new Matrix4f(true, values);
    }

    public static Matrix4f newReadOnly(Quaternion4f rot, Tuple3f pos, float scale) {
        return new Matrix4f(true, rot, pos, scale);
    }

    public static Matrix4f newReadOnly(Tuple3f pos, Matrix3f rot, float scale) {
        return new Matrix4f(true, pos, rot, scale);
    }

    public static Matrix4f newReadOnly(Matrix4f mat) {
        return new Matrix4f(true, mat);
    }

    public static Matrix4f newReadOnly(Matrix3f mat) {
        return new Matrix4f(true, mat);
    }

    public static Matrix4f sharedSubMatrix4f(MatrixMxNf mat, int beginRow, int beginCol) {
        return new Matrix4f(beginRow, beginCol, mat.values, null);
    }

    public static Matrix4f fromPool() {
        return POOL.get().alloc();
    }

    public static void toPool(Matrix4f o) {
        POOL.get().free(o);
    }
}

