/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.nio.FloatBuffer;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;

class SubMatrix4f
extends Matrix4f {
    private static final long serialVersionUID = -9193368404497123017L;

    public void set(Matrix3f mat) {
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        this.values[this.roTrick + this.dataBegin + 0] = mat.values[0];
        this.values[this.roTrick + this.dataBegin + 1] = mat.values[1];
        this.values[this.roTrick + this.dataBegin + 2] = mat.values[2];
        this.values[this.roTrick + this.dataBegin + 3] = 0.0f;
        this.values[this.roTrick + this.dataBegin + this.colSkip + 0] = mat.values[3];
        this.values[this.roTrick + this.dataBegin + this.colSkip + 1] = mat.values[4];
        this.values[this.roTrick + this.dataBegin + this.colSkip + 2] = mat.values[5];
        this.values[this.roTrick + this.dataBegin + this.colSkip + 3] = 0.0f;
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 0] = mat.values[6];
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 1] = mat.values[7];
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 2] = mat.values[8];
        this.values[this.roTrick + this.dataBegin + 2 * this.colSkip + 3] = 0.0f;
        this.values[this.roTrick + this.dataBegin + 3 * this.colSkip + 0] = 0.0f;
        this.values[this.roTrick + this.dataBegin + 3 * this.colSkip + 1] = 0.0f;
        this.values[this.roTrick + this.dataBegin + 3 * this.colSkip + 2] = 0.0f;
        this.values[this.roTrick + this.dataBegin + 3 * this.colSkip + 3] = 1.0f;
        this.isDirty[0] = true;
    }

    public FloatBuffer writeToBuffer(FloatBuffer buffer, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.put(this.m00());
        buffer.put(this.m10());
        buffer.put(this.m20());
        buffer.put(this.m30());
        buffer.put(this.m01());
        buffer.put(this.m11());
        buffer.put(this.m21());
        buffer.put(this.m31());
        buffer.put(this.m02());
        buffer.put(this.m12());
        buffer.put(this.m22());
        buffer.put(this.m32());
        buffer.put(this.m03());
        buffer.put(this.m13());
        buffer.put(this.m23());
        buffer.put(this.m33());
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public FloatBuffer writeToBuffer(FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        buffer.put(this.m00());
        buffer.put(this.m10());
        buffer.put(this.m20());
        buffer.put(this.m30());
        buffer.put(this.m01());
        buffer.put(this.m11());
        buffer.put(this.m21());
        buffer.put(this.m31());
        buffer.put(this.m02());
        buffer.put(this.m12());
        buffer.put(this.m22());
        buffer.put(this.m32());
        buffer.put(this.m03());
        buffer.put(this.m13());
        buffer.put(this.m23());
        buffer.put(this.m33());
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public FloatBuffer readFromBuffer(FloatBuffer buffer) {
        this.m00(buffer.get());
        this.m10(buffer.get());
        this.m20(buffer.get());
        this.m30(buffer.get());
        this.m01(buffer.get());
        this.m11(buffer.get());
        this.m21(buffer.get());
        this.m31(buffer.get());
        this.m02(buffer.get());
        this.m12(buffer.get());
        this.m22(buffer.get());
        this.m32(buffer.get());
        this.m03(buffer.get());
        this.m13(buffer.get());
        this.m23(buffer.get());
        this.m33(buffer.get());
        return buffer;
    }

    public FloatBuffer readFromBuffer(FloatBuffer buffer, int position) {
        buffer.position(position);
        this.m00(buffer.get());
        this.m10(buffer.get());
        this.m20(buffer.get());
        this.m30(buffer.get());
        this.m01(buffer.get());
        this.m11(buffer.get());
        this.m21(buffer.get());
        this.m31(buffer.get());
        this.m02(buffer.get());
        this.m12(buffer.get());
        this.m22(buffer.get());
        this.m32(buffer.get());
        this.m03(buffer.get());
        this.m13(buffer.get());
        this.m23(buffer.get());
        this.m33(buffer.get());
        return buffer;
    }

    public SubMatrix4f mul(float scalar) {
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                int n = this.roTrick + this.dataBegin + r * this.colSkip + c;
                this.values[n] = this.values[n] * scalar;
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
        return this;
    }

    public void interpolate(Matrix4f m1, Matrix4f m2, float alpha, boolean interpolateLastLine) {
        int nr = interpolateLastLine ? this.getNumRows() : this.getNumRows() - 1;
        int r = 0;
        while (r < nr) {
            int c = 0;
            while (c < this.getNumCols()) {
                this.set(r, c, m1.get(r, c) + (m2.get(r, c) - m1.get(r, c)) * alpha);
                ++c;
            }
            ++r;
        }
        this.isDirty[0] = true;
    }

    public SubMatrix4f invert() {
        float d = this.determinant();
        if (d == 0.0f) {
            return this;
        }
        d = 1.0f / d;
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        this.set(this.get(1, 1) * (this.get(2, 2) * this.get(3, 3) - this.get(2, 3) * this.get(3, 2)) + this.get(1, 2) * (this.get(2, 3) * this.get(3, 1) - this.get(2, 1) * this.get(3, 3)) + this.get(1, 3) * (this.get(2, 1) * this.get(3, 2) - this.get(2, 2) * this.get(3, 1)), this.get(2, 1) * (this.get(0, 2) * this.get(3, 3) - this.get(0, 3) * this.get(3, 2)) + this.get(2, 2) * (this.get(0, 3) * this.get(3, 1) - this.get(0, 1) * this.get(3, 3)) + this.get(2, 3) * (this.get(0, 1) * this.get(3, 2) - this.get(0, 2) * this.get(3, 1)), this.get(3, 1) * (this.get(0, 2) * this.get(1, 3) - this.get(0, 3) * this.get(1, 2)) + this.get(3, 2) * (this.get(0, 3) * this.get(1, 1) - this.get(0, 1) * this.get(1, 3)) + this.get(3, 3) * (this.get(0, 1) * this.get(1, 2) - this.get(0, 2) * this.get(1, 1)), this.get(0, 1) * (this.get(1, 3) * this.get(2, 2) - this.get(1, 2) * this.get(2, 3)) + this.get(0, 2) * (this.get(1, 1) * this.get(2, 3) - this.get(1, 3) * this.get(2, 1)) + this.get(0, 3) * (this.get(1, 2) * this.get(2, 1) - this.get(1, 1) * this.get(2, 2)), this.get(1, 2) * (this.get(2, 0) * this.get(3, 3) - this.get(2, 3) * this.get(3, 0)) + this.get(1, 3) * (this.get(2, 2) * this.get(3, 0) - this.get(2, 0) * this.get(3, 2)) + this.get(1, 0) * (this.get(2, 3) * this.get(3, 2) - this.get(2, 2) * this.get(3, 3)), this.get(2, 2) * (this.get(0, 0) * this.get(3, 3) - this.get(0, 3) * this.get(3, 0)) + this.get(2, 3) * (this.get(0, 2) * this.get(3, 0) - this.get(0, 0) * this.get(3, 2)) + this.get(2, 0) * (this.get(0, 3) * this.get(3, 2) - this.get(0, 2) * this.get(3, 3)), this.get(3, 2) * (this.get(0, 0) * this.get(1, 3) - this.get(0, 3) * this.get(1, 0)) + this.get(3, 3) * (this.get(0, 2) * this.get(1, 0) - this.get(0, 0) * this.get(1, 2)) + this.get(3, 0) * (this.get(0, 3) * this.get(1, 2) - this.get(0, 2) * this.get(1, 3)), this.get(0, 2) * (this.get(1, 3) * this.get(2, 0) - this.get(1, 0) * this.get(2, 3)) + this.get(0, 3) * (this.get(1, 0) * this.get(2, 2) - this.get(1, 2) * this.get(2, 0)) + this.get(0, 0) * (this.get(1, 2) * this.get(2, 3) - this.get(1, 3) * this.get(2, 2)), this.get(1, 3) * (this.get(2, 0) * this.get(3, 1) - this.get(2, 1) * this.get(3, 0)) + this.get(1, 0) * (this.get(2, 1) * this.get(3, 3) - this.get(2, 3) * this.get(3, 1)) + this.get(1, 1) * (this.get(2, 3) * this.get(3, 0) - this.get(2, 0) * this.get(3, 3)), this.get(2, 3) * (this.get(0, 0) * this.get(3, 1) - this.get(0, 1) * this.get(3, 0)) + this.get(2, 0) * (this.get(0, 1) * this.get(3, 3) - this.get(0, 3) * this.get(3, 1)) + this.get(2, 1) * (this.get(0, 3) * this.get(3, 0) - this.get(0, 0) * this.get(3, 3)), this.get(3, 3) * (this.get(0, 0) * this.get(1, 1) - this.get(0, 1) * this.get(1, 0)) + this.get(3, 0) * (this.get(0, 1) * this.get(1, 3) - this.get(0, 3) * this.get(1, 1)) + this.get(3, 1) * (this.get(0, 3) * this.get(1, 0) - this.get(0, 0) * this.get(1, 3)), this.get(0, 3) * (this.get(1, 1) * this.get(2, 0) - this.get(1, 0) * this.get(2, 1)) + this.get(0, 0) * (this.get(1, 3) * this.get(2, 1) - this.get(1, 1) * this.get(2, 3)) + this.get(0, 1) * (this.get(1, 0) * this.get(2, 3) - this.get(1, 3) * this.get(2, 0)), this.get(1, 0) * (this.get(2, 2) * this.get(3, 1) - this.get(2, 1) * this.get(3, 2)) + this.get(1, 1) * (this.get(2, 0) * this.get(3, 2) - this.get(2, 2) * this.get(3, 0)) + this.get(1, 2) * (this.get(2, 1) * this.get(3, 0) - this.get(2, 0) * this.get(3, 1)), this.get(2, 0) * (this.get(0, 2) * this.get(3, 1) - this.get(0, 1) * this.get(3, 2)) + this.get(2, 1) * (this.get(0, 0) * this.get(3, 2) - this.get(0, 2) * this.get(3, 0)) + this.get(2, 2) * (this.get(0, 1) * this.get(3, 0) - this.get(0, 0) * this.get(3, 1)), this.get(3, 0) * (this.get(0, 2) * this.get(1, 1) - this.get(0, 1) * this.get(1, 2)) + this.get(3, 1) * (this.get(0, 0) * this.get(1, 2) - this.get(0, 2) * this.get(1, 0)) + this.get(3, 2) * (this.get(0, 1) * this.get(1, 0) - this.get(0, 0) * this.get(1, 1)), this.get(0, 0) * (this.get(1, 1) * this.get(2, 2) - this.get(1, 2) * this.get(2, 1)) + this.get(0, 1) * (this.get(1, 2) * this.get(2, 0) - this.get(1, 0) * this.get(2, 2)) + this.get(0, 2) * (this.get(1, 0) * this.get(2, 1) - this.get(1, 1) * this.get(2, 0)));
        this.mul(d);
        return this;
    }

    public SubMatrix4f mul(Matrix4f mat1, Matrix4f mat2) {
        if (this.isReadOnly()) {
            throw new Error("This is a read-only Matrix");
        }
        this.set(mat1.get(0, 0) * mat2.get(0, 0) + mat1.get(0, 1) * mat2.get(1, 0) + mat1.get(0, 2) * mat2.get(2, 0) + mat1.get(0, 3) * mat2.get(3, 0), mat1.get(0, 0) * mat2.get(0, 1) + mat1.get(0, 1) * mat2.get(1, 1) + mat1.get(0, 2) * mat2.get(2, 1) + mat1.get(0, 3) * mat2.get(3, 1), mat1.get(0, 0) * mat2.get(0, 2) + mat1.get(0, 1) * mat2.get(1, 2) + mat1.get(0, 2) * mat2.get(2, 2) + mat1.get(0, 3) * mat2.get(3, 2), mat1.get(0, 0) * mat2.get(0, 3) + mat1.get(0, 1) * mat2.get(1, 3) + mat1.get(0, 2) * mat2.get(2, 3) + mat1.get(0, 3) * mat2.get(3, 3), mat1.get(1, 0) * mat2.get(0, 0) + mat1.get(1, 1) * mat2.get(1, 0) + mat1.get(1, 2) * mat2.get(2, 0) + mat1.get(1, 3) * mat2.get(3, 0), mat1.get(1, 0) * mat2.get(0, 1) + mat1.get(1, 1) * mat2.get(1, 1) + mat1.get(1, 2) * mat2.get(2, 1) + mat1.get(1, 3) * mat2.get(3, 1), mat1.get(1, 0) * mat2.get(0, 2) + mat1.get(1, 1) * mat2.get(1, 2) + mat1.get(1, 2) * mat2.get(2, 2) + mat1.get(1, 3) * mat2.get(3, 2), mat1.get(1, 0) * mat2.get(0, 3) + mat1.get(1, 1) * mat2.get(1, 3) + mat1.get(1, 2) * mat2.get(2, 3) + mat1.get(1, 3) * mat2.get(3, 3), mat1.get(2, 0) * mat2.get(0, 0) + mat1.get(2, 1) * mat2.get(1, 0) + mat1.get(2, 2) * mat2.get(2, 0) + mat1.get(2, 3) * mat2.get(3, 0), mat1.get(2, 0) * mat2.get(0, 1) + mat1.get(2, 1) * mat2.get(1, 1) + mat1.get(2, 2) * mat2.get(2, 1) + mat1.get(2, 3) * mat2.get(3, 1), mat1.get(2, 0) * mat2.get(0, 2) + mat1.get(2, 1) * mat2.get(1, 2) + mat1.get(2, 2) * mat2.get(2, 2) + mat1.get(2, 3) * mat2.get(3, 2), mat1.get(2, 0) * mat2.get(0, 3) + mat1.get(2, 1) * mat2.get(1, 3) + mat1.get(2, 2) * mat2.get(2, 3) + mat1.get(2, 3) * mat2.get(3, 3), mat1.get(3, 0) * mat2.get(0, 0) + mat1.get(3, 1) * mat2.get(1, 0) + mat1.get(3, 2) * mat2.get(2, 0) + mat1.get(3, 3) * mat2.get(3, 0), mat1.get(3, 0) * mat2.get(0, 1) + mat1.get(3, 1) * mat2.get(1, 1) + mat1.get(3, 2) * mat2.get(2, 1) + mat1.get(3, 3) * mat2.get(3, 1), mat1.get(3, 0) * mat2.get(0, 2) + mat1.get(3, 1) * mat2.get(1, 2) + mat1.get(3, 2) * mat2.get(2, 2) + mat1.get(3, 3) * mat2.get(3, 2), mat1.get(3, 0) * mat2.get(0, 3) + mat1.get(3, 1) * mat2.get(1, 3) + mat1.get(3, 2) * mat2.get(2, 3) + mat1.get(3, 3) * mat2.get(3, 3));
        return this;
    }

    public SubMatrix4f(boolean readOnly, int dataBegin, int colSkip, float[] values) {
        super(readOnly, dataBegin, colSkip, values, null);
    }
}

