/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.openmali.vecmath2.util.SerializationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TexCoordf<T extends TexCoordf<T>> {
    protected final int N;
    protected final float[] values;
    protected final int roTrick;
    protected boolean isDirty = false;

    public final boolean isReadOnly() {
        return this.roTrick != 0;
    }

    public final boolean setClean() {
        boolean oldValue = this.isDirty;
        this.isDirty = false;
        return oldValue;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final int getSize() {
        return this.N;
    }

    public final T set(float[] values, int offset) {
        System.arraycopy(values, 0, this.values, this.roTrick + 0, this.N);
        this.isDirty = true;
        return (T)this;
    }

    public final T set(float[] values) {
        return this.set(values, 0);
    }

    public final T set(T texCoord) {
        System.arraycopy(((TexCoordf)texCoord).values, 0, this.values, this.roTrick + 0, this.N);
        this.isDirty = true;
        return (T)this;
    }

    public final void get(float[] buffer, int offset) {
        System.arraycopy(this.values, 0, buffer, offset, this.N);
        this.isDirty = true;
    }

    public final void get(float[] buffer) {
        this.get(buffer, 0);
    }

    public final void get(T buffer) {
        System.arraycopy(this.values, 0, ((TexCoordf)buffer).values, 0, Math.min(this.N, ((TexCoordf)buffer).N));
        this.isDirty = true;
    }

    public final FloatBuffer writeToBuffer(FloatBuffer buffer, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.put(this.values);
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public final FloatBuffer writeToBuffer(FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        buffer.put(this.values);
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public static final FloatBuffer writeToBuffer(TexCoordf<?>[] texCoords, FloatBuffer buffer, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        int i = 0;
        while (i < texCoords.length) {
            texCoords[i].writeToBuffer(buffer, false, false);
            ++i;
        }
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public static final FloatBuffer writeToBuffer(TexCoordf<?>[] texCoords, FloatBuffer buffer, int position, boolean clear, boolean flip) {
        if (clear) {
            buffer.clear();
        }
        buffer.position(position);
        int i = 0;
        while (i < texCoords.length) {
            texCoords[i].writeToBuffer(buffer, false, false);
            ++i;
        }
        if (flip) {
            buffer.flip();
        }
        return buffer;
    }

    public final FloatBuffer readFromBuffer(FloatBuffer buffer) {
        buffer.get(this.values);
        return buffer;
    }

    public final FloatBuffer readFromBuffer(FloatBuffer buffer, int position) {
        buffer.position(position);
        buffer.get(this.values);
        return buffer;
    }

    public static final FloatBuffer readFromBuffer(TexCoordf<?>[] texCoords, FloatBuffer buffer) {
        int i = 0;
        while (i < texCoords.length) {
            texCoords[i].readFromBuffer(buffer);
            ++i;
        }
        return buffer;
    }

    public static final FloatBuffer readFromBuffer(TexCoordf<?>[] texCoords, FloatBuffer buffer, int position) {
        buffer.position(position);
        int i = 0;
        while (i < texCoords.length) {
            texCoords[i].readFromBuffer(buffer);
            ++i;
        }
        return buffer;
    }

    public final T setZero() {
        int i = 0;
        while (i < this.N) {
            this.values[this.roTrick + i] = 0.0f;
            ++i;
        }
        this.isDirty = true;
        return (T)this;
    }

    public final T add(T texCoord1, T texCoord2) {
        int i = 0;
        while (i < this.N) {
            this.values[this.roTrick + i] = ((TexCoordf)texCoord1).values[i] + ((TexCoordf)texCoord2).values[i];
            ++i;
        }
        this.isDirty = true;
        return (T)this;
    }

    public final T add(T texCoord2) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] + ((TexCoordf)texCoord2).values[i];
            ++i;
        }
        this.isDirty = true;
        return (T)this;
    }

    public final T sub(T texCoord1, T texCoord2) {
        int i = 0;
        while (i < this.N) {
            this.values[this.roTrick + i] = ((TexCoordf)texCoord1).values[i] - ((TexCoordf)texCoord2).values[i];
            ++i;
        }
        this.isDirty = true;
        return (T)this;
    }

    public final T sub(T texCoord2) {
        int i = 0;
        while (i < this.N) {
            int n = this.roTrick + i;
            this.values[n] = this.values[n] - ((TexCoordf)texCoord2).values[i];
            ++i;
        }
        this.isDirty = true;
        return (T)this;
    }

    public final T scaleAdd(float factor, T texCoord1, T texCoord2) {
        int i = 0;
        while (i < this.N) {
            this.values[this.roTrick + i] = factor * ((TexCoordf)texCoord1).values[i] + ((TexCoordf)texCoord2).values[i];
            ++i;
        }
        this.isDirty = true;
        return (T)this;
    }

    public final T scaleAdd(float factor, T texCoord2) {
        int i = 0;
        while (i < this.N) {
            this.values[this.roTrick + i] = factor * this.values[i] + ((TexCoordf)texCoord2).values[i];
            ++i;
        }
        this.isDirty = true;
        return (T)this;
    }

    public final T clampMin(float min) {
        int i = 0;
        while (i < this.N) {
            if (this.values[i] < min) {
                this.values[this.roTrick + i] = min;
            }
            ++i;
        }
        this.isDirty = true;
        return (T)this;
    }

    public final T clampMax(float max) {
        int i = 0;
        while (i < this.N) {
            if (this.values[i] > max) {
                this.values[this.roTrick + i] = max;
            }
            ++i;
        }
        this.isDirty = true;
        return (T)this;
    }

    public final T clamp(float min, float max) {
        this.clampMin(min);
        this.clampMax(max);
        return (T)this;
    }

    public final T clamp(float min, float max, T vec) {
        this.set(vec);
        this.clamp(min, max);
        return (T)this;
    }

    public final T clampMin(float min, T vec) {
        this.set(vec);
        this.clampMin(min);
        return (T)this;
    }

    public final T clampMax(float max, T vec) {
        this.set(vec);
        this.clampMax(max);
        return (T)this;
    }

    public final void interpolate(T texCoord2, float alpha) {
        float beta = 1.0f - alpha;
        int i = 0;
        while (i < this.N) {
            this.values[this.roTrick + i] = beta * this.values[i] + alpha * ((TexCoordf)texCoord2).values[i];
            ++i;
        }
        this.isDirty = true;
    }

    public final void interpolate(T texCoord1, T texCoord2, float alpha) {
        float beta = 1.0f - alpha;
        int i = 0;
        while (i < this.N) {
            this.values[this.roTrick + i] = beta * ((TexCoordf)texCoord1).values[i] + alpha * ((TexCoordf)texCoord2).values[i];
            ++i;
        }
        this.isDirty = true;
    }

    private static int floatToIntBits(float f) {
        return f == 0.0f ? 0 : Float.floatToIntBits(f);
    }

    public int hashCode() {
        int bits = 0;
        int i = 0;
        while (i < this.N) {
            bits ^= TexCoordf.floatToIntBits(this.values[i]);
            ++i;
        }
        return bits;
    }

    public boolean equals(TexCoordf<?> texCoord2) {
        if (this.N != texCoord2.N) {
            return false;
        }
        int i = 0;
        while (i < this.N) {
            if (texCoord2.values[i] != this.values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof TexCoordf && this.equals((TexCoordf)o);
    }

    public boolean epsilonEquals(T texCoord2, float epsilon) {
        if (this.N != ((TexCoordf)texCoord2).N) {
            return false;
        }
        int i = 0;
        while (i < this.N) {
            if (Math.abs(((TexCoordf)texCoord2).values[i] - this.values[i]) > epsilon) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String str = "TexCoord ( ";
        if (this.N >= 1) {
            str = String.valueOf(str) + "S = " + this.values[0];
        }
        if (this.N >= 2) {
            str = String.valueOf(str) + ", T = " + this.values[1];
        }
        if (this.N >= 3) {
            str = String.valueOf(str) + ", P = " + this.values[2];
        }
        if (this.N >= 4) {
            str = String.valueOf(str) + ", Q = " + this.values[3];
        }
        return String.valueOf(str) + " )";
    }

    protected static final float[] newArray(float[] template, int length) {
        float[] result = new float[length];
        System.arraycopy(template, 0, result, 0, Math.min(template.length, length));
        if (template.length < length) {
            Arrays.fill(result, template.length, length, 0.0f);
        }
        return result;
    }

    public int serialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.N) {
            SerializationUtils.writeToBuffer(this.values[i], pos, buffer);
            pos += 4;
            ++i;
        }
        SerializationUtils.writeToBuffer(this.isDirty, pos, buffer);
        return ++pos;
    }

    public int deserialize(int pos, byte[] buffer) {
        int i = 0;
        while (i < this.N) {
            this.values[i] = SerializationUtils.readFloatFromBuffer(pos, buffer);
            pos += 4;
            ++i;
        }
        this.isDirty = SerializationUtils.readBoolFromBuffer(pos, buffer);
        return ++pos;
    }

    protected int getSerializationBufferSize() {
        return 4 * this.N + 1;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        this.serialize(0, buffer);
        out.write(buffer);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = new byte[this.getSerializationBufferSize()];
        in.read(buffer);
        this.deserialize(0, buffer);
    }

    public TexCoordf(boolean readOnly, float[] values) {
        this.values = values;
        this.N = values.length;
        this.roTrick = readOnly ? -2147483647 + values.length : 0;
    }

    public TexCoordf(float[] values) {
        this(false, values);
    }
}

