/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import java.io.Externalizable;
import org.openmali.vecmath2.TupleNd;
import org.openmali.vecmath2.pools.Tuple2dPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple2d
extends TupleNd<Tuple2d>
implements Externalizable {
    private static final long serialVersionUID = -1375260704936534068L;
    private static final ThreadLocal<Tuple2dPool> POOL = new ThreadLocal<Tuple2dPool>(){

        @Override
        protected Tuple2dPool initialValue() {
            return new Tuple2dPool(128);
        }
    };
    private Tuple2d readOnlyInstance = null;

    public final Tuple2d set(double x, double y) {
        this.setX(x);
        this.setY(y);
        return this;
    }

    public final Tuple2d setX(double x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple2d setY(double y) {
        this.setValue(1, y);
        return this;
    }

    public final double getX() {
        return this.getValue(0);
    }

    public final double getY() {
        return this.getValue(1);
    }

    public final Tuple2d x(double x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple2d y(double y) {
        this.setValue(1, y);
        return this;
    }

    public final double x() {
        return this.getValue(0);
    }

    public final double y() {
        return this.getValue(1);
    }

    public final Tuple2d addX(double v) {
        this.addValue(0, v);
        return this;
    }

    public final Tuple2d addY(double v) {
        this.addValue(1, v);
        return this;
    }

    @Override
    public final Tuple2d add(double x, double y) {
        this.addValue(0, x);
        this.addValue(1, y);
        return this;
    }

    public final Tuple2d subX(double v) {
        this.subValue(0, v);
        return this;
    }

    public final Tuple2d subY(double v) {
        this.subValue(1, v);
        return this;
    }

    @Override
    public final Tuple2d sub(double x, double y) {
        this.subValue(0, x);
        this.subValue(1, y);
        return this;
    }

    public final Tuple2d mulX(double v) {
        this.mulValue(0, v);
        return this;
    }

    public final Tuple2d mulY(double v) {
        this.mulValue(1, v);
        return this;
    }

    public final Tuple2d mul(double vx, double vy) {
        this.mulValue(0, vx);
        this.mulValue(1, vy);
        return this;
    }

    public final Tuple2d divX(double v) {
        this.divValue(0, v);
        return this;
    }

    public final Tuple2d divY(double v) {
        this.divValue(1, v);
        return this;
    }

    public final Tuple2d div(double vx, double vy) {
        this.divValue(0, vx);
        this.divValue(1, vy);
        return this;
    }

    @Override
    public final Tuple2d scale(double factorX, double factorY) {
        this.mul(factorX, factorY);
        return this;
    }

    @Override
    public Tuple2d asReadOnly() {
        return new Tuple2d(true, this.values, this.isDirty, false);
    }

    @Override
    public Tuple2d getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    @Override
    public boolean equals(Object tuple2) {
        return tuple2 != null && tuple2 instanceof Tuple2d && ((TupleNd)this).equals((Tuple2d)tuple2);
    }

    public Tuple2d clone() {
        try {
            return (Tuple2d)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    protected Tuple2d(boolean readOnly, double x, double y) {
        super(readOnly, 2);
        this.values[0] = x;
        this.values[1] = y;
    }

    protected Tuple2d(boolean readOnly, double[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, 2, copy);
    }

    protected Tuple2d(boolean readOnly, Tuple2d that) {
        super(readOnly, that);
    }

    protected Tuple2d(boolean readOnly) {
        this(readOnly, 0.0, 0.0);
    }

    public Tuple2d(double x, double y) {
        this(false, x, y);
    }

    public Tuple2d(double[] values) {
        this(false, values, null, true);
    }

    public Tuple2d(Tuple2d that) {
        this(false, that);
    }

    public Tuple2d() {
        this(false, 0.0, 0.0);
    }

    public static Tuple2d newReadOnly(double x, double y) {
        return new Tuple2d(true, x, y);
    }

    public static Tuple2d newReadOnly(double[] values) {
        return new Tuple2d(true, values, null, true);
    }

    public static Tuple2d newReadOnly(Tuple2d tuple) {
        return new Tuple2d(true, tuple);
    }

    public static Tuple2d newReadOnly() {
        return new Tuple2d(true);
    }

    public static Tuple2d fromPool() {
        return POOL.get().alloc();
    }

    public static Tuple2d fromPool(double x, double y) {
        return POOL.get().alloc(x, y);
    }

    public static Tuple2d fromPool(Tuple2d tuple) {
        return Tuple2d.fromPool(tuple.getX(), tuple.getY());
    }

    public static void toPool(Tuple2d o) {
        POOL.get().free(o);
    }
}

