/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import org.openmali.vecmath2.TupleNi;
import org.openmali.vecmath2.pools.Tuple3iPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuple3i
extends TupleNi<Tuple3i> {
    private static final long serialVersionUID = 586023996166921455L;
    private static final ThreadLocal<Tuple3iPool> POOL = new ThreadLocal<Tuple3iPool>(){

        @Override
        protected Tuple3iPool initialValue() {
            return new Tuple3iPool(128);
        }
    };
    private Tuple3i readOnlyInstance = null;

    public final Tuple3i setX(int x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple3i setY(int y) {
        this.setValue(1, y);
        return this;
    }

    public final Tuple3i setZ(int z) {
        this.setValue(2, z);
        return this;
    }

    public final int getX() {
        return this.getValue(0);
    }

    public final int getY() {
        return this.getValue(1);
    }

    public final int getZ() {
        return this.getValue(2);
    }

    public final Tuple3i x(int x) {
        this.setValue(0, x);
        return this;
    }

    public final Tuple3i y(int y) {
        this.setValue(1, y);
        return this;
    }

    public final Tuple3i z(int z) {
        this.setValue(2, z);
        return this;
    }

    public final int x() {
        return this.getValue(0);
    }

    public final int y() {
        return this.getValue(1);
    }

    public final int z() {
        return this.getValue(2);
    }

    public final Tuple3i set(int x, int y, int z) {
        this.setValue(0, x);
        this.setValue(1, y);
        this.setValue(2, z);
        return this;
    }

    public final Tuple3i addX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i addY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i addZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] + v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i add(int x, int y, int z) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] + x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] + y;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] + z;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i subX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i subY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i subZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] - v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i sub(int x, int y, int z) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] - x;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] - y;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] - z;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i mulX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i mulY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i mulZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] * v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i mul(int vx, int vy, int vz) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] * vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] * vy;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] * vz;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i divX(int v) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i divY(int v) {
        int n = this.roTrick + 1;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i divZ(int v) {
        int n = this.roTrick + 2;
        this.values[n] = this.values[n] / v;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i div(int vx, int vy, int vz) {
        int n = this.roTrick + 0;
        this.values[n] = this.values[n] / vx;
        int n2 = this.roTrick + 1;
        this.values[n2] = this.values[n2] / vy;
        int n3 = this.roTrick + 2;
        this.values[n3] = this.values[n3] / vz;
        this.isDirty[0] = true;
        return this;
    }

    public final Tuple3i scale(int factorX, int factorY, int factorZ) {
        this.mul(factorX, factorY, factorZ);
        return this;
    }

    @Override
    public Tuple3i asReadOnly() {
        return new Tuple3i(true, this.values, this.isDirty, false);
    }

    @Override
    public Tuple3i getReadOnly() {
        if (this.readOnlyInstance == null) {
            this.readOnlyInstance = this.asReadOnly();
        }
        return this.readOnlyInstance;
    }

    @Override
    public int hashCode() {
        return this.values[0] ^ this.values[1] ^ this.values[2];
    }

    @Override
    public boolean equals(Tuple3i tuple2) {
        int i = 0;
        while (i < this.N) {
            if (tuple2.getValue(i) != this.getValue(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean equals(Object tuple2) {
        return tuple2 != null && tuple2 instanceof Tuple3i && this.equals((Tuple3i)tuple2);
    }

    @Override
    public String toString() {
        return "(" + this.getValue(0) + ", " + this.getValue(1) + ", " + this.getValue(2) + ")";
    }

    public Tuple3i clone() {
        return new Tuple3i(this);
    }

    protected Tuple3i(boolean readOnly, int x, int y, int z) {
        super(readOnly, 3);
        this.values[0] = x;
        this.values[1] = y;
        this.values[2] = z;
    }

    protected Tuple3i(boolean readOnly, int[] values, boolean[] isDirty, boolean copy) {
        super(readOnly, values, isDirty, 3, copy);
    }

    protected Tuple3i(boolean readOnly, Tuple3i that) {
        super(readOnly, that);
    }

    protected Tuple3i(boolean readOnly) {
        this(readOnly, 0, 0, 0);
    }

    public Tuple3i(int x, int y, int z) {
        this(false, x, y, z);
    }

    public Tuple3i(int[] values) {
        this(false, values, null, true);
    }

    public Tuple3i(Tuple3i that) {
        this(false, that);
    }

    public Tuple3i() {
        this(false, 0, 0, 0);
    }

    public static Tuple3i newReadOnly(int x, int y, int z) {
        return new Tuple3i(true, x, y, z);
    }

    public static Tuple3i newReadOnly(int[] values) {
        return new Tuple3i(true, values, null, true);
    }

    public static Tuple3i newReadOnly(Tuple3i tuple) {
        return new Tuple3i(true, tuple);
    }

    public static Tuple3i newReadOnly() {
        return new Tuple3i(true);
    }

    public static Tuple3i fromPool() {
        return POOL.get().alloc();
    }

    public static Tuple3i fromPool(int x, int y, int z) {
        return POOL.get().alloc(x, y, z);
    }

    public static Tuple3i fromPool(Tuple3i tuple) {
        return Tuple3i.fromPool(tuple.getX(), tuple.getY(), tuple.getZ());
    }

    public static void toPool(Tuple3i o) {
        POOL.get().free(o);
    }
}

