/*
 * Decompiled with CFR 0.152.
 */
package org.openmali.vecmath2;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.TexCoord4f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;

public class Vertex3f {
    public static final int COORDINATES = 1;
    public static final int NORMALS = 2;
    public static final int COLORS = 4;
    public static final int TEXTURE_COORDINATES = 8;
    public static final int VERTEX_ATTRIBUTES = 16;
    private int features;
    private int texCoordSize = 0;
    private Point3f coord = null;
    private Vector3f normal = null;
    private Colorf color = null;
    private TexCoord2f texCoord2 = null;
    private TexCoord3f texCoord3 = null;
    private TexCoord4f texCoord4 = null;

    public void setFeatures(int features) {
        this.features = features;
    }

    public int getFeatures() {
        return this.features;
    }

    public void addFeature(int feature) {
        this.features |= feature;
    }

    public boolean hasFeature(int feature) {
        return (this.features & feature) > 0;
    }

    public final int getTexCoordSize() {
        return this.texCoordSize;
    }

    public void setCoord(Tuple3f coord) {
        if (this.coord == null) {
            this.coord = new Point3f(coord);
        } else {
            this.coord.set((TupleNf)coord);
        }
        this.addFeature(1);
    }

    public void getCoord(Tuple3f coord) {
        coord.set((TupleNf)this.coord);
    }

    public Tuple3f getCoord() {
        return this.coord;
    }

    public void setNormal(Vector3f normal) {
        if (this.normal == null) {
            this.normal = new Vector3f(normal);
        } else {
            this.normal.set((TupleNf)normal);
        }
        this.addFeature(2);
    }

    public void getNormal(Vector3f normal) {
        normal.set((TupleNf)this.normal);
    }

    public Vector3f getNormal() {
        return this.normal;
    }

    public void setColor(Colorf color) {
        if (this.color == null) {
            this.color = new Colorf(color);
        } else {
            this.color.set(color);
        }
        this.addFeature(4);
    }

    public void getColor(Colorf color) {
        color.set(this.color);
    }

    public Colorf getColor() {
        return this.color;
    }

    public void setTexCoord2(TexCoord2f texCoord) {
        if (this.texCoord2 == null) {
            this.texCoord2 = new TexCoord2f(texCoord);
        } else {
            this.texCoord2.set(texCoord);
        }
        this.addFeature(8);
        this.texCoordSize = 2;
    }

    public void getTexCoord2(TexCoord2f texCoord) {
        texCoord.set(this.texCoord2);
    }

    public TexCoord2f getTexCoord2() {
        return this.texCoord2;
    }

    public void setTexCoord3(TexCoord3f texCoord) {
        if (this.texCoord3 == null) {
            this.texCoord3 = new TexCoord3f(texCoord);
        } else {
            this.texCoord3.set(texCoord);
        }
        this.addFeature(8);
        this.texCoordSize = 3;
    }

    public void getTexCoord3(TexCoord3f texCoord) {
        texCoord.set(this.texCoord3);
    }

    public TexCoord3f getTexCoord3() {
        return this.texCoord3;
    }

    public void setTexCoord4(TexCoord4f texCoord) {
        if (this.texCoord4 == null) {
            this.texCoord4 = new TexCoord4f(texCoord);
        } else {
            this.texCoord4.set(texCoord);
        }
        this.addFeature(8);
        this.texCoordSize = 4;
    }

    public void getTexCoord4(TexCoord4f texCoord) {
        texCoord.set(this.texCoord4);
    }

    public TexCoord4f getTexCoord4() {
        return this.texCoord4;
    }

    public void set(Tuple3f coord, Vector3f normal) {
        if (coord != null) {
            this.addFeature(1);
            this.setCoord(coord);
        }
        if (normal != null) {
            this.addFeature(2);
            this.setNormal(normal);
        }
    }

    public void get(Tuple3f coord, Vector3f normal) {
        if (coord != null && this.hasFeature(1)) {
            this.getCoord(coord);
        }
        if (normal != null && this.hasFeature(2)) {
            this.getNormal(normal);
        }
    }

    public void set(Tuple3f coord, Vector3f normal, Colorf color) {
        this.set(coord, normal);
        if (color != null) {
            this.setColor(color);
        }
    }

    public void get(Tuple3f coord, Vector3f normal, Colorf color) {
        this.get(coord, normal);
        if (color != null && this.hasFeature(4)) {
            this.getColor(color);
        }
    }

    public void set(Tuple3f coord, Vector3f normal, Colorf color, TexCoord2f texCoord) {
        this.set(coord, normal, color);
        if (texCoord != null) {
            this.setTexCoord2(texCoord);
        }
    }

    public void get(Tuple3f coord, Vector3f normal, Colorf color, TexCoord2f texCoord) {
        this.get(coord, normal, color);
        if (texCoord != null && this.hasFeature(8) && this.texCoordSize == 2) {
            this.getTexCoord2(texCoord);
        }
    }

    public void set(Tuple3f coord, Vector3f normal, Colorf color, TexCoord3f texCoord) {
        this.set(coord, normal, color);
        if (texCoord != null) {
            this.setTexCoord3(texCoord);
        }
    }

    public void get(Tuple3f coord, Vector3f normal, Colorf color, TexCoord3f texCoord) {
        this.get(coord, normal, color);
        if (texCoord != null && this.hasFeature(8) && this.texCoordSize == 3) {
            this.getTexCoord3(texCoord);
        }
    }

    public void set(Tuple3f coord, Vector3f normal, Colorf color, TexCoord4f texCoord) {
        this.set(coord, normal, color);
        if (texCoord != null) {
            this.setTexCoord4(texCoord);
        }
    }

    public void get(Tuple3f coord, Vector3f normal, Colorf color, TexCoord4f texCoord) {
        this.get(coord, normal, color);
        if (texCoord != null && this.hasFeature(8) && this.texCoordSize == 4) {
            this.getTexCoord4(texCoord);
        }
    }

    public Vertex3f(int features) {
        this.features = features | 1;
    }

    public Vertex3f() {
        this(15);
    }
}

