/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops;

import java.util.ArrayList;
import java.util.List;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.softmed.jops.GeneratorBehaviour;
import org.softmed.jops.InfoObject;
import org.softmed.jops.JiBX_MungeAdapter;
import org.softmed.jops.Particle;
import org.softmed.jops.ParticleBehaviour;
import org.softmed.jops.ParticleRender;
import org.softmed.jops.PositionAnimator;
import org.softmed.jops.SpaceAnimator;
import org.softmed.jops.modifiers.Modifier;
import org.softmed.jops.space.GeneratorSpace;
import org.softmed.jops.space.PointGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends InfoObject
implements IUnmarshallable,
IMarshallable {
    protected boolean alive = true;
    protected boolean regenerateParticles = true;
    protected boolean killParticles = true;
    protected boolean absoluteParticleAngle = false;
    float age = 0.0f;
    protected List<Particle> particles = new ArrayList<Particle>();
    protected ParticleBehaviour pb = new ParticleBehaviour();
    private GeneratorBehaviour gb = new GeneratorBehaviour();
    protected GeneratorSpace space = new PointGenerator();
    protected SpaceAnimator animator = new SpaceAnimator();
    protected ParticleRender render = new ParticleRender();
    protected PositionAnimator positionAnimator = new PositionAnimator();
    protected List<Modifier> modifiers = new ArrayList<Modifier>();
    protected Particle temp = null;
    private Modifier modifier;
    private Point3f position = new Point3f();
    private float totalGenerated;
    private int resolution;
    private float betweenGenerateCycles;
    int particleBehaviourIndex;
    int generatorBehaviourIndex;
    int spaceIndex;
    int spaceAnimatorIndex;
    int renderIndex;
    int positionAnimatorIndex;
    List<Integer> modifierIndexes;
    private Matrix3f tempRotation = new Matrix3f();
    public static final String JiBX_bindingList = "|org.softmed.jops.JiBX_bin_org_softmed_jops_fileloading_bindingsFactory|";

    public Generator getCopy() {
        Generator generator = (Generator)super.clone();
        generator.setAbsoluteParticleAngle(this.absoluteParticleAngle);
        generator.setAlive(this.alive);
        generator.setRegenerateParticles(this.regenerateParticles);
        generator.setResolution(this.resolution);
        generator.setPositionAnimator(this.positionAnimator);
        generator.setAnimator(this.animator);
        generator.setGb(this.gb);
        generator.setPb(this.pb);
        generator.setRender(this.render);
        generator.setSpace(this.space);
        generator.modifiers.addAll(this.modifiers);
        return generator;
    }

    public Generator() {
        this.pb.setParticles(this.particles);
    }

    public void recompileAll() {
        if (this.space != null) {
            this.space.recompile();
        }
        if (this.gb != null) {
            this.gb.recompile();
        }
        if (this.pb != null) {
            this.pb.setParticles(this.particles);
            this.pb.recompile();
        }
        if (this.animator != null) {
            this.animator.recompile();
        }
        if (this.positionAnimator != null) {
            this.positionAnimator.recompile();
        }
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<Modifier>();
        }
        if (this.position == null) {
            this.position = new Point3f();
        }
        for (Modifier modifier : this.modifiers) {
            modifier.recompile();
        }
    }

    public void rebuildParticles() {
        this.particles = new ArrayList<Particle>();
        if (this.pb != null) {
            this.pb.setParticles(this.particles);
        }
    }

    public void update(Point3f point3f, Matrix4f matrix4f, float f, float f2) {
        if (!this.alive) {
            return;
        }
        this.age = f;
        this.generate(point3f, matrix4f, f2);
        if (this.pb != null) {
            this.pb.setParticles(this.particles);
            this.pb.updateParticleBehaviour(this.killParticles);
        }
        this.applyModifiers();
        this.calculateAllParticles(f2);
    }

    protected void applyModifiers() {
        for (int i = 0; i < this.modifiers.size(); ++i) {
            this.modifier = this.modifiers.get(i);
            for (int j = 0; j < this.particles.size(); ++j) {
                this.modifier.modify(this.particles.get(j));
            }
        }
    }

    protected void calculateAllParticles(float f) {
        for (int i = 0; i < this.particles.size(); ++i) {
            this.particles.get(i).calculate(f);
        }
    }

    protected void generate(Point3f point3f, Matrix4f matrix4f, float f) {
        int n;
        int n2;
        if (this.gb == null) {
            return;
        }
        this.position.set(0.0f, 0.0f, 0.0f);
        if (this.animator != null) {
            this.animator.setInitialPosition(this.position);
        }
        if (matrix4f != null) {
            matrix4f.transform(this.position);
            matrix4f.getRotationScale(this.tempRotation);
        }
        float f2 = this.gb.getCurrentRate();
        this.gb.setRotation(matrix4f);
        this.totalGenerated += (f2 *= f);
        this.betweenGenerateCycles += f;
        if (this.totalGenerated < 1.0f) {
            return;
        }
        int n3 = (int)this.totalGenerated;
        int n4 = 0;
        float f3 = this.totalGenerated - (float)n3;
        f3 *= f;
        if (this.killParticles && this.regenerateParticles && n4 < n3) {
            n2 = -1;
            for (n = 0; n < this.particles.size(); ++n) {
                this.temp = this.particles.get(n);
                if (!(this.temp.life < 0.0f)) continue;
                ++n2;
                if (this.space != null) {
                    this.space.generate(this.temp);
                }
                if (this.animator != null) {
                    this.animator.setInitialPosition(this.temp.position);
                }
                if (this.positionAnimator != null) {
                    this.positionAnimator.setInitialPosition(this.temp.position);
                }
                this.temp.position.add(this.position);
                this.temp.position.add(point3f);
                if (matrix4f != null) {
                    this.tempRotation.transform(this.temp.position);
                }
                if (this.space != null) {
                    this.gb.setInitialState(this.temp, 0.0f);
                }
                if (++n4 >= n3) break;
            }
        }
        n2 = this.getGb().getNumber();
        n = this.particles.size();
        if (n < n2) {
            int n5 = -1;
            for (int i = n4; i < n3 && this.particles.size() < n2; ++i) {
                ++n5;
                this.temp = new Particle();
                if (this.space != null) {
                    this.space.generate(this.temp);
                }
                if (this.animator != null) {
                    this.animator.setInitialPosition(this.temp.position);
                }
                if (this.positionAnimator != null) {
                    this.positionAnimator.setInitialPosition(this.temp.position);
                }
                this.temp.position.add(this.position);
                this.temp.position.add(point3f);
                if (matrix4f != null) {
                    this.tempRotation.transform(this.temp.position);
                }
                if (this.gb != null) {
                    this.gb.setInitialState(this.temp, 0.0f);
                }
                this.particles.add(this.temp);
            }
        }
        this.totalGenerated -= (float)n3;
        this.betweenGenerateCycles = 0.0f;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean bl) {
        this.alive = bl;
    }

    public boolean isRegenerateParticles() {
        return this.regenerateParticles;
    }

    public void setRegenerateParticles(boolean bl) {
        this.regenerateParticles = bl;
    }

    public List<Particle> getParticles() {
        return this.particles;
    }

    public GeneratorBehaviour getGb() {
        return this.gb;
    }

    public GeneratorSpace getSpace() {
        return this.space;
    }

    public void setSpace(GeneratorSpace generatorSpace) {
        this.space = generatorSpace;
    }

    public void reset() {
        this.age = 0.0f;
        this.particles.clear();
    }

    public ParticleBehaviour getPb() {
        return this.pb;
    }

    public void setPb(ParticleBehaviour particleBehaviour) {
        this.pb = particleBehaviour;
        if (particleBehaviour != null) {
            particleBehaviour.recompile();
        }
    }

    public void rebuild() {
        if (this.gb != null) {
            this.gb.rebuild();
        }
        if (this.space != null) {
            this.space.rebuild();
        }
        if (this.pb != null) {
            this.pb.rebuild();
        }
        if (this.animator != null) {
            this.animator.rebuild();
        }
        if (this.positionAnimator != null) {
            this.positionAnimator.rebuild();
        }
    }

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int n) {
        this.resolution = n;
        if (this.gb != null) {
            this.gb.setResolution(n);
        }
        if (this.space != null) {
            this.space.setResolution(n);
        }
        if (this.pb != null) {
            this.pb.setResolution(n);
        }
        if (this.animator != null) {
            this.animator.setResolution(n);
        }
        if (this.positionAnimator != null) {
            this.positionAnimator.setResolution(n);
        }
    }

    public SpaceAnimator getAnimator() {
        return this.animator;
    }

    public void setAnimator(SpaceAnimator spaceAnimator) {
        this.animator = spaceAnimator;
    }

    public void setGb(GeneratorBehaviour generatorBehaviour) {
        this.gb = generatorBehaviour;
    }

    public boolean isAbsoluteParticleAngle() {
        return this.absoluteParticleAngle;
    }

    public void setAbsoluteParticleAngle(boolean bl) {
        this.absoluteParticleAngle = bl;
    }

    public ParticleRender getRender() {
        return this.render;
    }

    public void setRender(ParticleRender particleRender) {
        this.render = particleRender;
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<Modifier> list) {
        this.modifiers = list;
    }

    public Point3f getPosition() {
        return this.position;
    }

    public boolean isKillParticles() {
        return this.killParticles;
    }

    public void setKillParticles(boolean bl) {
        this.killParticles = bl;
    }

    public PositionAnimator getPositionAnimator() {
        return this.positionAnimator;
    }

    public void setPositionAnimator(PositionAnimator positionAnimator) {
        this.positionAnimator = positionAnimator;
    }

    public int getGeneratorBehaviourIndex() {
        return this.generatorBehaviourIndex;
    }

    public void setGeneratorBehaviourIndex(int n) {
        this.generatorBehaviourIndex = n;
    }

    public int getParticleBehaviourIndex() {
        return this.particleBehaviourIndex;
    }

    public void setParticleBehaviourIndex(int n) {
        this.particleBehaviourIndex = n;
    }

    public int getPositionAnimatorIndex() {
        return this.positionAnimatorIndex;
    }

    public void setPositionAnimatorIndex(int n) {
        this.positionAnimatorIndex = n;
    }

    public int getRenderIndex() {
        return this.renderIndex;
    }

    public void setRenderIndex(int n) {
        this.renderIndex = n;
    }

    public int getSpaceAnimatorIndex() {
        return this.spaceAnimatorIndex;
    }

    public void setSpaceAnimatorIndex(int n) {
        this.spaceAnimatorIndex = n;
    }

    public int getSpaceIndex() {
        return this.spaceIndex;
    }

    public void setSpaceIndex(int n) {
        this.spaceIndex = n;
    }

    public List<Integer> getModifierIndexes() {
        return this.modifierIndexes;
    }

    public void setModifierIndexes(List<Integer> list) {
        this.modifierIndexes = list;
    }

    public static /* synthetic */ Generator JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(UnmarshallingContext arg1) throws JiBXException {
        return new Generator();
    }

    public final /* synthetic */ Generator JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        Generator generator = this;
        arg1.parsePastStartTag(null, "InfoObject");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_1(arg1);
        arg1.parsePastCurrentEndTag(null, "InfoObject");
        this.alive = arg1.parseElementBoolean(null, "Alive");
        this.regenerateParticles = arg1.parseElementBoolean(null, "RegenerateParticles");
        this.killParticles = arg1.parseElementBoolean(null, "KillParticles");
        this.absoluteParticleAngle = arg1.parseElementBoolean(null, "AbsoluteParticleAngle");
        this.particleBehaviourIndex = arg1.parseElementInt(null, "ParticleBehaviourIndex");
        this.generatorBehaviourIndex = arg1.parseElementInt(null, "GeneratorBehaviourIndex");
        this.spaceIndex = arg1.parseElementInt(null, "SpaceIndex");
        this.spaceAnimatorIndex = arg1.parseElementInt(null, "SpaceAnimatorIndex");
        this.renderIndex = arg1.parseElementInt(null, "RenderIndex");
        this.positionAnimatorIndex = arg1.parseElementInt(null, "PositionAnimatorIndex");
        if (arg1.isAt(null, "ModifierIndexes")) {
            arg1.parsePastStartTag(null, "ModifierIndexes");
            List list = this.modifierIndexes;
            if (list == null) {
                list = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_1_0(arg1);
            }
            this.modifierIndexes = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_2(list, arg1);
            arg1.parsePastCurrentEndTag(null, "ModifierIndexes");
        } else {
            this.modifierIndexes = null;
        }
        arg1.popObject();
        return this;
    }

    @Override
    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(28).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        arg1.startTag(0, "InfoObject");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_1(arg1);
        arg1.endTag(0, "InfoObject");
        MarshallingContext marshallingContext = arg1.element(0, "Alive", Utility.serializeBoolean((boolean)this.alive)).element(0, "RegenerateParticles", Utility.serializeBoolean((boolean)this.regenerateParticles)).element(0, "KillParticles", Utility.serializeBoolean((boolean)this.killParticles)).element(0, "AbsoluteParticleAngle", Utility.serializeBoolean((boolean)this.absoluteParticleAngle)).element(0, "ParticleBehaviourIndex", Utility.serializeInt((int)this.particleBehaviourIndex)).element(0, "GeneratorBehaviourIndex", Utility.serializeInt((int)this.generatorBehaviourIndex)).element(0, "SpaceIndex", Utility.serializeInt((int)this.spaceIndex)).element(0, "SpaceAnimatorIndex", Utility.serializeInt((int)this.spaceAnimatorIndex)).element(0, "RenderIndex", Utility.serializeInt((int)this.renderIndex)).element(0, "PositionAnimatorIndex", Utility.serializeInt((int)this.positionAnimatorIndex));
        if (this.modifierIndexes != null) {
            arg1.startTag(0, "ModifierIndexes");
            JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_2(this.modifierIndexes, arg1);
            arg1.endTag(0, "ModifierIndexes");
        }
        arg1.popObject();
    }

    @Override
    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(28, "org.softmed.jops.Generator").marshal((Object)this, arg1);
    }

    @Override
    public /* synthetic */ int JiBX_getIndex() {
        return 28;
    }
}

