/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.softmed.jops.ParticleLibrary;
import org.softmed.jops.ParticleSystem;
import org.softmed.jops.fileloading.DataFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticleManager {
    protected ParticleLibrary particleLibrary = new ParticleLibrary();
    protected boolean alive = true;
    protected List<ParticleSystem> systems = new ArrayList<ParticleSystem>();
    protected List<ParticleSystem> toRemove = new ArrayList<ParticleSystem>();
    ParticleSystem ps;
    protected boolean gameMode = true;
    protected boolean resetDeadParticleSystemsInEditMode = true;
    private float dt;
    protected int calculationsPerSecond = 50;
    float tt = 1.0f / (float)this.calculationsPerSecond;
    float ft;
    float ddt = 0.0f;

    public String load(String string) throws IOException, DataFormatException {
        return this.particleLibrary.setOriginalFromFile(string);
    }

    public String load(File file) throws IOException, DataFormatException {
        return this.particleLibrary.setOriginalFromFile(file);
    }

    public String load(InputStream inputStream) throws IOException, DataFormatException {
        return this.particleLibrary.setOriginalFromStream(inputStream);
    }

    public String load(URL uRL) throws IOException, DataFormatException {
        return this.particleLibrary.setOriginalFromURL(uRL);
    }

    public ParticleSystem getCopyDetached(String string) {
        return this.particleLibrary.getStandaloneCopy(string);
    }

    public ParticleSystem getCopyAttached(String string) {
        ParticleSystem particleSystem = this.particleLibrary.getStandaloneCopy(string);
        if (particleSystem != null) {
            this.systems.add(particleSystem);
        }
        return particleSystem;
    }

    public void process(float f) {
        if (!this.alive) {
            return;
        }
        this.toRemove.clear();
        this.dt = f;
        this.ddt += this.dt;
        if (this.ddt <= this.tt) {
            return;
        }
        do {
            this.ddt -= this.tt;
            this.dt = this.tt;
            for (int i = 0; i < this.systems.size(); ++i) {
                this.ps = this.systems.get(i);
                this.ps.processFrame(this.dt);
                if (!this.ps.isRemove()) continue;
                if (this.gameMode) {
                    this.toRemove.add(this.ps);
                    continue;
                }
                if (!this.resetDeadParticleSystemsInEditMode) continue;
                this.ps.setRemove(false);
                this.ps.reset();
                this.ps.setAlive(true);
            }
            this.systems.removeAll(this.toRemove);
            for (ParticleSystem particleSystem : this.toRemove) {
                particleSystem.signalRemoved();
            }
        } while (!(this.ddt < this.tt));
    }

    public List<ParticleSystem> getSystems() {
        return this.systems;
    }

    public boolean isGameMode() {
        return this.gameMode;
    }

    public void setGameMode(boolean bl) {
        this.gameMode = bl;
    }

    public boolean isResetDeadParticleSystemsInEditMode() {
        return this.resetDeadParticleSystemsInEditMode;
    }

    public void setResetDeadParticleSystemsInEditMode(boolean bl) {
        this.resetDeadParticleSystemsInEditMode = bl;
    }

    public void purge() {
        for (ParticleSystem particleSystem : this.systems) {
            particleSystem.setRenderable(false);
            particleSystem.setAlive(false);
            particleSystem.setRemove(true);
        }
        this.systems.clear();
    }

    public void reset() {
        for (ParticleSystem particleSystem : this.systems) {
            particleSystem.reset();
        }
        this.ddt = 0.0f;
        this.dt = 0.0f;
        this.ft = 0.0f;
    }

    public int getCalculationsPerSecond() {
        return this.calculationsPerSecond;
    }

    public void setCalculationsPerSecond(int n) {
        this.calculationsPerSecond = n;
        if (n == 0) {
            n = 45;
        }
        this.tt = 1.0f / (float)n;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean bl) {
        this.alive = bl;
    }

    public ParticleLibrary getParticleLibrary() {
        return this.particleLibrary;
    }

    public void setParticleLibrary(ParticleLibrary particleLibrary) {
        this.particleLibrary = particleLibrary;
    }
}

