/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops;

import java.util.ArrayList;
import java.util.List;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.softmed.jops.Generator;
import org.softmed.jops.GeneratorBehaviour;
import org.softmed.jops.InfoObject;
import org.softmed.jops.JiBX_MungeAdapter;
import org.softmed.jops.ParticleBehaviour;
import org.softmed.jops.ParticleRender;
import org.softmed.jops.PositionAnimator;
import org.softmed.jops.RemovalListener;
import org.softmed.jops.SpaceAnimator;
import org.softmed.jops.modifiers.Modifier;
import org.softmed.jops.space.GeneratorSpace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticleSystem
extends InfoObject
implements IUnmarshallable,
IMarshallable {
    public boolean printRotMatrix = false;
    public static final int DEFAULT_RESOLUTION = 30;
    public static final String VERSION = "0.5";
    String version = "0.5";
    boolean repeat = false;
    boolean limited = false;
    boolean alive = true;
    boolean renderable = true;
    boolean remove = false;
    float limit = 2.0f;
    int resolution = 30;
    protected Point3f position = new Point3f();
    protected Matrix4f rotation;
    protected List<ParticleRender> renders = new ArrayList<ParticleRender>();
    protected List<ParticleBehaviour> behaviours = new ArrayList<ParticleBehaviour>();
    protected List<GeneratorBehaviour> genBehaviours = new ArrayList<GeneratorBehaviour>();
    protected List<GeneratorSpace> spaces = new ArrayList<GeneratorSpace>();
    protected List<SpaceAnimator> animators = new ArrayList<SpaceAnimator>();
    protected List<PositionAnimator> panimators = new ArrayList<PositionAnimator>();
    protected List<Modifier> modifiers = new ArrayList<Modifier>();
    protected List<Modifier> externalModifiers = new ArrayList<Modifier>();
    protected List<Generator> generators = new ArrayList<Generator>();
    float life = 0.0f;
    private Generator gen;
    private GeneratorBehaviour genBehaviour;
    private GeneratorSpace space;
    private SpaceAnimator animator;
    protected PositionAnimator panimator;
    private Modifier modifier;
    List<RemovalListener> removalListeners = new ArrayList<RemovalListener>();
    public static final String JiBX_bindingList = "|org.softmed.jops.JiBX_bin_org_softmed_jops_fileloading_bindingsFactory|";

    public void setCurrentVersion() {
        this.version = VERSION;
    }

    public void reset() {
        for (Generator infoObject : this.generators) {
            infoObject.reset();
        }
        for (GeneratorBehaviour generatorBehaviour : this.genBehaviours) {
            generatorBehaviour.reset();
        }
        for (GeneratorSpace generatorSpace : this.spaces) {
            generatorSpace.reset();
        }
        this.life = 0.0f;
    }

    public void setAliveAllGens(boolean bl) {
        for (Generator generator : this.generators) {
            generator.setAlive(bl);
            if (!bl) {
                generator.reset();
                continue;
            }
            generator.setAlive(true);
        }
    }

    public void stopAllGens() {
        this.setAliveAllGens(false);
    }

    public void startAllGens() {
        this.setAliveAllGens(true);
    }

    public List<GeneratorSpace> getSpaces() {
        return this.spaces;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean bl) {
        this.alive = bl;
    }

    public float getLife() {
        return this.life;
    }

    public void setLife(float f) {
        this.life = f;
    }

    public float getLimit() {
        return this.limit;
    }

    public void setLimit(float f) {
        this.limit = f;
    }

    public void updateLife(float f) {
        this.life += f;
        if (this.life > this.limit) {
            if (!this.limited) {
                if (this.repeat) {
                    this.life %= this.limit;
                    for (Generator generator : this.generators) {
                        generator.reset();
                    }
                }
            } else {
                this.alive = false;
                this.remove = true;
            }
        }
    }

    public boolean isRenderable() {
        return this.renderable;
    }

    public void setRenderable(boolean bl) {
        this.renderable = bl;
    }

    public int getResolution() {
        if (this.resolution == 0) {
            this.resolution = 30;
        }
        return this.resolution;
    }

    public void setResolution(int n) {
        this.resolution = n;
        if (this.resolution == 0) {
            this.resolution = 30;
        }
        for (Generator infoObject : this.generators) {
            infoObject.setResolution(n);
        }
        for (GeneratorSpace generatorSpace : this.spaces) {
            generatorSpace.setResolution(n);
        }
        for (SpaceAnimator spaceAnimator : this.animators) {
            spaceAnimator.setResolution(n);
        }
        for (PositionAnimator positionAnimator : this.panimators) {
            positionAnimator.setResolution(n);
        }
        for (ParticleBehaviour particleBehaviour : this.behaviours) {
            particleBehaviour.setResolution(n);
        }
        for (GeneratorBehaviour generatorBehaviour : this.genBehaviours) {
            generatorBehaviour.setResolution(n);
        }
        for (Modifier modifier : this.modifiers) {
            modifier.setResolution(n);
        }
    }

    public List<GeneratorBehaviour> getGenBehaviours() {
        return this.genBehaviours;
    }

    public List<ParticleBehaviour> getBehaviours() {
        return this.behaviours;
    }

    public List<SpaceAnimator> getAnimators() {
        return this.animators;
    }

    public void processFrame(float f) {
        int n;
        if (!this.alive) {
            return;
        }
        if (this.rotation == null || this.printRotMatrix) {
            // empty if block
        }
        this.updateLife(f);
        for (n = 0; n < this.spaces.size(); ++n) {
            this.space = this.spaces.get(n);
            this.space.update(this.life);
        }
        for (n = 0; n < this.animators.size(); ++n) {
            this.animator = this.animators.get(n);
            this.animator.update(this.life, f);
        }
        for (n = 0; n < this.panimators.size(); ++n) {
            this.panimator = this.panimators.get(n);
            this.panimator.update(this.life, f);
        }
        for (n = 0; n < this.genBehaviours.size(); ++n) {
            this.genBehaviour = this.genBehaviours.get(n);
            this.genBehaviour.update(this.life, f);
        }
        for (n = 0; n < this.modifiers.size(); ++n) {
            this.modifier = this.modifiers.get(n);
            this.modifier.update(this.position, this.rotation, this.life, f);
        }
        for (n = 0; n < this.generators.size(); ++n) {
            this.gen = this.generators.get(n);
            this.gen.update(this.position, this.rotation, this.life, f);
        }
    }

    public void rebuild() {
        if (this.genBehaviours == null) {
            this.genBehaviours = new ArrayList<GeneratorBehaviour>();
        }
        if (this.animators == null) {
            this.animators = new ArrayList<SpaceAnimator>();
        }
        if (this.panimators == null) {
            this.panimators = new ArrayList<PositionAnimator>();
        }
        if (this.behaviours == null) {
            this.behaviours = new ArrayList<ParticleBehaviour>();
        }
        if (this.renders == null) {
            this.renders = new ArrayList<ParticleRender>();
        }
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<Modifier>();
        }
        for (Generator infoObject : this.generators) {
            infoObject.rebuildParticles();
            infoObject.recompileAll();
            infoObject.setResolution(this.resolution);
            infoObject.rebuild();
            if (infoObject.getGb() != null && !this.genBehaviours.contains(infoObject.getGb())) {
                this.genBehaviours.add(infoObject.getGb());
            }
            if (infoObject.getSpace() != null && !this.spaces.contains(infoObject.getSpace())) {
                this.spaces.add(infoObject.getSpace());
            }
            if (infoObject.getAnimator() != null && !this.animators.contains(infoObject.getAnimator())) {
                this.animators.add(infoObject.getAnimator());
            }
            if (infoObject.getPositionAnimator() != null && !this.panimators.contains(infoObject.getPositionAnimator())) {
                this.panimators.add(infoObject.getPositionAnimator());
            }
            if (infoObject.getPb() != null && !this.behaviours.contains(infoObject.getPb())) {
                this.behaviours.add(infoObject.getPb());
            }
            if (infoObject.getRender() != null && !this.renders.contains(infoObject.getRender())) {
                this.renders.add(infoObject.getRender());
            }
            if (infoObject.getModifiers() == null || this.modifiers.containsAll(infoObject.getModifiers())) continue;
            this.modifiers.addAll(infoObject.getModifiers());
        }
        for (GeneratorSpace generatorSpace : this.spaces) {
            generatorSpace.recompile();
        }
    }

    public List<Generator> getGenerators() {
        return this.generators;
    }

    public List<ParticleRender> getRenders() {
        return this.renders;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean bl) {
        this.limited = bl;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean bl) {
        this.remove = bl;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean bl) {
        this.repeat = bl;
    }

    public void addGenerator(Generator generator) {
        this.generators.add(generator);
        if (generator.getGb() != null && !this.genBehaviours.contains(generator.getGb())) {
            this.genBehaviours.add(generator.getGb());
        }
        if (generator.getSpace() != null && !this.spaces.contains(generator.getSpace())) {
            this.spaces.add(generator.getSpace());
        }
        if (generator.getAnimator() != null && !this.animators.contains(generator.getAnimator())) {
            this.animators.add(generator.getAnimator());
        }
        if (generator.getPositionAnimator() != null && !this.panimators.contains(generator.getPositionAnimator())) {
            this.panimators.add(generator.getPositionAnimator());
        }
        if (generator.getPb() != null && !this.behaviours.contains(generator.getPb())) {
            this.behaviours.add(generator.getPb());
        }
        if (generator.getRender() != null && !this.renders.contains(generator.getRender())) {
            this.renders.add(generator.getRender());
        }
        if (generator.getModifiers() != null && !this.modifiers.containsAll(generator.getModifiers())) {
            this.modifiers.addAll(generator.getModifiers());
        }
    }

    public void removeGenB(GeneratorBehaviour generatorBehaviour) {
        this.genBehaviours.remove(generatorBehaviour);
        for (Generator generator : this.generators) {
            if (generator.getGb() != generatorBehaviour) continue;
            generator.setGb(null);
        }
    }

    public void removeParB(ParticleBehaviour particleBehaviour) {
        this.behaviours.remove(particleBehaviour);
        for (Generator generator : this.generators) {
            if (generator.getPb() != particleBehaviour) continue;
            generator.setPb(null);
        }
    }

    public void removeSpace(GeneratorSpace generatorSpace) {
        this.spaces.remove(generatorSpace);
        for (Generator generator : this.generators) {
            if (generator.getSpace() != generatorSpace) continue;
            generator.setSpace(null);
        }
    }

    public void removeRender(ParticleRender particleRender) {
        this.renders.remove(particleRender);
        for (Generator generator : this.generators) {
            if (generator.getRender() != particleRender) continue;
            generator.setRender(null);
        }
    }

    public void removeAnimator(SpaceAnimator spaceAnimator) {
        this.animators.remove(spaceAnimator);
        for (Generator generator : this.generators) {
            if (generator.getAnimator() != spaceAnimator) continue;
            generator.setAnimator(null);
        }
    }

    public void removePositionAnimator(PositionAnimator positionAnimator) {
        this.panimators.remove(positionAnimator);
        for (Generator generator : this.generators) {
            if (generator.getPositionAnimator() != positionAnimator) continue;
            generator.setPositionAnimator(null);
        }
    }

    public void removeModifier(Modifier modifier) {
        this.modifiers.remove(modifier);
        for (Generator generator : this.generators) {
            if (!generator.getModifiers().contains(modifier)) continue;
            generator.getModifiers().remove(modifier);
        }
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public List<PositionAnimator> getPanimators() {
        return this.panimators;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setAnimators(List<SpaceAnimator> list) {
        this.animators = list;
    }

    public void setBehaviours(List<ParticleBehaviour> list) {
        this.behaviours = list;
    }

    public void setGenBehaviours(List<GeneratorBehaviour> list) {
        this.genBehaviours = list;
    }

    public void setGenerators(List<Generator> list) {
        this.generators = list;
    }

    public void setModifiers(List<Modifier> list) {
        this.modifiers = list;
    }

    public void setPanimators(List<PositionAnimator> list) {
        this.panimators = list;
    }

    public void setRenders(List<ParticleRender> list) {
        this.renders = list;
    }

    public void setSpaces(List<GeneratorSpace> list) {
        this.spaces = list;
    }

    public Point3f getPosition() {
        return this.position;
    }

    public void setPosition(Point3f point3f) {
        this.position = point3f;
    }

    public Matrix4f getRotation() {
        return this.rotation;
    }

    public void setRotation(Matrix4f matrix4f) {
        this.rotation = matrix4f;
    }

    public void addExternalModifier(Modifier modifier) {
        this.externalModifiers.add(modifier);
        for (int i = 0; i < this.generators.size(); ++i) {
            this.gen = this.generators.get(i);
            this.gen.getModifiers().add(modifier);
        }
    }

    public void removeExternalModifier(Modifier modifier) {
        this.externalModifiers.remove(modifier);
        for (int i = 0; i < this.generators.size(); ++i) {
            this.gen = this.generators.get(i);
            this.gen.getModifiers().remove(modifier);
        }
    }

    public void removeAllExternalModifiers() {
        for (int i = 0; i < this.generators.size(); ++i) {
            this.gen = this.generators.get(i);
            this.gen.getModifiers().removeAll(this.externalModifiers);
        }
        this.externalModifiers.clear();
    }

    public void addInternalModifiersAsExternal(ParticleSystem particleSystem) {
        List<Modifier> list = particleSystem.getModifiers();
        this.externalModifiers.addAll(list);
        for (int i = 0; i < this.generators.size(); ++i) {
            this.gen = this.generators.get(i);
            this.gen.getModifiers().addAll(list);
        }
    }

    public List<RemovalListener> getRemovalListeners() {
        return this.removalListeners;
    }

    public void addRemovalListener(RemovalListener removalListener) {
        this.removalListeners.add(removalListener);
    }

    public void removeRemovalListener(RemovalListener removalListener) {
        this.removalListeners.remove(removalListener);
    }

    public void signalRemoved() {
        for (RemovalListener removalListener : this.removalListeners) {
            removalListener.wasRemoved(this);
        }
    }

    public static /* synthetic */ ParticleSystem JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_2_0(UnmarshallingContext arg1) throws JiBXException {
        return new ParticleSystem();
    }

    public final /* synthetic */ ParticleSystem JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_2_0(UnmarshallingContext arg1) throws JiBXException {
        arg1.pushTrackedObject((Object)this);
        ParticleSystem particleSystem = this;
        arg1.parsePastStartTag(null, "InfoObject");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_1(arg1);
        arg1.parsePastCurrentEndTag(null, "InfoObject");
        String string = arg1.parseElementText(null, "Version");
        if (string == null) {
            string = null;
        }
        this.version = string;
        this.repeat = arg1.parseElementBoolean(null, "Repeat");
        this.limited = arg1.parseElementBoolean(null, "Limited");
        this.alive = arg1.parseElementBoolean(null, "Alive");
        this.renderable = arg1.parseElementBoolean(null, "Renderable");
        this.limit = arg1.parseElementFloat(null, "Limit");
        this.resolution = arg1.parseElementInt(null, "Resolution");
        arg1.parsePastStartTag(null, "Renders");
        List list = this.renders;
        if (list == null) {
            list = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_1_0(arg1);
        }
        this.renders = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_3(list, arg1);
        arg1.parsePastCurrentEndTag(null, "Renders");
        arg1.parsePastStartTag(null, "ParticleBehaviours");
        List list2 = this.behaviours;
        if (list2 == null) {
            list2 = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_1_0(arg1);
        }
        this.behaviours = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_4(list2, arg1);
        arg1.parsePastCurrentEndTag(null, "ParticleBehaviours");
        arg1.parsePastStartTag(null, "GeneratorBehaviours");
        List list3 = this.genBehaviours;
        if (list3 == null) {
            list3 = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_1_0(arg1);
        }
        this.genBehaviours = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_5(list3, arg1);
        arg1.parsePastCurrentEndTag(null, "GeneratorBehaviours");
        arg1.parsePastStartTag(null, "Spaces");
        List list4 = this.spaces;
        if (list4 == null) {
            list4 = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_1_0(arg1);
        }
        this.spaces = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_6(list4, arg1);
        arg1.parsePastCurrentEndTag(null, "Spaces");
        arg1.parsePastStartTag(null, "SpaceAnimators");
        List list5 = this.animators;
        if (list5 == null) {
            list5 = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_1_0(arg1);
        }
        this.animators = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_7(list5, arg1);
        arg1.parsePastCurrentEndTag(null, "SpaceAnimators");
        arg1.parsePastStartTag(null, "PositionAnimators");
        List list6 = this.panimators;
        if (list6 == null) {
            list6 = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_1_0(arg1);
        }
        this.panimators = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_8(list6, arg1);
        arg1.parsePastCurrentEndTag(null, "PositionAnimators");
        arg1.parsePastStartTag(null, "Modifiers");
        List list7 = this.modifiers;
        if (list7 == null) {
            list7 = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_1_0(arg1);
        }
        this.modifiers = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_9(list7, arg1);
        arg1.parsePastCurrentEndTag(null, "Modifiers");
        arg1.parsePastStartTag(null, "Generators");
        List list8 = this.generators;
        if (list8 == null) {
            list8 = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_newinstance_1_0(arg1);
        }
        this.generators = JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_unmarshal_1_10(list8, arg1);
        arg1.parsePastCurrentEndTag(null, "Generators");
        arg1.popObject();
        return this;
    }

    @Override
    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller(29).unmarshal((Object)this, arg1);
    }

    public final /* synthetic */ void JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_2_0(MarshallingContext arg1) throws JiBXException {
        arg1.pushObject((Object)this);
        arg1.startTag(0, "InfoObject");
        this.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_1(arg1);
        arg1.endTag(0, "InfoObject");
        MarshallingContext marshallingContext = arg1.element(0, "Version", this.version).element(0, "Repeat", Utility.serializeBoolean((boolean)this.repeat)).element(0, "Limited", Utility.serializeBoolean((boolean)this.limited)).element(0, "Alive", Utility.serializeBoolean((boolean)this.alive)).element(0, "Renderable", Utility.serializeBoolean((boolean)this.renderable)).element(0, "Limit", Utility.serializeFloat((float)this.limit)).element(0, "Resolution", Utility.serializeInt((int)this.resolution));
        arg1.startTag(0, "Renders");
        JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_10(this.renders, arg1);
        arg1.endTag(0, "Renders");
        arg1.startTag(0, "ParticleBehaviours");
        JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_11(this.behaviours, arg1);
        arg1.endTag(0, "ParticleBehaviours");
        arg1.startTag(0, "GeneratorBehaviours");
        JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_12(this.genBehaviours, arg1);
        arg1.endTag(0, "GeneratorBehaviours");
        arg1.startTag(0, "Spaces");
        JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_13(this.spaces, arg1);
        arg1.endTag(0, "Spaces");
        arg1.startTag(0, "SpaceAnimators");
        JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_14(this.animators, arg1);
        arg1.endTag(0, "SpaceAnimators");
        arg1.startTag(0, "PositionAnimators");
        JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_15(this.panimators, arg1);
        arg1.endTag(0, "PositionAnimators");
        arg1.startTag(0, "Modifiers");
        JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_16(this.modifiers, arg1);
        arg1.endTag(0, "Modifiers");
        arg1.startTag(0, "Generators");
        JiBX_MungeAdapter.JiBX_bin_org_softmed_jops_fileloading_bindings_marshal_1_17(this.generators, arg1);
        arg1.endTag(0, "Generators");
        arg1.popObject();
    }

    @Override
    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller(29, "org.softmed.jops.ParticleSystem").marshal((Object)this, arg1);
    }

    @Override
    public /* synthetic */ int JiBX_getIndex() {
        return 29;
    }
}

