/*
 * Decompiled with CFR 0.152.
 */
package org.softmed.jops.valuelists;

import java.util.List;
import org.softmed.jops.random.RandomGenerator;
import org.softmed.jops.valuelists.SimpleGenericValueList;
import org.softmed.jops.values.GenericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneralRandomValueList<T> {
    RandomGenerator generator = new RandomGenerator();
    SimpleGenericValueList<T> mainValueList;
    SimpleGenericValueList<T> randomValueList;
    float bias;
    boolean active;
    boolean random;
    private T value;
    private T rvalue;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public float getBias() {
        return this.bias;
    }

    public void setBias(float f) {
        this.bias = f;
    }

    public T getValueAt(float f) {
        if (this.random) {
            this.value = this.mainValueList.getValueAt(f);
            this.rvalue = this.randomValueList.getValueAt(f);
            return this.calculateRandomValue(this.value, this.rvalue);
        }
        return this.mainValueList.getValueAt(f);
    }

    public void addValue(T t, float f) {
        this.mainValueList.setValue(t, f);
    }

    protected abstract T calculateRandomValue(T var1, T var2);

    public SimpleGenericValueList<T> getMainValueList() {
        return this.mainValueList;
    }

    public void setMainValueList(SimpleGenericValueList<T> simpleGenericValueList) {
        this.mainValueList = simpleGenericValueList;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setRandom(boolean bl) {
        if (this.generator == null) {
            this.generator = new RandomGenerator();
        }
        this.random = bl;
    }

    public SimpleGenericValueList<T> getRandomValueList() {
        return this.randomValueList;
    }

    public void setRandomValueList(SimpleGenericValueList<T> simpleGenericValueList) {
        this.randomValueList = simpleGenericValueList;
    }

    public void setRepeat(boolean bl) {
        this.mainValueList.setRepeat(bl);
    }

    public void compileArray() {
        if (this.generator == null) {
            this.generator = new RandomGenerator();
        }
        this.mainValueList.compileArray();
        this.randomValueList.compileArray();
    }

    public void setResolution(int n) {
        this.mainValueList.setResolution(n);
        this.mainValueList.setResolution(n);
    }

    public List<GenericValue> getValues() {
        return this.mainValueList.getValues();
    }
}

