/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.benchmarks.BenchmarkBase;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.commandline.BasicApplicationArguments;

@Xith3DTest.Description(fulltext={"Renders a simple rotating cube for a benchmark."}, authors={"Marvin Froehlich (aka Qudus)"})
public class CubeBenchmark
extends BenchmarkBase {
    private static final Geometry.Optimization OPTIMIZATION = Geometry.Optimization.USE_DISPLAY_LISTS;

    protected void initSceneBeforeCanvas(Xith3DEnvironment env, Sized2iRO resolution) {
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.15f, 0.25f, 0.0f));
        Cube cube = new Cube(3.0f, "stone.jpg");
        cube.getGeometry().setOptimization(OPTIMIZATION);
        rg.addChild(cube);
        env.addPerspectiveBranch().getBranchGroup().addChild(rg);
        this.getAnimator().addAnimatableObject(rg);
    }

    protected void initSceneAfterCanvas(Xith3DEnvironment env) {
    }

    public CubeBenchmark(BasicApplicationArguments arguments) throws Throwable {
        super(arguments);
        this.startBenchmark(30L);
    }

    public static void main(String[] args) throws Throwable {
        CubeBenchmark test = new CubeBenchmark(CubeBenchmark.parseCommandLine(args));
        test.begin();
    }
}

