/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.benchmarks;

import org.openmali.FastMath;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.benchmarks.BenchmarkBase;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.utility.commandline.BasicApplicationArguments;

@Xith3DTest.Description(fulltext={"Renders a large number of cubes on a square.", "The square is rotates in a whole and the cubes are moved on a wave."}, authors={"Marvin Froehlich (aka Qudus)"})
public class MultiCubeBenchmark
extends BenchmarkBase {
    private static final Geometry.Optimization OPTIMIZATION = Geometry.Optimization.USE_DISPLAY_LISTS;
    private static final int NUMBER_OF_CUBES = 900;
    private int field_size;
    private static final float SIZE = 6.0f;
    private float cubeDist;
    private TransformGroup[] cubeGroups;

    private void waveCubes(long gameMicros) {
        float fact = (float)(gameMicros % 1000000L) / 1000000.0f;
        Vector3f pos = new Vector3f();
        for (int i = 0; i < this.field_size; ++i) {
            for (int j = 0; j < this.field_size; ++j) {
                int k = i * this.field_size + j;
                float a = (-((float)this.field_size) / 2.0f + 0.5f + (float)i) / (float)this.field_size;
                float b = (-((float)this.field_size) / 2.0f + 0.5f + (float)j) / (float)this.field_size;
                float x = FastMath.sqrt(a * a + b * b) + fact;
                Transform3D t3d = this.cubeGroups[k].getTransform();
                t3d.getTranslation(pos);
                pos.setZ(FastMath.sin(x *= (float)Math.PI * 2) * 0.3f);
                t3d.setTranslation(pos);
                this.cubeGroups[k].setTransform(t3d);
            }
        }
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.waveCubes(timingMode.getMicroSeconds(gameTime));
    }

    protected void initSceneBeforeCanvas(Xith3DEnvironment env, Sized2iRO resolution) {
        Node.pushGlobalIgnoreBounds(true);
        RotatableGroup rootGroup = new RotatableGroup(new TransformationDirectives(0.0f, 0.1f, 0.0f));
        this.cubeGroups = new TransformGroup[900];
        Appearance a = new Appearance();
        a.setTexture(TextureLoader.getInstance().getTexture("jplogo.jpg"));
        this.field_size = (int)Math.sqrt(900.0);
        this.cubeDist = 6.0f / (float)this.field_size;
        float cubeSize = this.cubeDist * 0.6f;
        Cube cube = new Cube(cubeSize, a);
        cube.getGeometry().setOptimization(OPTIMIZATION);
        for (int i = 0; i < this.field_size; ++i) {
            for (int j = 0; j < this.field_size; ++j) {
                int k = i * this.field_size + j;
                Vector3f pos = new Vector3f();
                pos.setX(-3.0f + this.cubeDist / 2.0f + (float)i * this.cubeDist);
                pos.setY(-3.0f + this.cubeDist / 2.0f + (float)j * this.cubeDist);
                Transform3D t3d = new Transform3D();
                t3d.setTranslation(pos);
                this.cubeGroups[k] = new TransformGroup(t3d);
                this.cubeGroups[k].addChild(cube.sharedCopy());
                rootGroup.addChild(this.cubeGroups[k]);
            }
        }
        RenderPass renderPass = env.addPerspectiveBranch();
        renderPass.getConfig().setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy.SORT_NONE);
        renderPass.getBranchGroup().addChild(rootGroup);
        this.getAnimator().addAnimatableObject(rootGroup);
        Node.popGlobalIgnoreBounds();
    }

    protected void initSceneAfterCanvas(Xith3DEnvironment env) {
    }

    public MultiCubeBenchmark(BasicApplicationArguments arguments) throws Throwable {
        super(arguments);
        this.startBenchmark(30L);
    }

    public static void main(String[] args) throws Throwable {
        MultiCubeBenchmark test = new MultiCubeBenchmark(MultiCubeBenchmark.parseCommandLine(args));
        test.begin();
    }
}

