/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.bumpmapping.AssemblyBumpMappingFactory;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.primitives.Sphere;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;

@Xith3DTest.Description(fulltext={"Demo of a bump-mapped Earth."}, authors={"Marvin Froehlich (aka Qudus)"})
public class BumpedEarthDemo
extends Xith3DTest {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case SPACE: {
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void createSceneGraph(SceneGraph sceneGraph) {
        BranchGroup scene = new BranchGroup();
        PointLight light = new PointLight();
        light.setAttenuation(1.0f, 0.0f, 0.0f);
        light.setLocation(5.0f, 5.0f, 5.0f);
        scene.addChild(light);
        EffectFactory.getInstance().registerBumpMappingFactory(new AssemblyBumpMappingFactory());
        Sphere earth = new Sphere(2.0f, 128, 32, "earth.jpg");
        earth.setBumpMappingEnabled(true, "earthbump2.jpg");
        RotatableGroup rg = new RotatableGroup(new TransformationDirectives(0.1f, 0.0f, 0.1f));
        rg.addChild(earth);
        this.getAnimator().addAnimatableObject(rg);
        scene.addChild(rg);
        sceneGraph.addPerspectiveBranch(scene);
    }

    public BumpedEarthDemo(BasicApplicationArguments arguments) throws Throwable {
        super((Float)null);
        Xith3DEnvironment env = new Xith3DEnvironment(0.0f, 0.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
    }

    public static void main(String[] args) throws Throwable {
        BumpedEarthDemo test = new BumpedEarthDemo(BumpedEarthDemo.parseCommandLine(args));
        test.begin();
    }
}

