/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyPressedEvent;
import org.openmali.vecmath2.Colorf;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.demos.utils.RippleFactory;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.CanvasFPSListener;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.SkyBox;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.util.TestUtils;
import org.xith3d.utility.commandline.BasicApplicationArguments;
import org.xith3d.utility.events.WindowClosingRenderLoopEnder;
import org.xith3d.utility.texturing.CubeTextureSet;

@Xith3DTest.Description(fulltext={"Water rendering test."}, authors={"Abdul Bezrati (aka JavaCoolDude)", "Marvin Froehlich (aka Qudus)"})
public class WaterCubeMapTest
extends Xith3DTest {
    private BranchGroup scene;
    private RippleFactory waterFactory;

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        switch (key.getKeyID()) {
            case L: {
                this.waterFactory.switchFillWire();
                break;
            }
            case R: {
                this.waterFactory.createRandomRipple();
                break;
            }
            case SPACE: {
                this.waterFactory.rippleCreatorState();
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        super.prepareNextFrame(gameTime, frameTime, timingMode);
        this.waterFactory.update(gameTime, frameTime, this.getTimingMode());
    }

    private BranchGroup createSceneGraph(View view, CubeTextureSet skyTextureSet) throws Exception {
        BranchGroup scene = new BranchGroup();
        CubeTextureSet tcs = new CubeTextureSet(skyTextureSet.getTextureNames(), TextureLoader.FlipMode.NOT_FLIPPED);
        this.waterFactory = new RippleFactory(80, 80, tcs, view);
        scene.addChild(this.waterFactory.getWater());
        return scene;
    }

    public WaterCubeMapTest(BasicApplicationArguments arguments) throws Throwable {
        super(arguments.getMaxFPS());
        ResourceLocator resLoc = TestUtils.createResourceLocator();
        resLoc.createAndAddTSL("skyboxes");
        Xith3DEnvironment env = new Xith3DEnvironment(-300.0f, 300.0f, 350.0f, 0.0f, -50.0f, 15.0f, 0.0f, 1.0f, 0.0f, this);
        env.getView().setBackClipDistance(10000.0f);
        CubeTextureSet cts = CubeTextureSet.create("sb2/", "jpg");
        env.addRenderPass(new SkyBox(cts));
        this.scene = this.createSceneGraph(env.getView(), cts);
        env.addPerspectiveBranch(this.scene);
        Canvas3D canvas = this.createCanvas(arguments.getCanvasConstructionInfo(), this.getClass().getSimpleName());
        canvas.setBackgroundColor(Colorf.BLACK);
        env.addCanvas(canvas);
        canvas.addWindowClosingListener(new WindowClosingRenderLoopEnder(this));
        this.addFPSListener(new CanvasFPSListener(canvas));
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        FirstPersonInputHandler fpih = new FirstPersonInputHandler((Transformable)env.getView(), canvas, 1.0f, 1.0f, arguments.getMouseYInverted(), 100.0f);
        fpih.getBindingsManager().createDefaultBindings();
        InputSystem.getInstance().addInputHandler(fpih);
    }

    public static void main(String[] args) throws Throwable {
        WaterCubeMapTest test = new WaterCubeMapTest(WaterCubeMapTest.parseCommandLine(args));
        test.begin();
    }
}

