/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.shooter_demo.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.jagatoo.loaders.models.bsp.BSPClusterManager;
import org.xith3d.demos.shooter_demo.graphics.Graphics;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.models.util.specific.bsp.CollisionEnabledClusterManager;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.scenegraph.BSPTreeGroup;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.RenderableSceneGraph;

public class LevelLoader {
    private final RenderableSceneGraph sceneGraph;
    private final CollisionEngine collEngine;
    private RenderPass renderPass = null;

    private RenderPass createRenderPass(RenderableSceneGraph sg, Model scene) {
        if (this.renderPass != null) {
            sg.removeRenderPass(this.renderPass);
        }
        this.renderPass = RenderPass.createPerspective(new BranchGroup((Node)scene));
        this.renderPass.getConfig().setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy.SORT_NONE);
        this.renderPass.getConfig().setFrontClipDistance(0.1f);
        this.renderPass.getConfig().setBackClipDistance(100.0f);
        sg.addRenderPassFirst(this.renderPass);
        return this.renderPass;
    }

    public Model loadLevel(URL url) throws MalformedURLException, IOException {
        Model scene = ModelLoader.getInstance().loadModel(url);
        BSPTreeGroup bspTG = (BSPTreeGroup)scene.getMainGroup();
        CollisionEnabledClusterManager clusterManager = new CollisionEnabledClusterManager((BSPClusterManager)bspTG.getBSPVisibilityUpdater(), scene, this.collEngine);
        bspTG.setBSPVisibilityUpdater(clusterManager);
        this.createRenderPass(this.sceneGraph, scene);
        return scene;
    }

    public LevelLoader(Graphics graphics, CollisionEngine collEngine) {
        this.sceneGraph = graphics;
        this.collEngine = collEngine;
    }
}

