/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.shooter_demo.graphics.ui.hud;

import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.demos.shooter_demo.graphics.ui.hud.GameHUD;
import org.xith3d.demos.shooter_demo.graphics.ui.menu.GammaFrame;
import org.xith3d.loop.RenderLoop;
import org.xith3d.render.Canvas3D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.FPSCounter;
import org.xith3d.ui.hud.widgets.Image;

public class GameHUDImpl
extends HUD
implements GameHUD {
    private final RenderLoop renderLoop;
    private final FPSCounter fpsCounter;
    private GammaFrame gammaFrame;

    public final void setFPSCounterVisible(boolean visible) {
        if (this.fpsCounter.isVisible()) {
            this.fpsCounter.setVisible(false);
            this.renderLoop.removeFPSListener(this.fpsCounter);
            this.getContentPane().removeWidget(this.fpsCounter);
        } else {
            this.renderLoop.addFPSListener(this.fpsCounter);
            this.getContentPane().addWidget(this.fpsCounter, 20.0f, 10.0f);
            this.fpsCounter.setVisible(true);
        }
    }

    public final boolean isFPSCounterVisible() {
        return this.fpsCounter.isVisible();
    }

    public GameHUDImpl(Canvas3D canvas, RenderLoop renderLoop) {
        super((Sized2iRO)canvas, 1280.0f);
        this.renderLoop = renderLoop;
        this.setCrosshair("CrosshairWhite.png");
        this.fpsCounter = new FPSCounter(150.0f, 60.0f);
        this.fpsCounter.setFont(HUDFont.getFont("Verdana", HUDFont.BOLD, 32));
        this.fpsCounter.setFontColor(Colorf.WHITE);
        this.fpsCounter.setVisible(false);
        Image image = new Image(this.getResX(), this.getResX() / 10.0f, "Doom_HUD.png");
        this.getContentPane().addWidget(image, 0.0f, this.getResY() - image.getHeight());
        this.gammaFrame = new GammaFrame(canvas, 300.0f, 162.0f, "Gamma-adjuster");
        this.addWindowCentered(this.gammaFrame);
        this.gammaFrame.setVisible(false);
    }
}

