/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.utils;

import org.jagatoo.opengl.enums.DrawMode;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TriangleStripArray;

public class FlagFactory
implements Updatable {
    private static final int GRID_WIDTH = 16;
    private static final int GRID_HEIGHT = 12;
    private int numberOfNodes = 192;
    private int numberOfSprings = 180;
    private long timeSinceLastUpdate = 0L;
    private final long timePrecision = 5000L;
    private float damp = 0.9f;
    private float springLength = 1.3f;
    private float springConstant = 20.0f;
    private float clothInitalHeight = 17.0f;
    private Spring[] springs = null;
    private boolean wireMesh = false;
    private boolean lightingOn = true;
    private Shape3D ground = null;
    private Shape3D flag = null;
    private Point3f gridStart = this.getGridStart();
    private Point3f[] flagData = null;
    private Vector3f tensionDirection = new Vector3f();
    private Vector3f gravityVector = new Vector3f(0.0f, -0.4f, 0.0f);
    private Vector3f acceleration = new Vector3f();
    private Vector3f usefulVector = new Vector3f();
    private Vector3f windAction = new Vector3f();
    private Vector3f windForce = new Vector3f(0.3f, 0.3f, -0.1f);
    private Vector3f[] flagNormals = null;
    private Triangle[] flagMesh = null;
    private FlagNode[] flagNodes1 = null;
    private FlagNode[] flagNodes2 = null;
    private FlagNode[] nextFlagNodes = null;
    private FlagNode[] currentFlagNodes = null;
    private Appearance flagAppearance = new Appearance();
    private PolygonAttributes polygonAttributes = null;
    private TriangleStripArray flagGeomtry = null;

    private void computeNodeNormals() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.currentFlagNodes[i].normal.set(0.0f, 0.0f, 0.0f);
        }
        Point3f p0 = null;
        Point3f p1 = null;
        Point3f p2 = null;
        Point3f p3 = null;
        Vector3f n0 = null;
        Vector3f n1 = null;
        Vector3f n2 = null;
        Vector3f n3 = null;
        Vector3f tool = new Vector3f();
        Vector3f normal = new Vector3f();
        for (int j = 0; j < 11; ++j) {
            for (int i = 0; i < 15; ++i) {
                p0 = this.currentFlagNodes[(j + 0) * 16 + i].location;
                p1 = this.currentFlagNodes[(j + 0) * 16 + i + 1].location;
                p2 = this.currentFlagNodes[(j + 1) * 16 + i].location;
                p3 = this.currentFlagNodes[(j + 1) * 16 + i + 1].location;
                n0 = this.currentFlagNodes[(j + 0) * 16 + i].normal;
                n1 = this.currentFlagNodes[(j + 0) * 16 + i + 1].normal;
                n2 = this.currentFlagNodes[(j + 1) * 16 + i].normal;
                n3 = this.currentFlagNodes[(j + 1) * 16 + i + 1].normal;
                tool.sub(p1, p0);
                normal.sub(p2, p0);
                normal.cross(normal, tool);
                n0.add(normal);
                n1.add(normal);
                n2.add(normal);
                tool.sub(p1, p2);
                normal.sub(p3, p2);
                normal.cross(normal, tool);
                n1.add(normal);
                n2.add(normal);
                n3.add(normal);
            }
        }
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.currentFlagNodes[i].normal.normalize();
        }
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        int i;
        boolean updated = false;
        this.timeSinceLastUpdate += timingMode.getMicroSeconds(frameTime);
        while (this.timeSinceLastUpdate > 5000L) {
            this.timeSinceLastUpdate -= 5000L;
            updated = true;
            for (i = 0; i < this.numberOfNodes; ++i) {
                this.currentFlagNodes[i].resetForce();
            }
            for (i = 0; i < this.flagMesh.length; ++i) {
                this.flagMesh[i].normal.normalize();
                this.windAction.scale(this.flagMesh[i].normal.dot(this.windForce), this.flagMesh[i].normal);
                this.flagMesh[i].addForce(this.windAction);
            }
            for (i = 0; i < this.numberOfSprings; ++i) {
                this.usefulVector.sub(this.currentFlagNodes[this.springs[i].firstNode].location, this.currentFlagNodes[this.springs[i].secondNode].location);
                this.springs[i].tension = this.springConstant * (this.usefulVector.length() - this.springs[i].naturalLength) / this.springs[i].naturalLength;
            }
            for (i = 0; i < this.numberOfNodes; ++i) {
                this.nextFlagNodes[i].still = this.currentFlagNodes[i].still;
                if (this.currentFlagNodes[i].still) {
                    this.nextFlagNodes[i].location = this.currentFlagNodes[i].location;
                    this.nextFlagNodes[i].velocity.set(0.0f, 0.0f, 0.0f);
                    continue;
                }
                Vector3f force = new Vector3f();
                force.add(this.gravityVector, this.currentFlagNodes[i].force);
                for (int j = 0; j < this.numberOfSprings; ++j) {
                    if (this.springs[j].firstNode == i) {
                        this.tensionDirection.sub(this.currentFlagNodes[this.springs[j].secondNode].location, this.currentFlagNodes[i].location);
                        this.tensionDirection.normalize();
                        force.scaleAdd(this.springs[j].tension, this.tensionDirection, force);
                    }
                    if (this.springs[j].secondNode != i) continue;
                    this.tensionDirection.sub(this.currentFlagNodes[this.springs[j].firstNode].location, this.currentFlagNodes[i].location);
                    this.tensionDirection.normalize();
                    force.scaleAdd(this.springs[j].tension, this.tensionDirection, force);
                }
                this.acceleration.scale(100.0f, force);
                this.nextFlagNodes[i].velocity.scaleAdd(0.01f, this.acceleration, this.currentFlagNodes[i].velocity);
                this.nextFlagNodes[i].velocity.scale(this.damp);
                this.usefulVector.add(this.nextFlagNodes[i].velocity, this.currentFlagNodes[i].velocity);
                this.usefulVector.scale(0.005f);
                this.nextFlagNodes[i].location.add(this.usefulVector, this.nextFlagNodes[i].location);
            }
        }
        if (updated) {
            for (i = 0; i < this.flagMesh.length; ++i) {
                this.flagMesh[i].updateNormal();
            }
            this.computeNodeNormals();
            this.flagGeomtry.setCoordinates(0, this.flagData);
            this.flagGeomtry.setNormals(0, this.flagNormals);
        }
    }

    public void letGo(int index) {
        switch (index) {
            case 1: {
                this.flagNodes1[0].still = false;
                break;
            }
            case 2: {
                this.flagNodes1[15].still = false;
                break;
            }
            case 3: {
                this.flagNodes1[176].still = false;
                break;
            }
            case 4: {
                this.flagNodes1[191].still = false;
            }
        }
    }

    private Point3f getGridStart() {
        return new Point3f(10.0f, this.clothInitalHeight, 10.0f);
    }

    public Shape3D getBackGround() {
        return this.ground;
    }

    public Shape3D getFlag() {
        return this.flag;
    }

    public void switchFillWire() {
        boolean bl = this.wireMesh = !this.wireMesh;
        if (this.wireMesh) {
            this.polygonAttributes.setDrawMode(DrawMode.LINE);
        } else {
            this.polygonAttributes.setDrawMode(DrawMode.FILL);
        }
    }

    public void resetFlag() {
        int i;
        int j;
        for (int j2 = 0; j2 < 12; ++j2) {
            for (int i2 = 0; i2 < 16; ++i2) {
                if (this.flagNodes1[j2 * 16 + i2] == null) {
                    this.flagNodes1[j2 * 16 + i2] = new FlagNode();
                }
                this.flagNodes1[j2 * 16 + i2].location.set(this.gridStart.getX() + this.springLength * (float)i2, this.gridStart.getY() - this.springLength * (float)j2, this.gridStart.getZ());
                this.flagNodes1[j2 * 16 + i2].velocity.set(0.0f, 0.0f, 0.0f);
                this.flagNodes1[j2 * 16 + i2].still = false;
            }
        }
        this.flagNodes1[0].still = true;
        this.flagNodes1[176].still = true;
        System.arraycopy(this.flagNodes1, 0, this.flagNodes2, 0, this.numberOfNodes);
        this.currentFlagNodes = this.flagNodes1;
        this.nextFlagNodes = this.flagNodes2;
        if (this.springs[0] != null) {
            return;
        }
        int springProgress = 0;
        for (j = 0; j < 12; ++j) {
            for (i = 0; i < 15; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 16 + i;
                this.springs[springProgress].secondNode = j * 16 + i + 1;
                this.springs[springProgress].naturalLength = this.springLength;
                ++springProgress;
            }
        }
        for (j = 0; j < 11; ++j) {
            for (i = 0; i < 16; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 16 + i;
                this.springs[springProgress].secondNode = (j + 1) * 16 + i;
                this.springs[springProgress].naturalLength = this.springLength;
                ++springProgress;
            }
        }
        for (j = 0; j < 11; ++j) {
            for (i = 0; i < 15; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 16 + i;
                this.springs[springProgress].secondNode = (j + 1) * 16 + i + 1;
                this.springs[springProgress].naturalLength = this.springLength * FastMath.sqrt(2.0f);
                ++springProgress;
            }
        }
        for (j = 0; j < 11; ++j) {
            for (i = 1; i < 16; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 16 + i;
                this.springs[springProgress].secondNode = (j + 1) * 16 + i - 1;
                this.springs[springProgress].naturalLength = this.springLength * FastMath.sqrt(2.0f);
                ++springProgress;
            }
        }
        for (j = 0; j < 12; ++j) {
            for (i = 0; i < 14; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 16 + i;
                this.springs[springProgress].secondNode = j * 16 + i + 2;
                this.springs[springProgress].naturalLength = this.springLength * 2.0f;
                ++springProgress;
            }
        }
        for (j = 0; j < 10; ++j) {
            for (i = 0; i < 16; ++i) {
                this.springs[springProgress] = new Spring();
                this.springs[springProgress].firstNode = j * 16 + i;
                this.springs[springProgress].secondNode = (j + 2) * 16 + i;
                this.springs[springProgress].naturalLength = this.springLength * 2.0f;
                ++springProgress;
            }
        }
    }

    private void makeBackGround(Texture backgroundTex) {
        float scaleWidth = 45.0f;
        float scaleHeight = 40.0f;
        TriangleStripArray groundGeometry = new TriangleStripArray(4);
        Appearance groundAppearance = new Appearance();
        TexCoord2f[] textureCoordinates = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(1.0f, 1.0f)};
        Tuple3f[] vertices = new Point3f[]{new Point3f(-scaleWidth, -scaleHeight, 0.0f), new Point3f(scaleWidth, -scaleHeight, 0.0f), new Point3f(-scaleWidth, scaleHeight, 0.0f), new Point3f(scaleWidth, scaleHeight, 0.0f)};
        groundAppearance.setTexture(backgroundTex);
        groundGeometry.setCoordinates(0, vertices);
        groundGeometry.setTextureCoordinates(0, 0, textureCoordinates);
        this.ground = new Shape3D(groundGeometry, groundAppearance);
    }

    private void makeFlag(Texture flagTex) {
        int[] strips = new int[11];
        TexCoord2f[] textureData = new TexCoord2f[this.numberOfNodes];
        for (int i = 0; i < strips.length; ++i) {
            strips[i] = 32;
        }
        this.flagMesh = new Triangle[330];
        this.flagData = new Point3f[2 * (this.numberOfNodes - 16)];
        this.flagNormals = new Vector3f[2 * (this.numberOfNodes - 16)];
        this.flagGeomtry = new TriangleStripArray(this.flagData.length, strips);
        this.computeNodeNormals();
        for (int j = 0; j < 12; ++j) {
            for (int i = 0; i < 16; ++i) {
                textureData[j * 16 + i] = new TexCoord2f((float)i / 16.0f, 1.0f - (float)j / 12.0f);
            }
        }
        int progress = 0;
        int meshProgress = 0;
        for (int a = 0; a < 11; ++a) {
            for (int i = 0; i < 16; ++i) {
                this.flagData[progress + 0] = this.flagNodes1[(a + 0) * 16 + i].location;
                this.flagData[progress + 1] = this.flagNodes1[(a + 1) * 16 + i].location;
                this.flagNormals[progress + 0] = this.flagNodes1[(a + 0) * 16 + i].normal;
                this.flagNormals[progress + 1] = this.flagNodes1[(a + 1) * 16 + i].normal;
                this.flagGeomtry.setTextureCoordinate(0, progress + 0, textureData[(a + 0) * 16 + i]);
                this.flagGeomtry.setTextureCoordinate(0, progress + 1, textureData[(a + 1) * 16 + i]);
                if (i != 15) {
                    this.flagMesh[meshProgress++] = new Triangle(this.flagNodes1[(a + 0) * 16 + i + 0], this.flagNodes1[(a + 1) * 16 + i + 0], this.flagNodes1[(a + 0) * 16 + i + 1]);
                    this.flagMesh[meshProgress++] = new Triangle(this.flagNodes1[(a + 1) * 16 + i + 0], this.flagNodes1[(a + 1) * 16 + i + 1], this.flagNodes1[(a + 0) * 16 + i + 1]);
                }
                progress += 2;
            }
        }
        this.flagGeomtry.setCoordinates(0, this.flagData);
        this.flagGeomtry.setNormals(0, this.flagNormals);
        this.polygonAttributes = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_NONE);
        this.flagAppearance.setTexture(flagTex);
        this.flagAppearance.setPolygonAttributes(this.polygonAttributes);
        Material material = new Material(Colorf.GRAY80, Colorf.GRAY80, Colorf.GRAY20, Colorf.GRAY60, 20.0f);
        material.setLightingEnabled(this.lightingOn);
        this.flagAppearance.setMaterial(material);
        this.flag = new Shape3D(this.flagGeomtry, this.flagAppearance);
    }

    public FlagFactory(Texture backgroundTex, Texture flagTex) {
        this.numberOfSprings += 176;
        this.numberOfSprings += 165;
        this.numberOfSprings += 165;
        this.numberOfSprings += 168;
        this.numberOfSprings += 160;
        this.flagNodes1 = new FlagNode[this.numberOfNodes];
        this.flagNodes2 = new FlagNode[this.numberOfNodes];
        this.springs = new Spring[this.numberOfSprings];
        this.resetFlag();
        this.makeBackGround(backgroundTex);
        this.makeFlag(flagTex);
    }

    public FlagFactory(String backgroundTex, String flagTex) {
        this(TextureLoader.getInstance().getTexture(backgroundTex), TextureLoader.getInstance().getTexture(flagTex));
    }

    private class Spring {
        float tension = 0.0f;
        float naturalLength = 0.0f;
        int firstNode = 0;
        int secondNode = 0;

        Spring() {
        }
    }

    private class FlagNode {
        Vector3f velocity = new Vector3f();
        Vector3f normal = new Vector3f();
        Vector3f force = new Vector3f();
        Point3f location = new Point3f();
        boolean still = false;

        FlagNode() {
        }

        public void resetForce() {
            this.force.set(0.0f, 0.0f, 0.0f);
        }
    }

    private class Triangle {
        FlagNode flagNode0 = null;
        FlagNode flagNode1 = null;
        FlagNode flagNode2 = null;
        Vector3f normal = new Vector3f();
        Vector3f tool = new Vector3f();
        Point3f p0 = null;
        Point3f p1 = null;
        Point3f p2 = null;

        Triangle(FlagNode cn0, FlagNode cn1, FlagNode cn2) {
            this.flagNode0 = cn0;
            this.flagNode1 = cn1;
            this.flagNode2 = cn2;
            this.p0 = this.flagNode0.location;
            this.p1 = this.flagNode1.location;
            this.p2 = this.flagNode2.location;
            this.updateNormal();
        }

        public void updateNormal() {
            this.tool.sub(this.p1, this.p0);
            this.normal.sub(this.p2, this.p0);
            this.normal.cross(this.tool, this.normal);
        }

        public void addForce(Tuple3f force) {
            this.flagNode0.force.add(force);
            this.flagNode1.force.add(force);
            this.flagNode2.force.add(force);
        }
    }
}

