/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.utils;

import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.FastMath;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureCubeMap;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.texturing.CubeTextureSet;

public class RippleFactory
implements Updatable {
    private IndexedTriangleArray waterGeomtry = null;
    private PolygonAttributes polygonAttributes = null;
    private TextureAttributes textureAttributes = new TextureAttributes();
    private Appearance waterAppearance = new Appearance();
    private Transform3D textureTransform = new Transform3D();
    private WaterNode[] waterNodes = null;
    private Vector3f[] waterNormals = null;
    private Point3f[] waterData = null;
    private Shape3D waterSurface = new Shape3D();
    private boolean wireMesh = false;
    private boolean rippleCreatorActive = true;
    private float tileSize = 80.0f;
    private float dampFactor = 0.95f;
    private float rotationAngle = 0.0f;
    private int gridWidth = 80;
    private int gridHeight = 80;
    private int numberOfNodes = 0;
    private View view = null;
    private Matrix4f tmpMatrix = new Matrix4f();
    private float timePrecision;
    private float timeSinceLastUpdate = this.timePrecision = 0.04f;

    public RippleFactory(int width, int height, CubeTextureSet cts, View view) {
        this.gridWidth = width;
        this.gridHeight = height;
        this.view = view;
        this.numberOfNodes = this.gridHeight * this.gridWidth;
        this.waterNodes = new WaterNode[this.numberOfNodes];
        this.resetWater();
        this.createWater(cts);
    }

    public void resetWater() {
        for (int j = 0; j < this.gridHeight; ++j) {
            for (int i = 0; i < this.gridWidth; ++i) {
                if (this.waterNodes[j * this.gridWidth + i] == null) {
                    this.waterNodes[j * this.gridWidth + i] = new WaterNode(((float)i - (float)this.gridWidth / 2.0f) / (float)this.gridWidth * 7.0f, 0.0f, ((float)j - (float)this.gridHeight / 2.0f) / (float)this.gridHeight * 7.0f);
                }
                this.waterNodes[j * this.gridWidth + i].reset();
            }
        }
    }

    private void createWater(CubeTextureSet cts) {
        int a;
        int[] indicies = new int[6 * (this.numberOfNodes - this.gridWidth)];
        this.waterData = new Point3f[this.numberOfNodes];
        this.waterNormals = new Vector3f[this.numberOfNodes];
        this.waterGeomtry = new IndexedTriangleArray(this.numberOfNodes, indicies.length);
        this.computeNodeNormals();
        int p = 0;
        for (a = 0; a < this.gridHeight - 1; ++a) {
            int i = 0;
            while (i < this.gridWidth - 1) {
                indicies[p + 0] = (a + 0) * this.gridWidth + i + 0;
                indicies[p + 1] = (a + 1) * this.gridWidth + i + 0;
                indicies[p + 2] = (a + 0) * this.gridWidth + i + 1;
                indicies[p + 3] = (a + 1) * this.gridWidth + i + 1;
                indicies[p + 4] = (a + 0) * this.gridWidth + i + 1;
                indicies[p + 5] = (a + 1) * this.gridWidth + i + 0;
                ++i;
                p += 6;
            }
        }
        for (a = 0; a < this.gridHeight; ++a) {
            for (int i = 0; i < this.gridWidth; ++i) {
                this.waterData[a * this.gridWidth + i] = this.waterNodes[a * this.gridWidth + i].vertex;
                this.waterNormals[a * this.gridWidth + i] = this.waterNodes[a * this.gridWidth + i].normal;
            }
        }
        this.waterGeomtry.setValidIndexCount(indicies.length);
        this.waterGeomtry.setCoordinates(0, this.waterData);
        this.waterGeomtry.setNormals(0, this.waterNormals);
        this.waterGeomtry.setIndex(indicies);
        this.polygonAttributes = new PolygonAttributes(PolygonAttributes.POLYGON_FILL, PolygonAttributes.CULL_BACK, 0.0f);
        this.textureAttributes.setTextureMode(TextureAttributes.MODULATE);
        TexCoordGeneration texCoordGeneration = new TexCoordGeneration(TexCoordGeneration.REFLECTION_MAP, TexCoordGeneration.TEXTURE_COORDINATE_3);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setDepthBufferEnabled(true);
        renderingAttributes.setDepthTestFunction(RenderingAttributes.LESS);
        TextureCubeMap tcm = new TextureCubeMap(TextureFormat.RGB, 0, cts);
        this.waterAppearance.setTexture(tcm);
        this.waterAppearance.setTextureAttributes(this.textureAttributes);
        this.waterAppearance.setPolygonAttributes(this.polygonAttributes);
        this.waterAppearance.setTexCoordGeneration(texCoordGeneration);
        this.waterSurface.setAppearance(this.waterAppearance);
        this.waterSurface.setGeometry(this.waterGeomtry);
    }

    public void updateLogic() {
        int i;
        int j;
        this.rotationAngle += 0.01f;
        if (this.rotationAngle > (float)Math.PI * 2) {
            this.rotationAngle = 0.0f;
        }
        if (this.rippleCreatorActive) {
            float computeCosOnce = FastMath.cos(this.rotationAngle * 2.0f);
            this.createRipple(4 + (int)((float)(this.gridWidth - 6) * (FastMath.sin(this.rotationAngle) * computeCosOnce)), 4 + (int)((float)(this.gridHeight - 6) * (FastMath.cos(this.rotationAngle) * computeCosOnce)));
        }
        for (j = 2; j < this.gridHeight - 2; ++j) {
            for (i = 2; i < this.gridWidth - 2; ++i) {
                this.waterNodes[j * this.gridWidth + i].velocity += (this.waterNodes[j * this.gridWidth + i].location - (4.0f * (this.waterNodes[(j - 1) * this.gridWidth + i + 0].location + this.waterNodes[(j + 1) * this.gridWidth + i + 0].location + this.waterNodes[(j + 0) * this.gridWidth + i - 1].location + this.waterNodes[(j + 0) * this.gridWidth + i + 1].location) + this.waterNodes[(j - 1) * this.gridWidth + i - 1].location + this.waterNodes[(j + 1) * this.gridWidth + i - 1].location + this.waterNodes[(j - 1) * this.gridWidth + i + 1].location + this.waterNodes[(j + 1) * this.gridWidth + i + 1].location) / 25.0f) / 7.0f;
            }
        }
        for (j = 2; j < this.gridHeight - 2; ++j) {
            for (i = 2; i < this.gridWidth - 2; ++i) {
                this.waterNodes[j * this.gridWidth + i].updateVelocityLocation();
            }
        }
        for (j = 0; j < this.gridHeight; ++j) {
            for (i = 0; i < this.gridWidth; ++i) {
                this.waterNodes[j * this.gridWidth + i].computeNewRippleValue();
            }
        }
    }

    private void computeNodeNormals() {
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.waterNodes[i].normal.set(0.0f, 0.0f, 0.0f);
        }
        Point3f p0 = null;
        Point3f p1 = null;
        Point3f p2 = null;
        Point3f p3 = null;
        Vector3f n0 = null;
        Vector3f n1 = null;
        Vector3f n2 = null;
        Vector3f n3 = null;
        Vector3f tool = new Vector3f();
        Vector3f normal = new Vector3f();
        for (int j = 0; j < this.gridHeight - 1; ++j) {
            for (int i = 0; i < this.gridWidth - 1; ++i) {
                p0 = this.waterNodes[(j + 0) * this.gridWidth + (i + 0)].vertex;
                p1 = this.waterNodes[(j + 0) * this.gridWidth + (i + 1)].vertex;
                p2 = this.waterNodes[(j + 1) * this.gridWidth + (i + 0)].vertex;
                p3 = this.waterNodes[(j + 1) * this.gridWidth + (i + 1)].vertex;
                n0 = this.waterNodes[(j + 0) * this.gridWidth + (i + 0)].normal;
                n1 = this.waterNodes[(j + 0) * this.gridWidth + (i + 1)].normal;
                n2 = this.waterNodes[(j + 1) * this.gridWidth + (i + 0)].normal;
                n3 = this.waterNodes[(j + 1) * this.gridWidth + (i + 1)].normal;
                tool.sub(p1, p0);
                normal.sub(p2, p0);
                normal.cross(normal, tool);
                n0.add(normal);
                n1.add(normal);
                n2.add(normal);
                tool.sub(p1, p2);
                normal.sub(p3, p2);
                normal.cross(normal, tool);
                n1.add(normal);
                n2.add(normal);
                n3.add(normal);
            }
        }
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.waterNodes[i].normal.normalize();
        }
    }

    public void updateGeometry(View view, boolean updated) {
        view.getTransform().get(this.tmpMatrix);
        this.tmpMatrix.transpose();
        this.tmpMatrix.invert();
        this.textureTransform.set(this.tmpMatrix);
        this.textureAttributes.setTextureTransform(this.textureTransform);
        if (updated) {
            this.computeNodeNormals();
            this.waterGeomtry.setCoordinates(0, this.waterData);
            this.waterGeomtry.setNormals(0, this.waterNormals);
        }
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        float timeInterval = timingMode.getSecondsAsFloat(frameTime);
        boolean updated = false;
        this.timeSinceLastUpdate += timeInterval;
        while (this.timeSinceLastUpdate >= this.timePrecision) {
            this.updateLogic();
            this.timeSinceLastUpdate -= this.timePrecision;
            updated = true;
        }
        this.updateGeometry(this.view, updated);
    }

    public void createRipple(int i, int j) {
        i = i + this.gridWidth - 2 >> 1;
        j = j + this.gridHeight - 2 >> 1;
        this.waterNodes[j * this.gridWidth + i].velocity = 1000.0f;
    }

    public void createRandomRipple() {
        this.createRipple((int)((Math.random() - Math.random()) * (double)this.gridWidth), (int)((Math.random() - Math.random()) * (double)this.gridHeight));
    }

    public void rippleCreatorState() {
        this.rippleCreatorActive = !this.rippleCreatorActive;
    }

    public Shape3D getWater() {
        return this.waterSurface;
    }

    public void switchFillWire() {
        boolean bl = this.wireMesh = !this.wireMesh;
        if (this.wireMesh) {
            this.polygonAttributes.setDrawMode(DrawMode.LINE);
        } else {
            this.polygonAttributes.setDrawMode(DrawMode.FILL);
        }
    }

    private class WaterNode {
        Point3f vertex;
        Vector3f normal;
        float velocity = 0.0f;
        float location = 0.0f;

        WaterNode(float x, float y, float z) {
            this.vertex = new Point3f(x, y, z);
            this.vertex.scale(RippleFactory.this.tileSize);
            this.normal = new Vector3f();
        }

        public void updateVelocityLocation() {
            this.location -= this.velocity;
            this.velocity *= RippleFactory.this.dampFactor;
        }

        public void reset() {
            this.velocity = 0.0f;
            this.location = 0.0f;
        }

        public void computeNewRippleValue() {
            this.vertex.setY(this.location / 512.0f / (float)RippleFactory.this.gridHeight * 3.0f);
            this.vertex.mulY(RippleFactory.this.tileSize);
        }
    }
}

