/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.utils.phong;

import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.demos.utils.phong.GeomGroup;
import org.xith3d.demos.utils.phong.ShapeFactory;
import org.xith3d.scenegraph.QuadArray;
import org.xith3d.scenegraph.TransformGroup;

public class Room
extends GeomGroup {
    public TransformGroup getRoom(float width, float height, float depth, float x, float y, float z) {
        Vector3f norm;
        int i;
        float halfWidth = width / 2.0f;
        float halfHeight = height / 2.0f;
        float halfDepth = depth / 2.0f;
        QuadArray ceilingGeometry = new QuadArray(4);
        QuadArray wallsGeometry = new QuadArray(16);
        QuadArray floorGeometry = new QuadArray(4);
        TexCoord3f[] texCoords = new TexCoord3f[]{new TexCoord3f(0.0f, 4.0f, 0.0f), new TexCoord3f(4.0f, 4.0f, 0.0f), new TexCoord3f(0.0f, 0.0f, 0.0f), new TexCoord3f(4.0f, 0.0f, 0.0f)};
        Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f)};
        Point3f[] vertices = new Point3f[]{new Point3f(-halfWidth + x, halfHeight + y, halfDepth + z), new Point3f(halfWidth + x, halfHeight + y, halfDepth + z), new Point3f(halfWidth + x, halfHeight + y, -halfDepth + z), new Point3f(-halfWidth + x, halfHeight + y, -halfDepth + z), new Point3f(-halfWidth + x, -halfHeight + y, halfDepth + z), new Point3f(halfWidth + x, -halfHeight + y, halfDepth + z), new Point3f(halfWidth + x, -halfHeight + y, -halfDepth + z), new Point3f(-halfWidth + x, -halfHeight + y, -halfDepth + z)};
        int[] vertexIndices = new int[]{7, 6, 2, 3, 5, 4, 0, 1, 4, 7, 3, 0, 6, 5, 1, 2, 3, 2, 1, 0, 4, 5, 6, 7};
        int[] normalIndices = new int[]{4, 4, 4, 4, 5, 5, 5, 5, 2, 2, 2, 2, 3, 3, 3, 3, 1, 1, 1, 1, 0, 0, 0, 0};
        int[] tangentIndices = new int[]{2, 2, 2, 2, 3, 3, 3, 3, 5, 5, 5, 5, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2};
        int[] binormalIndices = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4};
        int[] texCoordIndices = new int[]{2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0};
        for (i = 0; i < 16; ++i) {
            wallsGeometry.setNormal(i, normals[normalIndices[i]]);
            wallsGeometry.setCoordinate(i, vertices[vertexIndices[i]]);
            wallsGeometry.setTextureCoordinate(0, i, texCoords[texCoordIndices[i]]);
            norm = normals[tangentIndices[i]];
            wallsGeometry.setTextureCoordinate(1, i, new TexCoord3f(norm.getX(), norm.getY(), norm.getZ()));
            norm = normals[binormalIndices[i]];
            wallsGeometry.setTextureCoordinate(2, i, new TexCoord3f(norm.getX(), norm.getY(), norm.getZ()));
        }
        for (i = 16; i < 20; ++i) {
            ceilingGeometry.setNormal(i - 16, normals[normalIndices[i]]);
            ceilingGeometry.setCoordinate(i - 16, vertices[vertexIndices[i]]);
            ceilingGeometry.setTextureCoordinate(0, i - 16, texCoords[texCoordIndices[i]]);
            norm = normals[tangentIndices[i]];
            ceilingGeometry.setTextureCoordinate(1, i - 16, new TexCoord3f(norm.getX(), norm.getY(), norm.getZ()));
            norm = normals[binormalIndices[i]];
            ceilingGeometry.setTextureCoordinate(2, i - 16, new TexCoord3f(norm.getX(), norm.getY(), norm.getZ()));
        }
        for (i = 20; i < 24; ++i) {
            floorGeometry.setNormal(i - 20, normals[normalIndices[i]]);
            floorGeometry.setCoordinate(i - 20, vertices[vertexIndices[i]]);
            floorGeometry.setTextureCoordinate(0, i - 20, texCoords[texCoordIndices[i]]);
            norm = normals[tangentIndices[i]];
            floorGeometry.setTextureCoordinate(1, i - 20, new TexCoord3f(norm.getX(), norm.getY(), norm.getZ()));
            norm = normals[binormalIndices[i]];
            floorGeometry.setTextureCoordinate(2, i - 20, new TexCoord3f(norm.getX(), norm.getY(), norm.getZ()));
        }
        this.parent.setTransform(this.transform);
        this.parent.addChild(ShapeFactory.getTexturedShape(wallsGeometry, "tilebase.jpg", "tiledot3.jpg", "tilegloss.png", 0.1f, 0.1f, 0.1f, 0.7f, 0.7f, 0.7f, 32));
        this.parent.addChild(ShapeFactory.getTexturedShape(floorGeometry, "woodbase.jpg", "wooddot3.jpg", "woodgloss.jpg", 0.1f, 0.1f, 0.1f, 1.0f, 1.0f, 1.0f, 8));
        this.parent.addChild(ShapeFactory.getTexturedShape(ceilingGeometry, "ceilingbase.jpg", "ceilingdot3.jpg", "white.png", 0.1f, 0.1f, 0.1f, 1.0f, 1.0f, 1.0f, 16));
        return this.parent;
    }
}

