/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.utils.phong;

import java.util.ArrayList;
import org.openmali.FastMath;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.xith3d.demos.utils.phong.GeomGroup;
import org.xith3d.demos.utils.phong.JCDModel;
import org.xith3d.demos.utils.phong.ParticlesManager;
import org.xith3d.demos.utils.phong.Room;
import org.xith3d.demos.utils.phong.ShapeFactory;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Group;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.View;

public class SceneManager
implements Updatable {
    private ParticlesManager particleSystem = null;
    private Group sceneGroup = new Group();
    private View view;
    private PointLight pointLight = null;
    private ArrayList<JCDModel> modelsList = new ArrayList();
    private boolean freezeScene = false;
    private Point3f lightEyeSpaceLocation = new Point3f(0.0f, 0.0f, 0.0f);
    private Room roomGroup = new Room();
    private float timePrecision = 0.04f;
    private float rotationAngle = 0.0f;
    private float timeSinceLastUpdate = 0.0f;
    private final float UPDATE_FREQUENCY_MICROS;

    public SceneManager(View view, long updateFrequency) {
        this.view = view;
        this.UPDATE_FREQUENCY_MICROS = updateFrequency;
    }

    public SceneManager(View view) {
        this(view, 500000L);
    }

    public Group getSceneGroup() {
        return this.sceneGroup;
    }

    public void loadParticleSystem(int numParticles, int effect, String tex, View view) {
        this.particleSystem = new ParticlesManager(numParticles, effect, view);
        this.sceneGroup.addChild(this.particleSystem.getParticles(tex));
    }

    public void loadLight() {
        this.pointLight = new PointLight(Colorf.WHITE, (Tuple3f)this.lightEyeSpaceLocation, (Tuple3f)new Point3f(1.0f, 0.0f, 0.001f));
        this.sceneGroup.addChild(this.pointLight);
    }

    public void loadRoom(float width, float height, float depth, float x, float y, float z) {
        this.sceneGroup.addChild(this.roomGroup.getRoom(width, height, depth, x, y, z));
    }

    public void loadModel(String filename, String basemap, String normalmap, String glossmap, Tuple3f specular, Tuple3f ambient, float scale, int shininess, float x, float y, float z) throws Exception {
        JCDModel loader = new JCDModel();
        this.sceneGroup.addChild(loader.getModel(filename, basemap, normalmap, glossmap, specular, ambient, scale, shininess));
        loader.translate(x, y, z);
        this.modelsList.add(loader);
    }

    public void setSceneState() {
        this.freezeScene = !this.freezeScene;
    }

    private void updateLightLocation(float t) {
        this.lightEyeSpaceLocation.setX(220.0f * FastMath.cos(4.25f * t));
        this.lightEyeSpaceLocation.setY(50.0f + 50.0f * FastMath.sin(2.25f * t) * FastMath.cos(1.75f * t));
        this.lightEyeSpaceLocation.setZ(220.0f * FastMath.sin(t * 3.25f));
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        float frameMicros = timingMode.getMicroSeconds(frameTime);
        float frameInterval = frameMicros / this.UPDATE_FREQUENCY_MICROS;
        Point3f cameraPosition = this.view.getPosition();
        boolean updated = false;
        this.timeSinceLastUpdate += frameInterval;
        while (this.timeSinceLastUpdate >= this.timePrecision) {
            this.timeSinceLastUpdate -= this.timePrecision;
            updated = true;
            if (!this.freezeScene) {
                this.updateLightLocation(this.rotationAngle += 0.0075f);
            }
            this.particleSystem.updateLogic(this.timePrecision);
        }
        if (updated && !this.freezeScene) {
            for (int i = this.modelsList.size() - 1; i > -1; --i) {
                ((GeomGroup)this.modelsList.get(i)).rotate(this.rotationAngle * 1.21f, this.rotationAngle * 3.12f);
            }
            this.pointLight.setLocation(this.lightEyeSpaceLocation);
            this.particleSystem.setParticlesOrigin(this.lightEyeSpaceLocation);
        }
        ShapeFactory.setShaderParameter(cameraPosition);
        this.particleSystem.updateGeometry();
    }
}

