/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.demos.utils.phong;

import org.openmali.FastMath;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;

public class TBNGenerator {
    private static int[] indices = null;
    private static int triNumber = 0;
    private static Point3f[] vertices = null;
    private static Vector3f[] normals = null;
    private static TexCoord3f[] tangents = null;
    private static TexCoord3f[] binormals = null;
    private static TexCoord3f[] texCoords = null;
    private static Vector3f binormal = new Vector3f();
    private static Vector3f tangent = new Vector3f();
    private static Vector3f normal = new Vector3f();

    public static void generateTBN(int[] ind, Point3f[] ver, Vector3f[] nor, TexCoord3f[] tan, TexCoord3f[] bin, TexCoord3f[] tex) {
        triNumber = ind.length / 3;
        normals = nor;
        indices = ind;
        vertices = ver;
        tangents = tan;
        binormals = bin;
        texCoords = tex;
        TBNGenerator.createTriangles();
    }

    private static void createTriangles() {
        int i;
        TriangleStructure[] triStructures = new TriangleStructure[triNumber];
        for (int i2 = 0; i2 < triNumber; ++i2) {
            triStructures[i2] = new TriangleStructure(indices[i2 * 3 + 0], indices[i2 * 3 + 1], indices[i2 * 3 + 2]);
        }
        Vector3f tempNormal = new Vector3f();
        Vector3f tempTangent = new Vector3f();
        Vector3f tempBinormal = new Vector3f();
        int index = 0;
        for (i = 0; i < triNumber; ++i) {
            for (int j = 0; j < 3; ++j) {
                index = triStructures[i].TSIndices[j];
                if (tangents[index] == null) {
                    normals[index].set(0.0f, 0.0f, 0.0f);
                    TBNGenerator.tangents[index] = new TexCoord3f();
                    TBNGenerator.binormals[index] = new TexCoord3f();
                }
                triStructures[i].TBNMatrices[j].getColumn(0, tempTangent);
                triStructures[i].TBNMatrices[j].getColumn(1, tempBinormal);
                triStructures[i].TBNMatrices[j].getColumn(2, tempNormal);
                normals[index].add(tempNormal);
                tangents[index].add(tempTangent.getX(), tempTangent.getY(), tempTangent.getZ());
                binormals[index].add(tempBinormal.getX(), tempBinormal.getY(), tempBinormal.getZ());
            }
        }
        for (i = 0; i < tangents.length; ++i) {
            TBNGenerator.normalize(binormals[i]);
            TBNGenerator.normalize(tangents[i]);
            TBNGenerator.normalize(normals[i]);
        }
    }

    private static void normalize(Tuple3f v) {
        float length = FastMath.sqrt(v.getX() * v.getX() + v.getY() * v.getY() + v.getZ() * v.getZ());
        if (length <= 1.0E-5f) {
            return;
        }
        v.div(length);
        if (v.getX() == Float.NaN || v.getY() == Float.NaN || v.getZ() == Float.NaN) {
            v.set(0.0f, 0.0f, 0.0f);
        }
    }

    private static void normalize(TexCoord3f v) {
        float length = FastMath.sqrt(v.getS() * v.getS() + v.getT() * v.getT() + v.getP() * v.getP());
        if (length <= 1.0E-5f) {
            return;
        }
        v.div(length, length, length);
        if (v.getS() == Float.NaN || v.getT() == Float.NaN || v.getP() == Float.NaN) {
            v.set(0.0f, 0.0f, 0.0f);
        }
    }

    private static class TriangleStructure {
        int[] TSIndices = new int[]{-1, -1, -1};
        Matrix3f[] TBNMatrices = new Matrix3f[]{new Matrix3f(), new Matrix3f(), new Matrix3f()};

        TriangleStructure(int i1, int i2, int i3) {
            this.TSIndices[0] = i1;
            this.TSIndices[1] = i2;
            this.TSIndices[2] = i3;
            this.makeTBNMatricies();
        }

        public void makeTBNMatricies() {
            tangent.set(vertices[this.TSIndices[1]].getX() - vertices[this.TSIndices[0]].getX(), texCoords[this.TSIndices[1]].getS() - texCoords[this.TSIndices[0]].getS(), texCoords[this.TSIndices[1]].getT() - texCoords[this.TSIndices[0]].getT());
            binormal.set(vertices[this.TSIndices[2]].getX() - vertices[this.TSIndices[0]].getX(), texCoords[this.TSIndices[2]].getS() - texCoords[this.TSIndices[0]].getS(), texCoords[this.TSIndices[2]].getT() - texCoords[this.TSIndices[0]].getT());
            normal.cross(tangent, binormal);
            if (normal.getX() != 0.0f) {
                normal.normalize();
                this.TBNMatrices[0].sub(0, 0, normal.getY() / normal.getX());
                this.TBNMatrices[0].sub(1, 0, normal.getZ() / normal.getX());
                this.TBNMatrices[1].sub(0, 0, normal.getY() / normal.getX());
                this.TBNMatrices[1].sub(1, 0, normal.getZ() / normal.getX());
                this.TBNMatrices[2].sub(0, 0, normal.getY() / normal.getX());
                this.TBNMatrices[2].sub(1, 0, normal.getZ() / normal.getX());
            }
            tangent.set(vertices[this.TSIndices[1]].getY() - vertices[this.TSIndices[0]].getY(), texCoords[this.TSIndices[1]].getS() - texCoords[this.TSIndices[0]].getS(), texCoords[this.TSIndices[1]].getT() - texCoords[this.TSIndices[0]].getT());
            binormal.set(vertices[this.TSIndices[2]].getY() - vertices[this.TSIndices[0]].getY(), texCoords[this.TSIndices[2]].getS() - texCoords[this.TSIndices[0]].getS(), texCoords[this.TSIndices[2]].getT() - texCoords[this.TSIndices[0]].getT());
            normal.cross(tangent, binormal);
            if (normal.getX() != 0.0f) {
                normal.normalize();
                this.TBNMatrices[0].sub(0, 1, normal.getY() / normal.getX());
                this.TBNMatrices[0].sub(1, 1, normal.getZ() / normal.getX());
                this.TBNMatrices[1].sub(0, 1, normal.getY() / normal.getX());
                this.TBNMatrices[1].sub(1, 1, normal.getZ() / normal.getX());
                this.TBNMatrices[2].sub(0, 1, normal.getY() / normal.getX());
                this.TBNMatrices[2].sub(1, 1, normal.getZ() / normal.getX());
            }
            tangent.set(vertices[this.TSIndices[1]].getZ() - vertices[this.TSIndices[0]].getZ(), texCoords[this.TSIndices[1]].getS() - texCoords[this.TSIndices[0]].getS(), texCoords[this.TSIndices[1]].getT() - texCoords[this.TSIndices[0]].getT());
            binormal.set(vertices[this.TSIndices[2]].getZ() - vertices[this.TSIndices[0]].getZ(), texCoords[this.TSIndices[2]].getS() - texCoords[this.TSIndices[0]].getS(), texCoords[this.TSIndices[2]].getT() - texCoords[this.TSIndices[0]].getT());
            normal.cross(tangent, binormal);
            if (normal.getX() != 0.0f) {
                normal.normalize();
                this.TBNMatrices[0].sub(0, 2, normal.getY() / normal.getX());
                this.TBNMatrices[0].sub(1, 2, normal.getZ() / normal.getX());
                this.TBNMatrices[1].sub(0, 2, normal.getY() / normal.getX());
                this.TBNMatrices[1].sub(1, 2, normal.getZ() / normal.getX());
                this.TBNMatrices[2].sub(0, 2, normal.getY() / normal.getX());
                this.TBNMatrices[2].sub(1, 2, normal.getZ() / normal.getX());
            }
            this.processMatrices(this.TSIndices[0], 0);
            this.processMatrices(this.TSIndices[1], 1);
            this.processMatrices(this.TSIndices[2], 2);
        }

        private void processMatrices(int index1, int index2) {
            this.TBNMatrices[index2].getRow(0, tangent);
            this.TBNMatrices[index2].getRow(1, binormal);
            tangent.normalize();
            binormal.normalize();
            binormal.negate();
            normal.cross(tangent, binormal);
            if (normal.dot(normals[index1]) < 0.0f) {
                normal.negate();
            }
            this.TBNMatrices[index2].setColumn(0, tangent);
            this.TBNMatrices[index2].setColumn(1, binormal);
            this.TBNMatrices[index2].setColumn(2, normal);
        }
    }
}

