/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects;

import org.xith3d.effects.atmosphere.AtmosphereFactory;
import org.xith3d.effects.atmosphere.GLSLAtmosphereFactory;
import org.xith3d.effects.bloom.BloomFactory;
import org.xith3d.effects.bloom.GLSLBloomFactory;
import org.xith3d.effects.bumpmapping.BumpMappingFactory;
import org.xith3d.effects.bumpmapping.GLSLBumpMappingFactory;
import org.xith3d.effects.celshading.AssemblyCelShadingFactory;
import org.xith3d.effects.celshading.CelShadingFactory;
import org.xith3d.effects.shadows.GLSLShadowMappingFactory;
import org.xith3d.effects.shadows.ShadowFactory;
import org.xith3d.effects.textureprojection.FixedFuncTextureProjectionFectory;
import org.xith3d.effects.textureprojection.TextureProjectionFactory;

public class EffectFactory {
    private static EffectFactory INSTANCE = new EffectFactory();
    private BumpMappingFactory bumpMappingFactory = null;
    private CelShadingFactory celShadingFactory = null;
    private TextureProjectionFactory texProjFactory = null;
    private ShadowFactory shadowFactory = null;
    private AtmosphereFactory atmosphereFactory = null;
    private BloomFactory bloomFactory = null;

    public static final void setInstance(EffectFactory factory) {
        INSTANCE = factory;
    }

    public static final EffectFactory getInstance() {
        return INSTANCE;
    }

    public void registerBumpMappingFactory(BumpMappingFactory factory) {
        this.bumpMappingFactory = factory;
    }

    public final BumpMappingFactory getBumpMappingFactory() {
        return this.bumpMappingFactory;
    }

    public void registerCelShadingFactory(CelShadingFactory factory) {
        this.celShadingFactory = factory;
    }

    public final CelShadingFactory getCelShadingFactory() {
        return this.celShadingFactory;
    }

    public void registerTextureProjectionFactory(TextureProjectionFactory factory) {
        this.texProjFactory = factory;
    }

    public final TextureProjectionFactory getTextureProjectionFactory() {
        return this.texProjFactory;
    }

    public void registerShadowFactory(ShadowFactory factory) {
        this.shadowFactory = factory;
    }

    public final ShadowFactory getShadowFactory() {
        return this.shadowFactory;
    }

    public void registerAtmosphereFactory(AtmosphereFactory factory) {
        this.atmosphereFactory = factory;
    }

    public AtmosphereFactory getAtmosphereFactory() {
        return this.atmosphereFactory;
    }

    public void registerBloomFactory(BloomFactory factory) {
        this.bloomFactory = factory;
    }

    public BloomFactory getBloomFactory() {
        return this.bloomFactory;
    }

    public EffectFactory() {
        this.registerBumpMappingFactory(new GLSLBumpMappingFactory());
        this.registerCelShadingFactory(new AssemblyCelShadingFactory());
        this.registerTextureProjectionFactory(new FixedFuncTextureProjectionFectory());
        this.registerShadowFactory(new GLSLShadowMappingFactory());
        this.registerAtmosphereFactory(new GLSLAtmosphereFactory());
        this.registerBloomFactory(new GLSLBloomFactory());
    }
}

