/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.effects.bumpmapping;

import java.io.IOException;
import java.net.URL;
import org.xith3d.effects.bumpmapping.BumpMappingFactory;
import org.xith3d.loaders.shaders.impl.assembly.AssemblyShaderLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.AssemblyFragmentShader;
import org.xith3d.scenegraph.AssemblyShaderProgram;
import org.xith3d.scenegraph.AssemblyShaderProgramContext;
import org.xith3d.scenegraph.AssemblyVertexShader;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture;
import org.xith3d.utility.geometry.TangentsFactory;

public class AssemblyBumpMappingFactory
extends BumpMappingFactory {
    private static AssemblyVertexShader vertexProgram = null;
    private static AssemblyFragmentShader fragmentProgram = null;

    public AssemblyVertexShader getVertexProgram() throws IOException {
        if (vertexProgram != null) {
            return vertexProgram;
        }
        ClassLoader loader = AssemblyBumpMappingFactory.class.getClassLoader();
        URL url = loader.getResource("resources/org/xith3d/shaders/bumpmapping/shader.bumpmapping.assemblyvert");
        vertexProgram = AssemblyShaderLoader.getInstance().loadVertexShader(url);
        return vertexProgram;
    }

    public AssemblyFragmentShader getFragmentProgram() throws IOException {
        if (fragmentProgram != null) {
            return fragmentProgram;
        }
        ClassLoader loader = AssemblyBumpMappingFactory.class.getClassLoader();
        URL url = loader.getResource("resources/org/xith3d/shaders/bumpmapping/shader.bumpmapping.assemblyfrag");
        fragmentProgram = AssemblyShaderLoader.getInstance().loadFragmentShader(url);
        return fragmentProgram;
    }

    public void prepareForBumpMapping(Shape3D shape, Texture normalMapTex) throws IOException {
        AssemblyBumpMappingFactory.getTangentsFactory().calculateTangents(shape.getGeometry(), this.getTangentsStoreMode(), this.getStoreIndex1(), this.getStoreIndex2());
        if (this.getTangentsStoreMode() == TangentsFactory.TangentsStoreMode.VERTEX_ATTRIBUTES && shape.getGeometry().getOptimization() == Geometry.Optimization.USE_DISPLAY_LISTS) {
            shape.getGeometry().setOptimization(Geometry.Optimization.USE_VBOS);
        }
        Appearance app = shape.getAppearance(true);
        app.setTexture(this.getNormalMapTextureUnit(), normalMapTex);
        app.setShaderProgramContext(new AssemblyShaderProgramContext(new AssemblyShaderProgram(this.getVertexProgram(), this.getFragmentProgram())));
    }

    public AssemblyBumpMappingFactory() {
        this.setTangentsStoreMode(TangentsFactory.TangentsStoreMode.TEXTURE_COORDINATES);
    }
}

