/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.input;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.InputSystemException;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.handlers.InputHandler;
import org.jagatoo.input.listeners.MouseAdapter;
import org.jagatoo.input.managers.InputBindingsManager;
import org.openmali.FastMath;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.input.modules.orih.ORIHInputAction;
import org.xith3d.input.modules.orih.ORIHInputBindingsManager;
import org.xith3d.input.modules.orih.ORIHInputStatesManager;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.scenegraph.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectRotationInputHandler
extends InputHandler<ORIHInputAction> {
    private Transformable transTrg;
    private View view;
    private float rotX = 0.0f;
    private float rotY = 0.0f;
    private float mouseXSpeed = 1.0f;
    private float mouseYSpeed = -1.0f;
    private float discreteZoomStep = 0.5f;
    private int discreteZoomDelta = 0;
    private Vector3f tmpVec1 = new Vector3f();
    private Vector3f tmpVec2 = new Vector3f();
    private boolean isRotationScheduled = false;

    public final ORIHInputBindingsManager getBindingsManager() {
        return (ORIHInputBindingsManager)super.getBindingsManager();
    }

    @Override
    public final ORIHInputStatesManager getStatesManager() {
        return (ORIHInputStatesManager)super.getStatesManager();
    }

    public void setMouseSpeedX(float speedX) {
        this.mouseXSpeed = speedX;
    }

    public final float getMouseSpeedX() {
        return this.mouseXSpeed;
    }

    public void setMouseSpeedY(float speedY) {
        this.mouseYSpeed = speedY;
    }

    public final float getMouseSpeedY() {
        return this.mouseYSpeed;
    }

    public void setDiscreteZoomStep(float stepSize) {
        this.discreteZoomStep = stepSize;
    }

    public final float getDiscreteZoomStep() {
        return this.discreteZoomStep;
    }

    public void setTransformTarget(Transformable trans) {
        this.transTrg = trans;
        this.updateFromTransformable();
    }

    public Transformable getTransformTarget() {
        return this.transTrg;
    }

    public void setView(View view) {
        this.view = view;
    }

    public final View getView() {
        return this.view;
    }

    public void updateFromTransformable() {
        this.rotX = FastMath.asin(this.getTransformTarget().getTransform().getMatrix4f().m02());
        this.rotY = FastMath.asin(this.getTransformTarget().getTransform().getMatrix4f().m21());
    }

    public void updateTransformable() {
        this.getTransformTarget().getTransform().getTranslation(this.tmpVec1);
        this.getTransformTarget().getTransform().rotXYZ(this.rotY, this.rotX, 0.0f);
        this.getTransformTarget().getTransform().setTranslation(this.tmpVec1);
        this.getTransformTarget().setTransform(this.getTransformTarget().getTransform());
    }

    private final void limitEuler(Tuple3f euler) {
        euler.setX(euler.getX() % ((float)Math.PI * 2));
        euler.setY(euler.getY() % ((float)Math.PI * 2));
    }

    @Override
    public void update(long nanoSeconds, float seconds, long nanoFrame, float frameSeconds) throws InputSystemException {
        ORIHInputStatesManager statesManager;
        if (this.isKeyboardSuspended() && this.isMouseMovementSuspended()) {
            return;
        }
        if (this.isRotationScheduled && !this.isMouseMovementSuspended()) {
            this.updateTransformable();
            this.isRotationScheduled = false;
        }
        if (!this.isKeyboardSuspended() && (statesManager = this.getStatesManager()).isRotating()) {
            this.transTrg.getTransform().getEuler(this.tmpVec1);
            if (statesManager.isRotatingLeft()) {
                this.tmpVec1.addY(this.getMouseSpeedX() / 25.0f);
            }
            if (statesManager.isRotatingRight()) {
                this.tmpVec1.subY(this.getMouseSpeedY() / 25.0f);
            }
            if (statesManager.isRotatingUp()) {
                this.tmpVec1.addX(this.mouseYSpeed / 25.0f);
            }
            if (statesManager.isRotatingDown()) {
                this.tmpVec1.subX(this.mouseYSpeed / 25.0f);
            }
            this.limitEuler(this.tmpVec1);
            this.transTrg.getTransform().setEuler(this.tmpVec1);
            this.transTrg.setTransform(this.transTrg.getTransform());
        }
        if (this.discreteZoomDelta != 0) {
            float zoomDist = (float)this.discreteZoomDelta * this.discreteZoomStep;
            this.discreteZoomDelta = 0;
            if (this.view != null) {
                this.transTrg.getPosition(this.tmpVec1);
                this.view.getPosition(this.tmpVec2);
                this.tmpVec2.sub(this.tmpVec1);
                float len = this.tmpVec2.length();
                this.tmpVec2.normalize();
                zoomDist += len;
                zoomDist = Math.max(zoomDist, this.discreteZoomStep);
                this.tmpVec2.scale(zoomDist);
                this.tmpVec2.add(this.tmpVec1);
                this.view.setPosition(this.tmpVec2);
            }
        }
    }

    private final void checkDiscreteZoom(DeviceComponent comp) {
        ORIHInputAction action = (ORIHInputAction)this.getBindingsManager().getBoundAction(comp);
        if (action != null) {
            switch (action) {
                case DISCRETE_ZOOM_IN: {
                    --this.discreteZoomDelta;
                    break;
                }
                case DISCRETE_ZOOM_OUT: {
                    ++this.discreteZoomDelta;
                }
            }
        }
    }

    @Override
    public boolean setSuspendMask(int suspendMask) {
        boolean wasSuspended = this.isSuspended();
        if (super.setSuspendMask(suspendMask)) {
            if (wasSuspended && !this.isSuspended()) {
                this.updateFromTransformable();
            } else if (!wasSuspended && this.isSuspended()) {
                this.rotX = FastMath.asin(this.getTransformTarget().getTransform().getMatrix4f().m02());
                this.rotY = FastMath.asin(this.getTransformTarget().getTransform().getMatrix4f().m21());
            }
            return true;
        }
        return false;
    }

    @Override
    public void setInputSystem(InputSystem inputSystem) {
        super.setInputSystem(inputSystem);
        inputSystem.getMouse().addMouseListener(new MouseLstnr());
    }

    protected ORIHInputStatesManager createInputStatesManager(InputBindingsManager<ORIHInputAction> bindingsManager) {
        return new ORIHInputStatesManager(this);
    }

    public ObjectRotationInputHandler(Transformable transNode, float mouseXSpeed, float mouseYSpeed) {
        super(new ORIHInputBindingsManager());
        this.transTrg = transNode;
        this.mouseXSpeed = mouseXSpeed;
        this.mouseYSpeed = mouseYSpeed;
        this.rotX = FastMath.asin(transNode.getTransform().getMatrix4f().m02());
        this.rotY = FastMath.asin(transNode.getTransform().getMatrix4f().m21());
    }

    public ObjectRotationInputHandler(Transformable transNode) {
        this(transNode, 1.0f, -1.0f);
    }

    public ObjectRotationInputHandler(Transformable transNode, float mouseXSpeed, float mouseYSpeed, View view) {
        this(transNode, mouseXSpeed, mouseYSpeed);
        this.view = view;
    }

    public ObjectRotationInputHandler(Transformable transNode, View view) {
        this(transNode, 1.0f, -1.0f, view);
    }

    public static ObjectRotationInputHandler createDefault(Transformable transNode, float mouseXSpeed, float mouseYSpeed) {
        ObjectRotationInputHandler morih = new ObjectRotationInputHandler(transNode, mouseXSpeed, mouseYSpeed);
        morih.getBindingsManager().createDefaultBindings();
        return morih;
    }

    public static ObjectRotationInputHandler createDefault(Transformable transNode) {
        return ObjectRotationInputHandler.createDefault(transNode, 1.0f, -1.0f);
    }

    public static ObjectRotationInputHandler createDefault(Transformable transNode, float mouseXSpeed, float mouseYSpeed, View view) {
        ObjectRotationInputHandler morih = ObjectRotationInputHandler.createDefault(transNode, mouseXSpeed, mouseYSpeed);
        morih.setView(view);
        return morih;
    }

    public static ObjectRotationInputHandler createDefault(Transformable transNode, View view) {
        return ObjectRotationInputHandler.createDefault(transNode, 1.0f, -1.0f, view);
    }

    private class MouseLstnr
    extends MouseAdapter {
        private MouseLstnr() {
        }

        public void onMouseMoved(MouseMovedEvent e, int x, int y, int dx, int dy) {
            if (ObjectRotationInputHandler.this.isMouseMovementSuspended()) {
                return;
            }
            if (e.getMouse().getButtonsState() != 0) {
                ObjectRotationInputHandler.this.rotX += (float)dx / 150.0f * ObjectRotationInputHandler.this.getMouseSpeedX();
                ObjectRotationInputHandler.this.rotY += (float)dy / 150.0f * ObjectRotationInputHandler.this.getMouseSpeedY();
                ObjectRotationInputHandler.this.isRotationScheduled = true;
            }
        }

        public void onMouseWheelMoved(MouseWheelEvent e, int wheelDelta) {
            if (ObjectRotationInputHandler.this.isMouseWheelSuspended()) {
                return;
            }
            if (e.getWheelDelta() > 0) {
                ObjectRotationInputHandler.this.checkDiscreteZoom(MouseButtons.WHEEL_UP);
            } else if (e.getWheelDelta() < 0) {
                ObjectRotationInputHandler.this.checkDiscreteZoom(MouseButtons.WHEEL_DOWN);
            }
        }
    }
}

