/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.io;

import java.io.IOException;
import org.xith3d.io.Scribe;
import org.xith3d.io.ScribeInputStream;
import org.xith3d.io.ScribeOutputStream;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.scenegraph.TriangleStripArray;
import org.xith3d.utility.logging.X3DLog;

public class ScribeGeometryArray
extends Scribe {
    private static final int VERSION = 1;
    private static final int TYPE_TRIANGLE_ARRAY = 0;
    private static final int TYPE_TRIANGLE_STRIP_ARRAY = 1;

    public static void writeGeometryArray(ScribeOutputStream out, Geometry geom) throws IOException {
        int geomType;
        out.writeByte(1);
        if (geom instanceof TriangleArray) {
            geomType = 0;
        } else if (geom instanceof TriangleStripArray) {
            geomType = 1;
        } else {
            throw new Error("Cannot scribe geometry array type " + geom.getClass().getName());
        }
        int format = geom.getVertexFormat();
        int numUnits = geom.getNumTextureUnits();
        int[] unitMap = new int[numUnits];
        int vertexCount = geom.getVertexCount();
        geom.getTexCoordSetMap(unitMap);
        out.writeInt(1);
        out.writeInt(geomType);
        out.writeInt(format);
        out.writeInt(vertexCount);
        out.writeInt(numUnits);
        out.writeIntArray(unitMap);
        X3DLog.debug("  Writing out coordinates");
        float[] data = geom.getCoordinatesData().getData();
        out.writeFloatArray(data);
        if (geom.hasNormals()) {
            X3DLog.debug("  Writing out normals");
            data = geom.getNormalsData().getData();
            out.writeFloatArray(data);
        }
        if (geom.hasColors()) {
            X3DLog.debug("  Writing out color3");
            data = geom.getColorData().getData();
            out.writeFloatArray(data);
        }
        if (geom.hasTextureCoordinates()) {
            for (int j = 0; j < numUnits; ++j) {
                float[] data2 = geom.getTexCoordsData(unitMap[j]).getData();
                out.writeFloatArray(data2);
                X3DLog.debug("  Writing data of length ", data2.length);
                X3DLog.debug("  Writing out tex coords ", j);
                if (unitMap[j] != 1) continue;
                float maxu = 0.0f;
                for (int k = 0; k < data2.length; ++k) {
                    if (!(data2[k] > maxu)) continue;
                    maxu = data2[k];
                }
                X3DLog.debug("  Max U on tex 2 is ", Float.valueOf(maxu));
            }
        }
    }

    public static Geometry readGeometryArray(ScribeInputStream in) throws IOException {
        float[] data;
        in.readByte();
        int geomType = in.readInt();
        int format = in.readInt();
        int vertexCount = in.readInt();
        int numUnits = in.readInt();
        int[] unitMap = new int[numUnits];
        in.readIntArray(unitMap);
        TriangleArray geom = null;
        switch (geomType) {
            case 0: {
                geom = new TriangleArray(vertexCount);
            }
        }
        if ((1 & format) != 0) {
            data = in.readFloatArray();
            geom.setCoordinates(0, data);
        }
        if ((2 & format) != 0) {
            data = in.readFloatArray();
            geom.setNormals(0, data);
        }
        if ((4 & format) != 0) {
            data = in.readFloatArray();
            geom.setColors(0, 3, data);
        }
        if ((4 & format) != 0) {
            data = in.readFloatArray();
            geom.setColors(0, 4, data);
        }
        if ((8 & format) != 0) {
            X3DLog.debug("  Reading in ", numUnits, " sets of tex coords");
            for (int j = 0; j < numUnits; ++j) {
                float[] data2 = in.readFloatArray();
                X3DLog.debug("  Read data of length ", data2.length);
                geom.setTextureCoordinates(j, 0, 2, data2);
                float maxu = 0.0f;
                for (int k = 0; k < data2.length; ++k) {
                    if (!(data2[k] > maxu)) continue;
                    maxu = data2[k];
                }
                X3DLog.debug("  Max U on tex ", j, " is ", Float.valueOf(maxu));
            }
        }
        return geom;
    }
}

