/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.models.impl.cal3d;

import java.io.File;
import org.jagatoo.loaders.models.cal3d.buffer.TexCoord2fBuffer;
import org.jagatoo.loaders.models.cal3d.buffer.Vector3fBuffer;
import org.jagatoo.loaders.models.cal3d.core.CalCoreMaterial;
import org.jagatoo.loaders.models.cal3d.core.CalCoreSubmesh;
import org.jagatoo.loaders.models.cal3d.core.CalModel;
import org.jagatoo.loaders.models.cal3d.core.CalSubmesh;
import org.jagatoo.loaders.models.cal3d.util.BufferToArray;
import org.jagatoo.loaders.textures.locators.TextureStreamLocatorURL;
import org.openmali.vecmath2.Colorf;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.IndexedTriangleArray;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Texture2D;

public class Cal3dSubmesh
extends Shape3D {
    protected IndexedTriangleArray ta;
    protected CalSubmesh subMesh;
    private int oldNumVertices;

    public Cal3dSubmesh() {
        this("");
    }

    public Cal3dSubmesh(String name) {
        this.setName(name);
        this.setAppearance(new Appearance());
    }

    public Cal3dSubmesh(String name, CalSubmesh submesh) {
        this(name);
        this.subMesh = submesh;
        this.constructSubMesh();
    }

    public CalSubmesh getSubMesh() {
        return this.subMesh;
    }

    public void setSubMesh(CalSubmesh subMesh) {
        this.subMesh = subMesh;
        this.constructSubMesh();
    }

    private void constructSubMesh() {
        if (this.subMesh.hasInternalData()) {
            Vector3fBuffer vertexBuffer2 = new Vector3fBuffer(this.subMesh.getVertexCount());
            Vector3fBuffer normalBuffer2 = new Vector3fBuffer(this.subMesh.getVertexCount());
            this.ta = new IndexedTriangleArray(vertexBuffer2.length, this.subMesh.getFaceIndices().size());
            this.ta.setOptimization(Geometry.Optimization.NONE);
            this.setGeometry(this.ta);
            this.ta.setCoordinates(0, BufferToArray.array(vertexBuffer2.getBuffer()));
            this.ta.setNormals(0, BufferToArray.array(normalBuffer2.getBuffer()));
            this.ta.setIndex(this.subMesh.getFaceIndices().getBuffer());
        } else {
            int numVertices = this.subMesh.getCoreSubmesh().getVertexCount();
            Vector3fBuffer vertexBuffer2 = this.subMesh.getCoreSubmesh().getVertexPositions();
            Vector3fBuffer normalBuffer2 = this.subMesh.getCoreSubmesh().getVertexNormals();
            TexCoord2fBuffer[] textBuffer = this.subMesh.getCoreSubmesh().getTextureCoordinates();
            int[] faces = new int[this.subMesh.getCoreSubmesh().getFaceCount() * 3];
            int cc = 0;
            for (int p = 0; p < this.subMesh.getCoreSubmesh().getFaceCount(); ++p) {
                CalCoreSubmesh.Face aface = this.subMesh.getCoreSubmesh().getVectorFace()[p];
                faces[cc] = aface.vertexId[0];
                faces[++cc] = aface.vertexId[1];
                faces[++cc] = aface.vertexId[2];
                ++cc;
            }
            if (textBuffer == null || textBuffer.length == 0) {
                this.ta = new IndexedTriangleArray(vertexBuffer2.length, faces.length);
                this.ta.setOptimization(Geometry.Optimization.NONE);
                this.setGeometry(this.ta);
                this.ta.setCoordinates(0, BufferToArray.array(vertexBuffer2.getBuffer()));
                this.ta.setNormals(0, BufferToArray.array(normalBuffer2.getBuffer()));
                this.ta.setIndex(faces);
            } else {
                this.ta = new IndexedTriangleArray(vertexBuffer2.length, faces.length);
                this.ta.setOptimization(Geometry.Optimization.NONE);
                this.setGeometry(this.ta);
                this.ta.setCoordinates(0, BufferToArray.array(vertexBuffer2.getBuffer()));
                this.ta.setNormals(0, BufferToArray.array(normalBuffer2.getBuffer()));
                for (int i = 0; i < textBuffer.length; ++i) {
                    this.ta.setTextureCoordinates(i, 0, 2, BufferToArray.array(textBuffer[i].getBuffer()));
                }
                this.ta.setIndex(faces);
            }
        }
        CalCoreMaterial mat = this.subMesh.getCoreMaterial();
        if (mat != null) {
            Colorf ambient = mat.getAmbientColor();
            Colorf diffuse = mat.getDiffuseColor();
            Colorf specular = mat.getSpecularColor();
            float shine = mat.getShininess();
            Material mstate = new Material();
            mstate.setShininess(shine);
            mstate.setAmbientColor(ambient.getRed(), ambient.getGreen(), ambient.getBlue());
            mstate.setDiffuseColor(diffuse.getRed(), diffuse.getGreen(), diffuse.getBlue());
            mstate.setSpecularColor(specular.getRed(), specular.getGreen(), specular.getBlue());
            this.getAppearance().setMaterial(mstate);
            if (mat.getMapCount() > 0) {
                String filename = mat.getMapFilename(0);
                while (filename.startsWith("/")) {
                    filename = filename.substring(1);
                }
                System.err.println("[Cal3dSubmesh] Texture filename = " + filename);
                Texture2D tex = null;
                File f = new File(filename);
                if (f.exists()) {
                    tex = TextureLoader.getInstance().getTexture(filename);
                }
                if (tex == null) {
                    TextureStreamLocatorURL loc = new TextureStreamLocatorURL(mat.getBaseURL());
                    TextureLoader.getInstance().addTextureStreamLocator(loc);
                    tex = TextureLoader.getInstance().getTexture(filename);
                    TextureLoader.getInstance().removeTextureStreamLocator(loc);
                }
                this.getAppearance().setTexture(tex);
            }
        }
    }

    public void doUpdate(CalModel calModel) {
        if (this.subMesh.hasInternalData()) {
            Vector3fBuffer vertexBuffer2 = this.subMesh.getVertexPositions();
            Vector3fBuffer normalBuffer2 = this.subMesh.getVertexNormals();
            this.ta.setNormals(0, BufferToArray.array(normalBuffer2.getBuffer()));
            this.ta.setCoordinates(0, BufferToArray.array(vertexBuffer2.getBuffer()));
            this.setGeometry(this.ta);
            this.setBoundsDirty();
        } else {
            Vector3fBuffer vertexBuffer2 = new Vector3fBuffer(this.subMesh.getVertexCount());
            Vector3fBuffer normalBuffer2 = new Vector3fBuffer(this.subMesh.getVertexCount());
            int numVertices = calModel.getPhysique().calculateVertices(this.subMesh, vertexBuffer2);
            int numNormals = calModel.getPhysique().calculateNormals(this.subMesh, normalBuffer2);
            if (numVertices != this.oldNumVertices) {
                this.ta = new IndexedTriangleArray(numVertices, this.subMesh.getFaceIndices().size());
                this.ta.setOptimization(Geometry.Optimization.NONE);
                this.oldNumVertices = numVertices;
            }
            this.ta.setCoordinates(0, BufferToArray.array(vertexBuffer2.getBuffer()));
            this.ta.setNormals(0, BufferToArray.array(normalBuffer2.getBuffer()));
            this.ta.setIndex(this.subMesh.getFaceIndices().getBuffer());
            for (int i = 0; i < this.subMesh.getCoreSubmesh().getTextureCoordinates().length; ++i) {
                this.ta.setTextureCoordinates(i, 0, 2, BufferToArray.array(this.subMesh.getCoreSubmesh().getTextureCoordinates()[i].getBuffer()));
            }
            this.setGeometry(this.ta);
            this.setBoundsDirty();
        }
        this.ta.setBoundsDirty();
    }

    public Shape3D getShape3D(int flags) {
        IndexedTriangleArray geom = new IndexedTriangleArray(this.ta.getVertexCount(), this.ta.getIndex().length);
        this.ta.setOptimization(Geometry.Optimization.NONE);
        geom.setCoordinates(0, this.ta.getCoordRefFloat());
        geom.setNormals(0, this.ta.getNormalRefFloat());
        for (int i = 0; i < 8; ++i) {
            if (!this.ta.hasTextureCoordinates(i)) continue;
            geom.setTextureCoordinates(i, 0, 2, this.ta.getTexCoordRefFloat(i));
        }
        geom.setIndex(this.ta.getIndex());
        geom.calculateFaceNormals();
        Shape3D shape = new Shape3D(geom, this.getAppearance());
        return shape;
    }
}

