/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.shaders.impl.assembly;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.xith3d.loaders.shaders.base.ShaderLoader;
import org.xith3d.scenegraph.AssemblyFragmentShader;
import org.xith3d.scenegraph.AssemblyShader;
import org.xith3d.scenegraph.AssemblyVertexShader;
import org.xith3d.scenegraph.Shader;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssemblyShaderLoader
extends ShaderLoader<AssemblyShader> {
    private static final AssemblyShaderLoader instance = new AssemblyShaderLoader();

    @Override
    public AssemblyShader loadShader(Reader reader, Shader.ShaderType type) throws IOException {
        BufferedReader buffReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        AssemblyShader shader = null;
        StringBuffer shaderSource = new StringBuffer();
        try {
            String line;
            while ((line = buffReader.readLine()) != null) {
                shaderSource.append(line);
                shaderSource.append('\n');
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (shaderSource.length() == 0) {
            X3DLog.exception("failed to load shader \"...\"");
            return null;
        }
        shader = type == Shader.ShaderType.FRAGMENT ? new AssemblyFragmentShader(shaderSource.toString()) : new AssemblyVertexShader(shaderSource.toString());
        return shader;
    }

    @Override
    public AssemblyShader loadShader(InputStream in, Shader.ShaderType type) throws IOException {
        return this.loadShader(new InputStreamReader(in), type);
    }

    @Override
    public AssemblyShader loadShader(URL url, Shader.ShaderType type) throws IOException {
        AssemblyShader shader = this.loadShader(url.openStream(), type);
        return shader;
    }

    @Override
    public AssemblyShader loadShader(String name, Shader.ShaderType type) throws IOException {
        String cacheTag = (Object)((Object)type) + name;
        AssemblyShader shader = (AssemblyShader)this.getFromCache(cacheTag);
        if (shader != null) {
            return shader;
        }
        File shaderFile = new File(name);
        if (shaderFile.exists()) {
            shader = this.loadShader(new FileReader(name), type);
        } else if (this.getBaseURL() != null) {
            shader = this.loadShader(new URL(this.getBaseURL(), name).openStream(), type);
        } else if (this.getBasePath() != null) {
            shader = this.loadShader(new FileReader(new File(this.getBasePath(), name)), type);
        }
        if (shader == null) {
            X3DLog.exception("failed to load shader \"", name, "\"");
            return null;
        }
        this.cacheShader(cacheTag, shader);
        return shader;
    }

    public AssemblyVertexShader loadVertexShader(URL url) throws IOException {
        return (AssemblyVertexShader)this.loadShader(url, Shader.ShaderType.VERTEX);
    }

    public AssemblyVertexShader loadVertexShader(String name) throws IOException {
        return (AssemblyVertexShader)this.loadShader(name, Shader.ShaderType.VERTEX);
    }

    public AssemblyFragmentShader loadFragmentShader(URL url) throws IOException {
        return (AssemblyFragmentShader)this.loadShader(url, Shader.ShaderType.FRAGMENT);
    }

    public AssemblyFragmentShader loadFragmentShader(String name) throws IOException {
        return (AssemblyFragmentShader)this.loadShader(name, Shader.ShaderType.FRAGMENT);
    }

    @Override
    public AssemblyShader loadShaderFromString(String source, Shader.ShaderType typ) {
        if (typ == Shader.ShaderType.FRAGMENT) {
            return new AssemblyFragmentShader(source);
        }
        return new AssemblyVertexShader(source);
    }

    public AssemblyVertexShader loadVertexShaderFromString(String source) {
        return (AssemblyVertexShader)this.loadShaderFromString(source, Shader.ShaderType.VERTEX);
    }

    public AssemblyFragmentShader loadFragmentShaderFromString(String source) {
        return (AssemblyFragmentShader)this.loadShaderFromString(source, Shader.ShaderType.FRAGMENT);
    }

    public AssemblyShaderLoader(URL baseURL) {
        super(baseURL);
    }

    public AssemblyShaderLoader(String basePath) {
        super(basePath);
    }

    public AssemblyShaderLoader() {
    }

    public static AssemblyShaderLoader getInstance() {
        return instance;
    }
}

