/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.loaders.sound.impl.ogg;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.BufferedInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import org.jagatoo.util.nio.BufferUtils;
import org.xith3d.sound.BufferFormat;
import org.xith3d.sound.SoundBuffer;
import org.xith3d.sound.SoundContainer;
import org.xith3d.sound.SoundDriver;

public class OggSoundContainer
implements SoundContainer {
    private ByteBuffer bbuffer;
    private SoundBuffer buffer = null;
    private static final boolean needs_byte_swap = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private byte[] buf = null;
    private int bytes = 0;
    private static int bufferMultiple_ = 4;
    private static int bufferSize_ = bufferMultiple_ * 256 * 2 * 10;
    private static int convsize = bufferSize_ * 2;
    private byte[] convbuffer = new byte[convsize];
    private BufferedInputStream oggBitStream_;
    private SyncState oggSyncState_ = new SyncState();
    private StreamState oggStreamState_ = new StreamState();
    private Page oggPage_ = new Page();
    private Packet oggPacket_ = new Packet();
    private Info vorbisInfo = new Info();
    private Comment vorbisComment = new Comment();
    private DspState vorbisDspState = new DspState();
    private Block vorbisBlock = new Block(this.vorbisDspState);
    private int index = 0;
    private long calcLength = 0L;
    private float volumeMultiplier = 1.0f;

    public int getNumChannels() {
        return this.vorbisInfo.channels;
    }

    public void setVolumeMultiplier(float v) {
        this.volumeMultiplier = v;
    }

    public int getFreq() {
        return this.vorbisInfo.rate;
    }

    public long getDecodedSize() {
        return this.calcLength;
    }

    public boolean isStreaming() {
        return false;
    }

    private int readFromStream(byte[] buffer, int index, int bufferSize_) {
        int bytes = 0;
        try {
            bytes = this.oggBitStream_.read(buffer, index, bufferSize_);
        }
        catch (Exception e) {
            System.out.println("Cannot read from file");
            bytes = -1;
        }
        return bytes;
    }

    public SoundBuffer getData(SoundDriver driver) {
        if (this.buffer != null) {
            return this.buffer;
        }
        LinkedList<byte[]> chunks = new LinkedList<byte[]>();
        int totalBytes = 0;
        int curBytes = 0;
        this.vorbisDspState.synthesis_init(this.vorbisInfo);
        this.vorbisBlock.init(this.vorbisDspState);
        boolean eos = false;
        float[][][] _pcmf = new float[1][][];
        int[] _index = new int[this.vorbisInfo.channels];
        while (!eos) {
            int result;
            while (!eos && (result = this.oggSyncState_.pageout(this.oggPage_)) != 0) {
                if (result == -1) {
                    System.err.println("Corrupt or missing data in bitstream; continuing...");
                    continue;
                }
                this.oggStreamState_.pagein(this.oggPage_);
                while ((result = this.oggStreamState_.packetout(this.oggPacket_)) != 0) {
                    int samples;
                    if (result == -1) continue;
                    if (this.vorbisBlock.synthesis(this.oggPacket_) == 0) {
                        this.vorbisDspState.synthesis_blockin(this.vorbisBlock);
                    }
                    while ((samples = this.vorbisDspState.synthesis_pcmout(_pcmf, _index)) > 0) {
                        float[][] pcmf = _pcmf[0];
                        int bout = samples < convsize ? samples : convsize;
                        double fVal = 0.0;
                        for (int i = 0; i < this.vorbisInfo.channels; ++i) {
                            int pointer = i * 2;
                            int mono = _index[i];
                            for (int j = 0; j < bout; ++j) {
                                fVal = (double)pcmf[i][mono + j] * 32767.0;
                                int val = (int)(fVal *= (double)this.volumeMultiplier);
                                if (val > Short.MAX_VALUE) {
                                    val = Short.MAX_VALUE;
                                }
                                if (val < Short.MIN_VALUE) {
                                    val = Short.MIN_VALUE;
                                }
                                if (val < 0) {
                                    val |= 0x8000;
                                }
                                if (needs_byte_swap) {
                                    this.convbuffer[pointer + 1] = (byte)val;
                                    this.convbuffer[pointer + 0] = (byte)(val >>> 8);
                                } else {
                                    this.convbuffer[pointer + 0] = (byte)val;
                                    this.convbuffer[pointer + 1] = (byte)(val >>> 8);
                                }
                                pointer += 2 * this.vorbisInfo.channels;
                            }
                        }
                        curBytes = 2 * this.vorbisInfo.channels * bout;
                        totalBytes += curBytes;
                        byte[] chunk = new byte[curBytes];
                        System.arraycopy(this.convbuffer, 0, chunk, 0, curBytes);
                        chunks.add(chunk);
                        this.vorbisDspState.synthesis_read(bout);
                    }
                }
                if (this.oggPage_.eos() == 0) continue;
                eos = true;
            }
            if (eos) continue;
            this.index = this.oggSyncState_.buffer(bufferSize_);
            this.buf = this.oggSyncState_.data;
            this.bytes = this.readFromStream(this.buf, this.index, bufferSize_);
            if (this.bytes == -1) {
                eos = true;
                continue;
            }
            this.oggSyncState_.wrote(this.bytes);
            if (this.bytes != 0) continue;
            eos = true;
        }
        this.oggStreamState_.clear();
        this.vorbisBlock.clear();
        this.vorbisDspState.clear();
        this.vorbisInfo.clear();
        this.buffer = driver.allocateSoundBuffer();
        BufferFormat format = BufferFormat.getFromValues(16, this.getNumChannels());
        this.calcLength = totalBytes;
        this.bbuffer = BufferUtils.createByteBuffer(totalBytes);
        for (byte[] chunk : chunks) {
            this.bbuffer.put(chunk);
        }
        this.buffer.setData(format, totalBytes, this.getFreq(), this.bbuffer);
        return this.buffer;
    }

    public void returnData(SoundDriver driver, SoundBuffer buffer) {
    }

    public void rewind(SoundDriver driver) {
    }

    private void load() {
        OggSoundContainer osc = this;
        osc.index = osc.oggSyncState_.buffer(bufferSize_);
        osc.buf = osc.oggSyncState_.data;
        osc.bytes = osc.readFromStream(osc.buf, osc.index, bufferSize_);
        if (osc.bytes == -1) {
            System.err.println("Cannot get any data from selected Ogg bitstream.");
            return;
        }
        osc.oggSyncState_.wrote(osc.bytes);
        if (osc.oggSyncState_.pageout(osc.oggPage_) != 1) {
            if (osc.bytes < bufferSize_) {
                return;
            }
            System.err.println("Input does not appear to be an Ogg bitstream.");
            return;
        }
        osc.oggStreamState_.init(osc.oggPage_.serialno());
        osc.vorbisInfo.init();
        osc.vorbisComment.init();
        if (osc.oggStreamState_.pagein(osc.oggPage_) < 0) {
            System.err.println("Error reading first page of Ogg bitstream data.");
            return;
        }
        if (osc.oggStreamState_.packetout(osc.oggPacket_) != 1) {
            System.err.println("Error reading initial header packet.");
            return;
        }
        if (osc.vorbisInfo.synthesis_headerin(osc.vorbisComment, osc.oggPacket_) < 0) {
            System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
            return;
        }
        int i = 0;
        while (i < 2) {
            int result;
            while (i < 2 && (result = osc.oggSyncState_.pageout(osc.oggPage_)) != 0) {
                if (result != 1) continue;
                osc.oggStreamState_.pagein(osc.oggPage_);
                while (i < 2 && (result = osc.oggStreamState_.packetout(osc.oggPacket_)) != 0) {
                    if (result == -1) {
                        System.err.println("Corrupt secondary header.  Exiting.");
                        return;
                    }
                    osc.vorbisInfo.synthesis_headerin(osc.vorbisComment, osc.oggPacket_);
                    ++i;
                }
            }
            osc.index = osc.oggSyncState_.buffer(bufferSize_);
            osc.buf = osc.oggSyncState_.data;
            osc.bytes = osc.readFromStream(osc.buf, osc.index, bufferSize_);
            if (osc.bytes == -1) break;
            if (osc.bytes == 0 && i < 2) {
                System.err.println("End of file before finding all Vorbis  headers!");
                return;
            }
            osc.oggSyncState_.wrote(osc.bytes);
        }
        convsize = bufferSize_ / osc.vorbisInfo.channels;
    }

    OggSoundContainer(BufferedInputStream oggBitStream) {
        this.oggSyncState_.init();
        this.oggBitStream_ = oggBitStream;
        this.load();
    }
}

